/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.queclinkadapter.tracker;

import com.sap.sailing.domain.queclinkadapter.FRIReport;
import com.sap.sailing.domain.queclinkadapter.HBDAcknowledgement;
import com.sap.sailing.domain.queclinkadapter.PDPReport;
import com.sap.sailing.domain.queclinkadapter.impl.AbstractMessageVisitor;
import com.sap.sailing.domain.queclinkadapter.impl.HBDServerAcknowledgementImpl;
import com.sap.sailing.domain.queclinkadapter.impl.PositionRelatedReportToGPSFixConverter;
import com.sap.sailing.domain.queclinkadapter.tracker.MessageToDeviceSender;
import com.sap.sailing.domain.racelog.tracking.SensorFixStore;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;

public class MessageVisitorWithSensorFixStore<Backchannel>
extends AbstractMessageVisitor<Void> {
    private final SensorFixStore sensorFixStore;
    private final MessageToDeviceSender messageToDeviceSender;
    private final ConcurrentMap<String, Backchannel> backchannelMapByImei;
    private final Backchannel backchannel;
    private static final PositionRelatedReportToGPSFixConverter gpsFixFactory = new PositionRelatedReportToGPSFixConverter();

    public MessageVisitorWithSensorFixStore(SensorFixStore sensorFixStore, MessageToDeviceSender messageToDeviceSender, ConcurrentMap<String, Backchannel> backchannelMapByImei, Backchannel backchannel) {
        this.sensorFixStore = sensorFixStore;
        this.messageToDeviceSender = messageToDeviceSender;
        this.backchannelMapByImei = backchannelMapByImei;
        this.backchannel = backchannel;
    }

    @Override
    public Void visit(FRIReport friReport) {
        this.backchannelMapByImei.putIfAbsent(friReport.getImei(), this.backchannel);
        gpsFixFactory.ingestFixesToStore(this.sensorFixStore, friReport);
        return null;
    }

    @Override
    public Void visit(PDPReport pdpConnectionReport) {
        this.backchannelMapByImei.putIfAbsent(pdpConnectionReport.getImei(), this.backchannel);
        return null;
    }

    @Override
    public Void visit(HBDAcknowledgement heartbeat) {
        try {
            this.messageToDeviceSender.sendToDevice(gpsFixFactory.getDeviceIdentifier(heartbeat), new HBDServerAcknowledgementImpl(heartbeat.getProtocolVersion(), heartbeat.getCountNumber()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

