/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.tracking.StartTimeChangedListener;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.RaceAbortedHandler;
import com.sap.sailing.domain.tracking.impl.UpdateHandler;
import com.sap.sse.common.TimePoint;
import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sap.sse.util.LaxRedirectStrategyForAllRedirectResponseCodes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.parser.ParseException;

public class StartTimeUpdateHandler
extends UpdateHandler
implements StartTimeChangedListener {
    private static final Logger logger = Logger.getLogger(StartTimeUpdateHandler.class.getName());
    private static final String ACTION = "update_race_start_time";
    private static final String ACTION_START_TRACKING = "start_tracking";
    private static final String FIELD_RACE_START_TIME = "race_start_time";
    private static final String FIELD_TRACKING_START_TIME = "tracking_start_time";
    private final Regatta regatta;
    private final RaceAbortedHandler raceAbortedHandler;

    public StartTimeUpdateHandler(URI updateURI, String username, String password, Serializable tracTracEventId, Serializable raceId, Regatta regatta) {
        super(updateURI, ACTION, username, password, tracTracEventId, raceId);
        this.raceAbortedHandler = new RaceAbortedHandler(updateURI, username, password, tracTracEventId, raceId);
        this.regatta = regatta;
    }

    @Override
    public void startTimeChanged(TimePoint newStartTime) throws MalformedURLException, IOException, URISyntaxException {
        if (this.isActive()) {
            if (newStartTime == null) {
                this.raceAbortedHandler.raceAborted(Flags.AP);
            } else {
                HashMap<String, String> additionalParameters = new HashMap<String, String>();
                additionalParameters.put(FIELD_RACE_START_TIME, String.valueOf(newStartTime.asMillis()));
                URL startTimeUpdateURL = this.buildUpdateURL(additionalParameters);
                logger.info("Using " + this.eraseSecurityRelatedValuesFromURL(startTimeUpdateURL.toString()) + " for the start time update!");
                HttpURLConnection connection = (HttpURLConnection)startTimeUpdateURL.openConnection();
                try {
                    connection = this.setConnectionProperties(connection);
                    try {
                        this.checkAndLogUpdateResponse(connection);
                    }
                    catch (ParseException e) {
                        logger.log(Level.INFO, "Error parsing TracTrac response for start time update", e);
                    }
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    } else {
                        logger.severe("Connection to TracTrac Course Update URL " + this.eraseSecurityRelatedValuesFromURL(startTimeUpdateURL.toString()) + " could not be established");
                    }
                }
                if (this.regatta.isControlTrackingFromStartAndFinishTimes()) {
                    URI startTrackingURI = this.getActionURI(ACTION_START_TRACKING);
                    HttpPost request = new HttpPost(startTrackingURI);
                    List<BasicNameValuePair> params = this.getDefaultParametersAsNewList();
                    params.add(new BasicNameValuePair(FIELD_TRACKING_START_TIME, String.valueOf(newStartTime.minus(TrackedRace.START_TRACKING_THIS_MUCH_BEFORE_RACE_START).asMillis())));
                    request.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                    CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategyForAllRedirectResponseCodes()).build();
                    logger.info("Using " + this.eraseSecurityRelatedValuesFromURL(startTrackingURI.toString()) + " to start tracking");
                    HttpResponse response = client.execute((HttpUriRequest)request);
                    try {
                        this.parseAndLogResponse(new BufferedReader(new InputStreamReader(response.getEntity().getContent(), HttpUrlConnectionHelper.getCharsetFromHttpEntity((HttpEntity)response.getEntity(), (String)"UTF-8"))));
                    }
                    catch (ParseException e) {
                        logger.log(Level.INFO, "Error parsing TracTrac response for start tracking", e);
                    }
                }
            }
        }
    }
}

