/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.ranking;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.ranking.AbstractRankingMetric;
import com.sap.sailing.domain.ranking.NonPerformanceCurveRankingMetric;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.impl.RaceRankComparator;
import com.sap.sailing.domain.tracking.impl.WindwardToGoComparator;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Supplier;

public class OneDesignRankingMetric
extends NonPerformanceCurveRankingMetric {
    private static final long serialVersionUID = -8141113385324184349L;

    public OneDesignRankingMetric(TrackedRace trackedRace) {
        super(trackedRace);
    }

    @Override
    public RankingMetrics getType() {
        return RankingMetrics.ONE_DESIGN;
    }

    @Override
    public Comparator<Competitor> getRaceRankingComparator(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return new RaceRankComparator(this.getTrackedRace(), timePoint, cache);
    }

    @Override
    public Comparator<TrackedLegOfCompetitor> getLegRankingComparator(TrackedLeg trackedLeg, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return new WindwardToGoComparator(trackedLeg, timePoint, cache);
    }

    @Override
    public Duration getGapToLeaderInOwnTime(RankingMetric.RankingInfo rankingInfo, Competitor competitor, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration result;
        Competitor to = rankingInfo.getCompetitorFarthestAhead();
        TrackedLegOfCompetitor currentLegTo = this.getCurrentLegOrLastLegIfAlreadyFinished(to, rankingInfo.getTimePoint());
        if (currentLegTo == null) {
            result = null;
        } else {
            TimePoint tosLegFinishingTime = currentLegTo.getFinishTime();
            Waypoint lastWaypoint = this.getTrackedRace().getRace().getCourse().getLastWaypoint();
            Duration howLongWhoNedsToReachTosPosition = rankingInfo.getCompetitorRankingInfo().apply(competitor).getEstimatedActualDurationFromTimePointToCompetitorFarthestAhead();
            if (howLongWhoNedsToReachTosPosition == null) {
                result = null;
            } else if (tosLegFinishingTime != null && !tosLegFinishingTime.after(rankingInfo.getTimePoint()) && currentLegTo.getTrackedLeg().getLeg().getTo() == lastWaypoint) {
                Duration howLongAgoToPassedTheFinishLine = tosLegFinishingTime.until(rankingInfo.getTimePoint());
                result = howLongWhoNedsToReachTosPosition.plus(howLongAgoToPassedTheFinishLine);
            } else {
                result = howLongWhoNedsToReachTosPosition;
            }
        }
        return result;
    }

    @Override
    public Duration getCorrectedTime(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getActualTimeSinceStartOfRace(competitor, timePoint);
    }

    @Override
    protected Duration getDurationToReachAtEqualPerformance(Competitor who, Competitor to, Waypoint fromWaypoint, TimePoint timePointOfTosPosition, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        MarkPassing whenToPassedFromWaypoint = this.getTrackedRace().getMarkPassing(to, fromWaypoint);
        this.validateGetDurationToReachAtEqualPerformanceParameters(to, fromWaypoint, timePointOfTosPosition, whenToPassedFromWaypoint);
        return whenToPassedFromWaypoint.getTimePoint().until(timePointOfTosPosition);
    }

    @Override
    protected Duration getCalculatedTime(Competitor who, Supplier<Leg> leg, Supplier<Position> estimatedPosition, Duration totalDurationSinceRaceStart, Distance totalWindwardDistanceTraveled) {
        return totalDurationSinceRaceStart;
    }

    @Override
    public Duration getLegGapToLegLeaderInOwnTime(TrackedLegOfCompetitor trackedLegOfCompetitor, TimePoint timePoint, RankingMetric.RankingInfo rankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return trackedLegOfCompetitor.getGapToLeader(timePoint, WindPositionMode.LEG_MIDDLE, rankingInfo, cache);
    }

    @Override
    public RankingMetric.RankingInfo getRankingInfo(final TimePoint timePoint, final WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return new AbstractRankingMetric.AbstractRankingInfo(this, timePoint){
            private static final long serialVersionUID = 25689357311324825L;

            @Override
            public Function<Competitor, RankingMetric.CompetitorRankingInfo> getCompetitorRankingInfo() {
                return competitor -> this.getCompetitorRankingInfo((Competitor)competitor);
            }

            private RankingMetric.CompetitorRankingInfo getCompetitorRankingInfo(final Competitor competitor) {
                return new RankingMetric.CompetitorRankingInfo(){
                    private static final long serialVersionUID = 1164789004900690406L;

                    @Override
                    public TimePoint getTimePoint() {
                        return timePoint;
                    }

                    @Override
                    public Competitor getCompetitor() {
                        return competitor;
                    }

                    @Override
                    public Distance getWindwardDistanceSailed() {
                        return OneDesignRankingMetric.this.getWindwardDistanceTraveled(competitor, timePoint, cache);
                    }

                    @Override
                    public Duration getDurationSinceStartOfRaceUntilTimePoint() {
                        TimePoint startOfRace = OneDesignRankingMetric.this.getTrackedRace().getStartOfRace();
                        return startOfRace == null ? null : startOfRace.until(this.getTimePoint());
                    }

                    @Override
                    public Duration getTimeElapsed() {
                        TimePoint startOfRace = OneDesignRankingMetric.this.getTrackedRace().getStartOfRace();
                        Duration result = startOfRace == null ? null : startOfRace.until(timePoint);
                        return result;
                    }

                    @Override
                    public Duration getCorrectedTime() {
                        return this.getTimeElapsed();
                    }

                    @Override
                    public Duration getEstimatedActualDurationFromTimePointToCompetitorFarthestAhead() {
                        return OneDesignRankingMetric.this.getPredictedDurationToReachWindwardPositionOf(competitor, this.getCompetitorFarthestAhead(), timePoint, cache);
                    }

                    @Override
                    public Duration getCorrectedTimeAtEstimatedArrivalAtCompetitorFarthestAhead() {
                        return this.getEstimatedActualDurationFromRaceStartToCompetitorFarthestAhead();
                    }
                };
            }

            @Override
            public Competitor getCompetitorFarthestAhead() {
                return OneDesignRankingMetric.this.getTrackedRace().getOverallLeader(timePoint, cache);
            }

            @Override
            public Competitor getLeaderByCorrectedEstimatedTimeToCompetitorFarthestAhead() {
                return this.getCompetitorFarthestAhead();
            }
        };
    }
}

