/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.polars;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.confidence.BearingWithConfidence;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.polars.PolarsChangedListener;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;

public interface PolarDataService {
    public SpeedWithConfidence<Void> getSpeed(BoatClass var1, Speed var2, Bearing var3) throws NotEnoughDataHasBeenAddedException;

    public Set<BoatClass> getAllBoatClassesWithPolarSheetsAvailable();

    public void competitorPositionChanged(GPSFixMoving var1, Competitor var2, TrackedRace var3);

    public Set<SpeedWithBearingWithConfidence<Void>> getAverageTrueWindSpeedAndAngleCandidates(BoatClass var1, Speed var2, LegType var3, Tack var4);

    public double getConfidenceForTackJibeSpeedRatio(Speed var1, Speed var2, BoatClass var3);

    public Util.Pair<Double, SpeedWithBearingWithConfidence<Void>> getManeuverLikelihoodAndTwsTwa(BoatClass var1, Speed var2, double var3, ManeuverType var5);

    public PolynomialFunction getSpeedRegressionFunction(BoatClass var1, LegType var2) throws NotEnoughDataHasBeenAddedException;

    public PolynomialFunction getAngleRegressionFunction(BoatClass var1, LegType var2) throws NotEnoughDataHasBeenAddedException;

    public PolynomialFunction getSpeedRegressionFunction(BoatClass var1, double var2) throws NotEnoughDataHasBeenAddedException;

    public BearingWithConfidence<Void> getManeuverAngle(BoatClass var1, ManeuverType var2, Speed var3) throws NotEnoughDataHasBeenAddedException;

    public void raceFinishedLoading(TrackedRace var1);

    public SpeedWithBearingWithConfidence<Void> getAverageSpeedWithTrueWindAngle(BoatClass var1, Speed var2, LegType var3, Tack var4) throws NotEnoughDataHasBeenAddedException;

    public void insertExistingFixes(TrackedRace var1);

    public void registerListener(BoatClass var1, PolarsChangedListener var2);

    public void unregisterListener(BoatClass var1, PolarsChangedListener var2);

    public void registerDomainFactory(DomainFactory var1);

    public void runWithDomainFactory(Consumer<DomainFactory> var1) throws InterruptedException;

    public Map<BoatClass, Long> getFixCountPerBoatClass();

    public SpeedWithBearingWithConfidence<Void> getClosestTwaTws(ManeuverType var1, Speed var2, double var3, BoatClass var5);

    public double getManeuverAngleInDegreesFromTwa(ManeuverType var1, Bearing var2);

    public Util.Pair<List<Speed>, Double> estimateWindSpeeds(BoatClass var1, Speed var2, Bearing var3) throws NotEnoughDataHasBeenAddedException;
}

