/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation;

import com.sap.sailing.domain.base.CPUMeteringType;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.markpassingcalculation.Candidate;
import com.sap.sailing.domain.markpassingcalculation.CandidateChooser;
import com.sap.sailing.domain.markpassingcalculation.CandidateFinder;
import com.sap.sailing.domain.markpassingcalculation.MarkPassingUpdateListener;
import com.sap.sailing.domain.markpassingcalculation.StorePositionUpdateStrategy;
import com.sap.sailing.domain.markpassingcalculation.impl.CandidateChooserImpl;
import com.sap.sailing.domain.markpassingcalculation.impl.CandidateFinderImpl;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprint;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintFactory;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.shared.tracking.impl.TimedComparator;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.util.IntHolder;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MarkPassingCalculator {
    private final DynamicTrackedRace race;
    private CandidateFinder finder;
    private CandidateChooser chooser;
    private static final Logger logger = Logger.getLogger(MarkPassingCalculator.class.getName());
    private final MarkPassingUpdateListener listener;
    private static final ExecutorService executor = ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor();
    private final LinkedBlockingQueue<StorePositionUpdateStrategy> queue;
    public static final int CALCULATOR_VERSION = 2;
    private final StorePositionUpdateStrategy endMarker = new StorePositionUpdateStrategy(){

        @Override
        public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
        }
    };
    private boolean suspended = false;
    private Thread listenerThread;
    private final Listen listen;
    private boolean listenerThreadStarted;
    private final MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry;

    public MarkPassingCalculator(DynamicTrackedRace race, boolean doListen, boolean waitForInitialMarkPassingCalculation, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        this.markPassingRaceFingerprintRegistry = markPassingRaceFingerprintRegistry;
        if (doListen) {
            this.queue = new LinkedBlockingQueue();
            this.listener = new MarkPassingUpdateListener(race, this);
        } else {
            this.listener = null;
            this.queue = null;
        }
        this.race = race;
        this.finder = new CandidateFinderImpl(race, executor);
        this.chooser = new CandidateChooserImpl(race);
        this.listen = this.listener != null ? new Listen() : null;
        Thread t = new Thread(() -> {
            HashSet<Callable> tasks = new HashSet<Callable>();
            for (Competitor c : race.getRace().getCompetitors()) {
                tasks.add(race.getTrackedRegatta().cpuMeterCallable(() -> {
                    Util.Pair<Iterable<Candidate>, Iterable<Candidate>> allCandidates = this.finder.getAllCandidates(c);
                    this.chooser.calculateMarkPassDeltas(c, (Iterable)allCandidates.getA(), (Iterable)allCandidates.getB());
                    return null;
                }, CPUMeteringType.MARK_PASSINGS.name()));
            }
            ThreadPoolUtil.INSTANCE.invokeAllAndLogExceptions(executor, Level.SEVERE, "Error trying to compute initial set of mark passings for race " + race.getRace().getName() + ": %s", tasks);
            if (this.listener != null) {
                MarkPassingCalculator markPassingCalculator = this;
                synchronized (markPassingCalculator) {
                    if (this.listenerThread == null) {
                        this.listenerThread = this.createAndStartListenerThread();
                        Thread thread = this.listenerThread;
                        synchronized (thread) {
                            this.listenerThreadStarted = true;
                            this.listenerThread.notifyAll();
                        }
                    }
                }
            }
        }, "MarkPassingCalculator for race " + race.getRaceIdentifier() + " initialization");
        if (waitForInitialMarkPassingCalculation) {
            t.run();
        } else {
            t.start();
        }
    }

    private Thread createAndStartListenerThread() {
        Thread result = new Thread((Runnable)this.listen, "MarkPassingCalculator for race " + this.race.getRace().getName());
        result.setDaemon(true);
        result.start();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilStopped(long timeoutInMillis) throws InterruptedException {
        long start = System.currentTimeMillis();
        Thread theListenerThread = this.listenerThread;
        if (theListenerThread != null) {
            Thread thread = theListenerThread;
            synchronized (thread) {
                while (!this.listenerThreadStarted && System.currentTimeMillis() - start < timeoutInMillis) {
                    theListenerThread.wait(timeoutInMillis);
                }
            }
            theListenerThread.join(timeoutInMillis);
        }
    }

    public void lockForRead() {
        if (this.listen != null) {
            this.listen.lockForRead();
        }
    }

    public void unlockForRead() {
        if (this.listen != null) {
            this.listen.unlockAfterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        MarkPassingCalculator markPassingCalculator = this;
        synchronized (markPassingCalculator) {
            logger.finest("Suspended MarkPassingCalculator");
            this.suspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        logger.finest("Resumed MarkPassingCalculator");
        this.race.getRace().getCourse().lockForRead();
        try {
            MarkPassingCalculator markPassingCalculator = this;
            synchronized (markPassingCalculator) {
                MarkPassingRaceFingerprint fingerprint = this.markPassingRaceFingerprintRegistry != null ? this.markPassingRaceFingerprintRegistry.getMarkPassingRaceFingerprint((RaceIdentifier)this.race.getRaceIdentifier()) : null;
                if (fingerprint != null && fingerprint.matches(this.race)) {
                    logger.info("Found stored set of mark passings for race " + this.race.getName() + " with matching fingerprint; loading instead of computing...");
                    this.updateMarkPassingsFromRegistry();
                    this.queue.clear();
                    this.stop();
                    this.suspended = false;
                } else {
                    this.suspended = false;
                    final CountDownLatch latchForRunningListenRun = new CountDownLatch(1);
                    this.enqueueUpdate(new StorePositionUpdateStrategy(){

                        @Override
                        public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
                            latchForRunningListenRun.countDown();
                            if (!$assertionsDisabled && latchForRunningListenRun.getCount() != 0L) {
                                throw new AssertionError();
                            }
                        }
                    });
                    if (this.markPassingRaceFingerprintRegistry != null) {
                        new Thread(() -> {
                            try {
                                latchForRunningListenRun.await();
                                Map<Competitor, Map<Waypoint, MarkPassing>> markPassings = this.race.getMarkPassings(true);
                                this.markPassingRaceFingerprintRegistry.storeMarkPassings((RaceIdentifier)this.race.getRaceIdentifier(), MarkPassingRaceFingerprintFactory.INSTANCE.createFingerprint(this.race), markPassings, this.race.getRace().getCourse());
                            }
                            catch (InterruptedException e) {
                                logger.log(Level.SEVERE, "Exception while waiting for Listen.run() to start processing in MarkPassingCalculator for " + this.race.getName(), e);
                            }
                        }, "Waiting for mark passings for " + this.race.getName() + " after having resumed to store the results in registry").start();
                    }
                }
            }
        }
        finally {
            this.race.getRace().getCourse().unlockAfterRead();
        }
    }

    private void updateMarkPassingsFromRegistry() {
        for (Map.Entry<Competitor, Map<Waypoint, MarkPassing>> e : this.markPassingRaceFingerprintRegistry.loadMarkPassings((RaceIdentifier)this.race.getRaceIdentifier(), this.race.getRace().getCourse()).entrySet()) {
            this.race.updateMarkPassings(e.getKey(), e.getValue().values().stream().sorted(TimedComparator.INSTANCE).collect(Collectors.toList()));
        }
    }

    private boolean isEndMarker(StorePositionUpdateStrategy endMarkerCandidate) {
        return endMarkerCandidate == this.endMarker;
    }

    protected synchronized void enqueueUpdate(StorePositionUpdateStrategy update) {
        this.queue.add(update);
        if (!this.suspended) {
            if (this.listenerThread == null) {
                this.listenerThread = this.createAndStartListenerThread();
            } else if (this.listenerThread.getState() == Thread.State.TERMINATED) {
                logger.severe("Listener thread of MarkPassingCalculator (MPC) for race " + this.race.getRace().getName() + " terminated but not null. Why are we still receiving updates? We must have been stopped before!");
            }
        }
    }

    public void stop() {
        logger.info("Stopping " + this + " for race " + this.race.getRace().getName());
        this.enqueueUpdate(this.endMarker);
    }

    public void recalculateEverything() {
        this.finder = new CandidateFinderImpl(this.race, executor);
        this.chooser = new CandidateChooserImpl(this.race);
        for (Competitor c : this.race.getRace().getCompetitors()) {
            Util.Pair<Iterable<Candidate>, Iterable<Candidate>> allCandidates = this.finder.getAllCandidates(c);
            this.chooser.calculateMarkPassDeltas(c, (Iterable)allCandidates.getA(), (Iterable)allCandidates.getB());
        }
    }

    public MarkPassingUpdateListener getListener() {
        return this.listener;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " for " + this.race + " / " + this.race.getTrackedRegatta().getRegatta() + " with chooser " + this.chooser;
    }

    private class Listen
    implements Runnable {
        private final String raceName;
        private final NamedReentrantReadWriteLock lock;

        public Listen() {
            this.raceName = MarkPassingCalculator.this.race.getRace().getName();
            this.lock = new NamedReentrantReadWriteLock("lock for calculation thread (" + Listen.class.getSimpleName() + ") for race " + this.raceName, false);
        }

        public void lockForRead() {
            LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        }

        public void unlockAfterRead() {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                logger.fine("MarkPassingCalculator is listening on race " + this.raceName);
                boolean finished = false;
                HashMap<Competitor, List<GPSFixMoving>> competitorFixes = new HashMap<Competitor, List<GPSFixMoving>>();
                HashMap<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes = new HashMap<Competitor, List<GPSFixMoving>>();
                HashMap<Mark, List<GPSFix>> markFixes = new HashMap<Mark, List<GPSFix>>();
                ArrayList<Waypoint> addedWaypoints = new ArrayList<Waypoint>();
                ArrayList<Waypoint> removedWaypoints = new ArrayList<Waypoint>();
                IntHolder smallestChangedWaypointIndex = new IntHolder(-1);
                ArrayList<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings = new ArrayList<Util.Triple<Competitor, Integer, TimePoint>>();
                ArrayList<Util.Pair<Competitor, Integer>> removedFixedMarkPassings = new ArrayList<Util.Pair<Competitor, Integer>>();
                ArrayList<Util.Pair<Competitor, Integer>> suppressedMarkPassings = new ArrayList<Util.Pair<Competitor, Integer>>();
                ArrayList<Competitor> unsuppressedMarkPassings = new ArrayList<Competitor>();
                boolean hasUnprocessedUpdates = false;
                while (!finished) {
                    block28: {
                        try {
                            try {
                                logger.finer("MPC for " + this.raceName + " is checking the queue");
                                MarkPassingCalculator markPassingCalculator = MarkPassingCalculator.this;
                                synchronized (markPassingCalculator) {
                                    if (!hasUnprocessedUpdates && MarkPassingCalculator.this.queue.isEmpty()) {
                                        finished = true;
                                        MarkPassingCalculator.this.listenerThread = null;
                                    }
                                }
                                LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
                                if (!finished) {
                                    ArrayList<StorePositionUpdateStrategy> allNewFixInsertions = new ArrayList<StorePositionUpdateStrategy>();
                                    try {
                                        allNewFixInsertions.add((StorePositionUpdateStrategy)MarkPassingCalculator.this.queue.take());
                                    }
                                    catch (InterruptedException e) {
                                        logger.log(Level.SEVERE, "MarkPassingCalculator for " + this.raceName + " threw exception " + e.getMessage() + " while waiting for new GPSFixes");
                                    }
                                    MarkPassingCalculator.this.queue.drainTo(allNewFixInsertions);
                                    logger.fine("MPC for " + this.raceName + " received " + allNewFixInsertions.size() + " new updates.");
                                    for (StorePositionUpdateStrategy fixInsertion : allNewFixInsertions) {
                                        if (MarkPassingCalculator.this.isEndMarker(fixInsertion)) {
                                            logger.fine("Stopping " + MarkPassingCalculator.this + "'s listener for race " + this.raceName);
                                            MarkPassingCalculator markPassingCalculator2 = MarkPassingCalculator.this;
                                            synchronized (markPassingCalculator2) {
                                                finished = true;
                                                MarkPassingCalculator.this.listenerThread = null;
                                                break;
                                            }
                                        }
                                        try {
                                            fixInsertion.storePositionUpdate(competitorFixes, competitorFixesThatReplacedExistingOnes, markFixes, addedWaypoints, removedWaypoints, smallestChangedWaypointIndex, fixedMarkPassings, removedFixedMarkPassings, suppressedMarkPassings, unsuppressedMarkPassings, MarkPassingCalculator.this.finder, MarkPassingCalculator.this.chooser);
                                            hasUnprocessedUpdates = true;
                                        }
                                        catch (Exception e) {
                                            logger.log(Level.SEVERE, "Error while calculating markpassings for race " + this.raceName + " while applying update " + fixInsertion + ": " + e.getMessage() + ". Continuing with further updates...", e);
                                        }
                                    }
                                }
                                if (finished || MarkPassingCalculator.this.suspended) break block28;
                                if (smallestChangedWaypointIndex.value != -1) {
                                    Map<Competitor, Util.Pair<List<Candidate>, List<Candidate>>> candidateDeltas;
                                    logger.finer("Handling course change; smallesChangedWaypointIndex==" + smallestChangedWaypointIndex.value + "; waypoints added: " + addedWaypoints + "; waypoints removed: " + removedWaypoints);
                                    Course course = MarkPassingCalculator.this.race.getRace().getCourse();
                                    logger.finer(() -> "Handling course change; smallestChangedWaypointIndex==" + intHolder.value + "; waypoints added: " + addedWaypoints + "; waypoints removed: " + removedWaypoints + "; current course: " + course);
                                    course.lockForRead();
                                    try {
                                        candidateDeltas = MarkPassingCalculator.this.finder.updateWaypoints(addedWaypoints, removedWaypoints, smallestChangedWaypointIndex.value);
                                        MarkPassingCalculator.this.chooser.updateEndProxyNodeWaypointIndex();
                                    }
                                    finally {
                                        course.unlockAfterRead();
                                    }
                                    if (!removedWaypoints.isEmpty()) {
                                        MarkPassingCalculator.this.chooser.removeWaypoints(removedWaypoints);
                                    }
                                    HashSet<Callable> tasks = new HashSet<Callable>();
                                    for (Map.Entry<Competitor, Util.Pair<List<Candidate>, List<Candidate>>> entry : candidateDeltas.entrySet()) {
                                        tasks.add(MarkPassingCalculator.this.race.getTrackedRegatta().cpuMeterCallable(() -> {
                                            Util.Pair pair = (Util.Pair)entry.getValue();
                                            try {
                                                MarkPassingCalculator.this.chooser.calculateMarkPassDeltas((Competitor)entry.getKey(), (Iterable)pair.getA(), (Iterable)pair.getB());
                                                return null;
                                            }
                                            catch (Exception e) {
                                                logger.log(Level.SEVERE, "Exception trying to calculate mark passing deltas for competitor " + entry.getKey(), e);
                                                throw e;
                                            }
                                        }, CPUMeteringType.MARK_PASSINGS.name()));
                                    }
                                    logger.finer(() -> "Calculating mark passing deltas after course change in executor");
                                    ThreadPoolUtil.INSTANCE.invokeAllAndLogExceptions(executor, Level.SEVERE, "Error calculating mark passing deltas after course change in executor: %s", tasks);
                                    logger.finer(() -> "Done calculating mark passing deltas after course change");
                                }
                                this.updateManuallySetMarkPassings(fixedMarkPassings, removedFixedMarkPassings, suppressedMarkPassings, unsuppressedMarkPassings);
                                this.computeMarkPasses(competitorFixes, competitorFixesThatReplacedExistingOnes, markFixes);
                                competitorFixes.clear();
                                competitorFixesThatReplacedExistingOnes.clear();
                                markFixes.clear();
                                addedWaypoints.clear();
                                removedWaypoints.clear();
                                smallestChangedWaypointIndex.value = -1;
                                fixedMarkPassings.clear();
                                removedFixedMarkPassings.clear();
                                suppressedMarkPassings.clear();
                                unsuppressedMarkPassings.clear();
                                hasUnprocessedUpdates = false;
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Error while calculating markpassings for race " + this.raceName + ": " + e.getMessage(), e);
                                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
                            throw throwable;
                        }
                    }
                    LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
                }
            }
            finally {
                logger.fine("MarkPassingCalculator Listen thread terminating for race " + this.raceName);
            }
        }

        private void updateManuallySetMarkPassings(List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unsuppressedMarkPassings) {
            logger.finest("Updating manually edited MarkPassings for race " + this.raceName);
            for (Util.Pair<Competitor, Integer> pair : suppressedMarkPassings) {
                MarkPassingCalculator.this.chooser.suppressMarkPassings((Competitor)pair.getA(), (Integer)pair.getB());
            }
            for (Competitor competitor : unsuppressedMarkPassings) {
                MarkPassingCalculator.this.chooser.stopSuppressingMarkPassings(competitor);
            }
            for (Util.Pair<Competitor, Integer> pair : removedMarkPassings) {
                MarkPassingCalculator.this.chooser.removeFixedPassing((Competitor)pair.getA(), (Integer)pair.getB());
            }
            for (Util.Triple triple : fixedMarkPassings) {
                MarkPassingCalculator.this.chooser.setFixedPassing((Competitor)triple.getA(), (Integer)triple.getB(), (TimePoint)triple.getC());
            }
        }

        private void computeMarkPasses(Map<Competitor, List<GPSFixMoving>> newCompetitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> newMarkFixes) {
            logger.finer("Calculating markpassings for race " + this.raceName + " with " + newCompetitorFixes.size() + " new competitor Fixes and " + newMarkFixes.size() + " new mark fixes.");
            HashMap combinedCompetitorFixesFinderConsidersAffected = new HashMap();
            for (Map.Entry<Competitor, List<GPSFixMoving>> competitorEntry : newCompetitorFixes.entrySet()) {
                LinkedList fixesForCompetitor = new LinkedList();
                combinedCompetitorFixesFinderConsidersAffected.put(competitorEntry.getKey(), fixesForCompetitor);
                fixesForCompetitor.addAll(competitorEntry.getValue());
            }
            if (!newMarkFixes.isEmpty()) {
                for (Map.Entry<Competitor, List<GPSFixMoving>> fixesAffectedByNewMarkFixes : MarkPassingCalculator.this.finder.calculateFixesAffectedByNewMarkFixes(newMarkFixes).entrySet()) {
                    LinkedList fixes = (LinkedList)combinedCompetitorFixesFinderConsidersAffected.get(fixesAffectedByNewMarkFixes.getKey());
                    if (fixes == null) {
                        fixes = new LinkedList();
                        combinedCompetitorFixesFinderConsidersAffected.put(fixesAffectedByNewMarkFixes.getKey(), fixes);
                    }
                    fixes.addAll(fixesAffectedByNewMarkFixes.getValue());
                }
            }
            ArrayList<Callable> tasks = new ArrayList<Callable>();
            for (final Map.Entry competitorAndFixesFinderConsidersAffected : combinedCompetitorFixesFinderConsidersAffected.entrySet()) {
                final ComputeMarkPassings runnable = new ComputeMarkPassings((Competitor)competitorAndFixesFinderConsidersAffected.getKey(), (Iterable)competitorAndFixesFinderConsidersAffected.getValue(), newCompetitorFixes.get(competitorAndFixesFinderConsidersAffected.getKey()), competitorFixesThatReplacedExistingOnes.get(competitorAndFixesFinderConsidersAffected.getKey()));
                tasks.add(MarkPassingCalculator.this.race.getTrackedRegatta().cpuMeterCallable(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        runnable.run();
                        return null;
                    }

                    public String toString() {
                        return "Mark passing calculation for competitor " + competitorAndFixesFinderConsidersAffected.getKey() + " with " + ((Collection)competitorAndFixesFinderConsidersAffected.getValue()).size() + " fixes";
                    }
                }, CPUMeteringType.MARK_PASSINGS.name()));
            }
            ThreadPoolUtil.INSTANCE.invokeAllAndLogExceptions(executor, Level.INFO, "Error during mark passing calculation: %s", tasks);
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + " for race " + this.raceName;
        }

        private class ComputeMarkPassings
        implements Runnable {
            private final Competitor c;
            private final Iterable<GPSFixMoving> fixesFinderConsidersAffected;
            private final List<GPSFixMoving> newCompetitorFixes;
            private final List<GPSFixMoving> competitorFixesThatReplacedExistingOnes;

            public ComputeMarkPassings(Competitor c, Iterable<GPSFixMoving> fixesFinderConsidersAffected, List<GPSFixMoving> newCompetitorFixes, List<GPSFixMoving> competitorFixesThatReplacedExistingOnes) {
                this.c = c;
                this.fixesFinderConsidersAffected = fixesFinderConsidersAffected;
                this.newCompetitorFixes = newCompetitorFixes;
                this.competitorFixesThatReplacedExistingOnes = competitorFixesThatReplacedExistingOnes;
            }

            @Override
            public void run() {
                try {
                    logger.finer(() -> "Calculating MarkPassings for race " + Listen.this.raceName + ", competitor " + this.c + " (" + Util.size(this.fixesFinderConsidersAffected) + " new fixes)");
                    Util.Pair<Iterable<Candidate>, Iterable<Candidate>> candidateDeltas = MarkPassingCalculator.this.finder.getCandidateDeltas(this.c, this.fixesFinderConsidersAffected);
                    logger.finer(() -> "Received " + Util.size((Iterable)((Iterable)candidateDeltas.getA())) + " new Candidates for race " + Listen.this.raceName + " and competitor " + this.c + " and will remove " + Util.size((Iterable)((Iterable)candidateDeltas.getB())) + " old Candidates for " + this.c);
                    MarkPassingCalculator.this.chooser.calculateMarkPassDeltas(this.c, this.newCompetitorFixes, this.competitorFixesThatReplacedExistingOnes, (Iterable)candidateDeltas.getA(), (Iterable)candidateDeltas.getB());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception trying to compute mark passings for competitor " + this.c, e);
                    throw e;
                }
            }
        }
    }
}

