/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.ResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;

public class PerSeriesResultDiscardingRuleImpl
implements ResultDiscardingRule {
    private static final long serialVersionUID = 4596442640424592181L;
    private final Regatta regatta;

    public PerSeriesResultDiscardingRuleImpl(Regatta regatta) {
        this.regatta = regatta;
    }

    @Override
    public Set<RaceColumn> getDiscardedRaceColumns(Competitor competitor, Leaderboard leaderboard, Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint, ScoringScheme scoringScheme) {
        return this.getDiscardedRaceColumns(competitor, leaderboard, raceColumnsToConsider, timePoint, scoringScheme, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Set<RaceColumn> getDiscardedRaceColumns(Competitor competitor, Leaderboard leaderboard, Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint, ScoringScheme scoringScheme, Function<RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        HashSet<RaceColumn> result = new HashSet<RaceColumn>();
        for (Series series : this.regatta.getSeries()) {
            if (series.getResultDiscardingRule() == null) continue;
            Iterable<RaceColumn> columnsToConsiderInSeries = this.getColumnsToConsiderInSeries(series, raceColumnsToConsider);
            result.addAll(series.getResultDiscardingRule().getDiscardedRaceColumns(competitor, leaderboard, columnsToConsiderInSeries, timePoint, scoringScheme, totalPointsSupplier, cache));
        }
        return result;
    }

    private Iterable<RaceColumn> getColumnsToConsiderInSeries(Series series, Iterable<RaceColumn> allRaceColumnsToConsider) {
        LinkedHashSet<RaceColumn> result = new LinkedHashSet<RaceColumn>();
        for (RaceColumn raceColumn : series.getRaceColumns()) {
            if (!Util.contains(allRaceColumnsToConsider, (Object)raceColumn)) continue;
            result.add(raceColumn);
        }
        return result;
    }
}

