/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.sailti.resultimport;

import com.sap.sailing.domain.resultimport.ResultUrlProvider;
import com.sap.sailing.resultimport.ResultDocumentDescriptor;
import com.sap.sailing.resultimport.ResultDocumentProvider;
import com.sap.sailing.resultimport.impl.ResultDocumentDescriptorImpl;
import com.sap.sailing.sailti.resultimport.EventResultDescriptor;
import com.sap.sailing.sailti.resultimport.RegattaResultDescriptor;
import com.sap.sailing.sailti.resultimport.SailtiEventResultsParserImpl;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public class SailtiResultDocumentProvider
implements ResultDocumentProvider {
    private final ResultUrlProvider resultUrlProvider;

    public SailtiResultDocumentProvider(ResultUrlProvider resultUrlProvider) {
        this.resultUrlProvider = resultUrlProvider;
    }

    private URL getDocumentUrlForRegatta(RegattaResultDescriptor regattaResult) {
        return regattaResult.getXrrFinalUrl();
    }

    private boolean acceptRegatta(RegattaResultDescriptor regattaResult) {
        return regattaResult.getPublishedAt() != null;
    }

    public Iterable<ResultDocumentDescriptor> getResultDocumentDescriptors() throws IOException {
        ArrayList<ResultDocumentDescriptor> result = new ArrayList<ResultDocumentDescriptor>();
        for (URL url : this.resultUrlProvider.getReadableUrls()) {
            SailtiEventResultsParserImpl parser = new SailtiEventResultsParserImpl(url);
            URLConnection eventResultConn = HttpUrlConnectionHelper.redirectConnection((URL)url);
            EventResultDescriptor eventResult = parser.getEventResult((InputStream)eventResultConn.getContent());
            this.addResultsForEvent(result, eventResult);
        }
        return result;
    }

    private void addResultsForEvent(List<ResultDocumentDescriptor> result, EventResultDescriptor eventResult) throws IOException {
        if (eventResult != null) {
            for (RegattaResultDescriptor regattaResult : eventResult.getRegattaResults()) {
                if (!this.acceptRegatta(regattaResult)) continue;
                String boatClass = regattaResult.getClassName();
                URL resultUrl = this.getDocumentUrlForRegatta(regattaResult);
                if (resultUrl == null) continue;
                URLConnection regattaResultConn = HttpUrlConnectionHelper.redirectConnection((URL)resultUrl);
                result.add((ResultDocumentDescriptor)new ResultDocumentDescriptorImpl((InputStream)regattaResultConn.getContent(), resultUrl.toString(), regattaResult.getPublishedAt(), eventResult.getName(), regattaResult.getName(), boatClass));
            }
        }
    }
}

