/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.persistence.impl;

import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.impl.AbstractRaceTrackingConnectivityParametersHandler;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.TracTracConfiguration;
import com.sap.sailing.domain.tractracadapter.impl.RaceTrackingConnectivityParametersImpl;
import com.sap.sailing.domain.tractracadapter.impl.TracTracConfigurationImpl;
import com.sap.sailing.domain.tractracadapter.impl.TracTracRaceTrackerImpl;
import com.sap.sailing.domain.tractracadapter.persistence.MongoObjectFactory;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.SessionUtils;
import com.tractrac.model.lib.api.event.CreateModelException;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.util.lib.api.exceptions.TimeOutException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.json.simple.parser.ParseException;

public class TracTracConnectivityParamsHandler
extends AbstractRaceTrackingConnectivityParametersHandler {
    private static final Logger logger = Logger.getLogger(TracTracConnectivityParamsHandler.class.getName());
    private static final String USE_INTERNAL_MARK_PASSING_ALGORITHM = "useInternalMarkPassingAlgorithm";
    private static final String USE_OFFICIAL_EVENTS_TO_UPDATE_RACE_LOG = "useOfficialEventsToUpdateRaceLog";
    private static final String TRAC_TRAC_USERNAME = "tracTracUsername";
    private static final String TRAC_TRAC_PASSWORD = "tracTracPassword";
    private static final String STORED_URI = "storedURI";
    private static final String STORED_URI_FROM_CONFIGURATION = "storedURIFromConfiguration";
    private static final String START_OF_TRACKING_MILLIS = "startOfTrackingMillis";
    private static final String RACE_VISIBILITY = "raceVisibility";
    private static final String RACE_STATUS = "raceStatus";
    private static final String PARAM_URL = "paramURL";
    private static final String OFFSET_TO_START_TIME_OF_SIMULATED_RACE_MILLIS = "offsetToStartTimeOfSimulatedRaceMillis";
    private static final String LIVE_URI = "liveURI";
    private static final String LIVE_URI_FROM_CONFIGURATION = "liveURIFromConfiguration";
    private static final String END_OF_TRACKING_MILLIS = "endOfTrackingMillis";
    private static final String DELAY_TO_LIVE_IN_MILLIS = "delayToLiveInMillis";
    private static final String COURSE_DESIGN_UPDATE_URI = "courseDesignUpdateURI";
    private final RaceLogStore raceLogStore;
    private final RegattaLogStore regattaLogStore;
    private final DomainFactory domainFactory;
    private final MongoObjectFactory tractracMongoObjectFactory;
    private final SecurityService securityService;

    public TracTracConnectivityParamsHandler(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, DomainFactory domainFactory, MongoObjectFactory tractracMongoObjectFactory, SecurityService securityService) {
        this.raceLogStore = raceLogStore;
        this.regattaLogStore = regattaLogStore;
        this.domainFactory = domainFactory;
        this.tractracMongoObjectFactory = tractracMongoObjectFactory;
        this.securityService = securityService;
    }

    public Map<String, Object> mapFrom(RaceTrackingConnectivityParameters params) throws MalformedURLException {
        assert (params instanceof RaceTrackingConnectivityParametersImpl);
        RaceTrackingConnectivityParametersImpl ttParams = (RaceTrackingConnectivityParametersImpl)params;
        Map<String, Object> result = this.getKey(params);
        result.put(COURSE_DESIGN_UPDATE_URI, ttParams.getUpdateURI() == null ? null : ttParams.getUpdateURI().toString());
        result.put(DELAY_TO_LIVE_IN_MILLIS, ttParams.getDelayToLiveInMillis());
        result.put(END_OF_TRACKING_MILLIS, ttParams.getEndOfTracking() == null ? null : Long.valueOf(ttParams.getEndOfTracking().asMillis()));
        result.put(LIVE_URI, ttParams.getLiveURI() == null ? null : ttParams.getLiveURI().toString());
        result.put(OFFSET_TO_START_TIME_OF_SIMULATED_RACE_MILLIS, ttParams.getOffsetToStartTimeOfSimulatedRace() == null ? null : Long.valueOf(ttParams.getOffsetToStartTimeOfSimulatedRace().asMillis()));
        result.put(RACE_STATUS, ttParams.getRaceStatus());
        result.put(RACE_VISIBILITY, ttParams.getRaceVisibility());
        result.put(START_OF_TRACKING_MILLIS, ttParams.getStartOfTracking() == null ? null : Long.valueOf(ttParams.getStartOfTracking().asMillis()));
        result.put(STORED_URI, ttParams.getStoredURI() == null ? null : ttParams.getStoredURI().toString());
        result.put(TRAC_TRAC_PASSWORD, ttParams.getTracTracPassword());
        result.put(TRAC_TRAC_USERNAME, ttParams.getTracTracUsername().toString());
        result.put(USE_INTERNAL_MARK_PASSING_ALGORITHM, ttParams.isUseInternalMarkPassingAlgorithm());
        result.put(USE_OFFICIAL_EVENTS_TO_UPDATE_RACE_LOG, ttParams.isUseOfficialEventsToUpdateRaceLog());
        result.put(LIVE_URI_FROM_CONFIGURATION, ttParams.getLiveURIFromConfiguration() == null ? null : ttParams.getLiveURIFromConfiguration().toString());
        result.put(STORED_URI_FROM_CONFIGURATION, ttParams.getStoredURIFromConfiguration() == null ? null : ttParams.getStoredURIFromConfiguration().toString());
        this.addWindTrackingParameters((RaceTrackingConnectivityParameters)ttParams, result);
        return result;
    }

    public RaceTrackingConnectivityParameters mapTo(Map<String, Object> map) throws Exception {
        return new RaceTrackingConnectivityParametersImpl(new URL(map.get(PARAM_URL).toString()), map.get(LIVE_URI) == null ? null : new URI(map.get(LIVE_URI).toString()), map.get(STORED_URI) == null ? null : new URI(map.get(STORED_URI).toString()), map.get(COURSE_DESIGN_UPDATE_URI) == null ? null : new URI(map.get(COURSE_DESIGN_UPDATE_URI).toString()), (TimePoint)(map.get(START_OF_TRACKING_MILLIS) == null ? null : new MillisecondsTimePoint(((Number)map.get(START_OF_TRACKING_MILLIS)).longValue())), (TimePoint)(map.get(END_OF_TRACKING_MILLIS) == null ? null : new MillisecondsTimePoint(((Number)map.get(END_OF_TRACKING_MILLIS)).longValue())), ((Number)map.get(DELAY_TO_LIVE_IN_MILLIS)).longValue(), (Duration)(map.get(OFFSET_TO_START_TIME_OF_SIMULATED_RACE_MILLIS) == null ? null : new MillisecondsDurationImpl(((Number)map.get(OFFSET_TO_START_TIME_OF_SIMULATED_RACE_MILLIS)).longValue())), ((Boolean)map.get(USE_INTERNAL_MARK_PASSING_ALGORITHM)).booleanValue(), this.raceLogStore, this.regattaLogStore, this.domainFactory, map.get(TRAC_TRAC_USERNAME) == null ? null : map.get(TRAC_TRAC_USERNAME).toString(), map.get(TRAC_TRAC_PASSWORD) == null ? null : map.get(TRAC_TRAC_PASSWORD).toString(), map.get(RACE_STATUS) == null ? null : map.get(RACE_STATUS).toString(), map.get(RACE_VISIBILITY) == null ? null : map.get(RACE_VISIBILITY).toString(), this.isTrackWind(map), this.isCorrectWindDirectionByMagneticDeclination(map), true, 60000, map.get(USE_OFFICIAL_EVENTS_TO_UPDATE_RACE_LOG) == null ? false : (Boolean)map.get(USE_OFFICIAL_EVENTS_TO_UPDATE_RACE_LOG), map.get(LIVE_URI_FROM_CONFIGURATION) == null ? null : new URI(map.get(LIVE_URI_FROM_CONFIGURATION).toString()), map.get(STORED_URI_FROM_CONFIGURATION) == null ? null : new URI(map.get(STORED_URI_FROM_CONFIGURATION).toString()));
    }

    public Map<String, Object> getKey(RaceTrackingConnectivityParameters params) throws MalformedURLException {
        assert (params instanceof RaceTrackingConnectivityParametersImpl);
        RaceTrackingConnectivityParametersImpl ttParams = (RaceTrackingConnectivityParametersImpl)params;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", params.getTypeIdentifier());
        result.put(PARAM_URL, TracTracRaceTrackerImpl.getParamURLStrippedOfRandomParam((URL)new URL(ttParams.getParamURL().toString())).toString());
        return result;
    }

    public RaceTrackingConnectivityParameters resolve(RaceTrackingConnectivityParameters params) throws Exception {
        assert (params instanceof RaceTrackingConnectivityParametersImpl);
        RaceTrackingConnectivityParametersImpl ttParams = (RaceTrackingConnectivityParametersImpl)params;
        RaceTrackingConnectivityParametersImpl result = new RaceTrackingConnectivityParametersImpl(ttParams.getParamURL(), ttParams.getLiveURI(), ttParams.getStoredURI(), ttParams.getUpdateURI(), ttParams.getStartOfTracking(), ttParams.getEndOfTracking(), ttParams.getDelayToLiveInMillis(), ttParams.getOffsetToStartTimeOfSimulatedRace(), ttParams.isUseInternalMarkPassingAlgorithm(), this.raceLogStore, this.regattaLogStore, this.domainFactory, ttParams.getTracTracUsername(), ttParams.getTracTracPassword(), ttParams.getRaceStatus(), ttParams.getRaceVisibility(), ttParams.isTrackWind(), ttParams.isCorrectWindDirectionByMagneticDeclination(), ttParams.isPreferReplayIfAvailable(), ttParams.getTimeoutInMillis(), ttParams.isUseOfficialEventsToUpdateRaceLog(), ttParams.getLiveURIFromConfiguration(), ttParams.getStoredURIFromConfiguration());
        this.updatePersistentTracTracConfiguration(result);
        return result;
    }

    private void updatePersistentTracTracConfiguration(RaceTrackingConnectivityParametersImpl params) throws MalformedURLException, IOException, ParseException, CreateModelException, URISyntaxException, TimeOutException {
        IRace tractracRace = params.getTractracRace();
        String jsonURL = tractracRace.getParameterSet().getParameter("eventJSON");
        if (jsonURL == null) {
            logger.warning("No eventJSON field set in TracTrac race " + tractracRace.getName() + ". Cannot add configuration to list.");
        } else {
            String creatorName = SessionUtils.getPrincipal().toString();
            TracTracConfigurationImpl tracTracConfiguration = new TracTracConfigurationImpl(creatorName, tractracRace.getEvent().getName(), jsonURL, params.getLiveURIFromConfiguration() == null ? null : params.getLiveURIFromConfiguration().toString(), params.isReplayRace(tractracRace) ? null : (params.getStoredURIFromConfiguration() == null ? null : params.getStoredURIFromConfiguration().toString()), params.getUpdateURI() == null ? null : params.getUpdateURI().toString(), params.getTracTracUsername(), params.getTracTracPassword());
            this.tractracMongoObjectFactory.updateTracTracConfiguration((TracTracConfiguration)tracTracConfiguration);
            this.securityService.setDefaultOwnershipIfNotSet(tracTracConfiguration.getIdentifier());
        }
    }
}

