/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.restapi;

import com.sap.sse.common.TimePoint;
import com.sap.sse.landscape.aws.AwsLandscapeState;
import com.sap.sse.landscape.aws.impl.Activator;
import com.sap.sse.landscape.aws.restapi.SSHKeyPairJsonSerializer;
import com.sap.sse.landscape.ssh.SSHKeyPair;
import com.sap.sse.security.jaxrs.AbstractSecurityResource;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.shared.json.JsonSerializer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.subject.Subject;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/landscape")
public class LandscapeResource
extends AbstractSecurityResource {
    private static final Logger logger = Logger.getLogger(LandscapeResource.class.getName());
    private static final JsonSerializer<SSHKeyPair> sshKeyPairJsonSerializer = new SSHKeyPairJsonSerializer();

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/get_ssh_keys_owned_by_user")
    public Response getSshKeysOwnedByUser(@QueryParam(value="username[]") Set<String> usernames) throws IOException {
        JSONArray sshKeysAsJsonArray = new JSONArray();
        AwsLandscapeState landscape = Activator.getInstance().getLandscapeState();
        for (SSHKeyPair sshKeyPair : landscape.getSSHKeyPairs()) {
            if (!usernames.contains(sshKeyPair.getCreatorName()) || !SecurityUtils.getSubject().isPermitted(sshKeyPair.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))) continue;
            sshKeysAsJsonArray.add((Object)sshKeyPairJsonSerializer.serialize((Object)sshKeyPair));
        }
        return Response.ok((Object)this.streamingOutput(sshKeysAsJsonArray)).build();
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/add_ssh_key")
    public Response addSshKey(@FormParam(value="region") String regionId, @FormParam(value="key_name") String keyName, @FormParam(value="public_key") String publicKey, @FormParam(value="encrypted_private_key") String encryptedPrivateKey) throws IOException {
        Response response;
        Subject subject = SecurityUtils.getSubject();
        SSHKeyPair sshKeyPair = new SSHKeyPair(regionId, subject.getPrincipal().toString(), TimePoint.now(), keyName, publicKey.getBytes(), encryptedPrivateKey.getBytes());
        AwsLandscapeState landscape = Activator.getInstance().getLandscapeState();
        try {
            this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(sshKeyPair.getPermissionType(), sshKeyPair.getIdentifier().getTypeRelativeObjectIdentifier(), keyName, () -> landscape.addSSHKeyPair(sshKeyPair));
            response = Response.ok((Object)this.streamingOutput(sshKeyPairJsonSerializer.serialize((Object)sshKeyPair))).build();
        }
        catch (AuthorizationException e) {
            String message = "User " + subject.getPrincipal() + " not authorized to create SSH key pair " + keyName + " in region " + regionId;
            logger.warning(message);
            response = Response.serverError().entity((Object)message).build();
        }
        return response;
    }

    @DELETE
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/delete_ssh_key")
    public Response deleteSshKey(@QueryParam(value="region") String regionId, @QueryParam(value="key_name") String keyName) throws IOException {
        Response result;
        JSONArray sshKeysAsJsonArray = new JSONArray();
        AwsLandscapeState landscape = Activator.getInstance().getLandscapeState();
        SSHKeyPair sshKeyPair = landscape.getSSHKeyPair(regionId, keyName);
        if (sshKeyPair == null) {
            result = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Key " + keyName + " not found in region " + regionId)).build();
        } else {
            SecurityUtils.getSubject().checkPermission(sshKeyPair.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.DELETE));
            landscape.deleteKeyPair(regionId, keyName);
            sshKeysAsJsonArray.add((Object)sshKeyPairJsonSerializer.serialize((Object)sshKeyPair));
            result = Response.ok((Object)this.streamingOutput(sshKeysAsJsonArray)).build();
        }
        return result;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/get_time_point_of_last_change_in_ssh_keys_of_aws_landscape_managers")
    public Response getTimePointOfLastChangeInSshKeysOfAwsLandscapeManagers() throws IOException {
        JSONObject result = new JSONObject();
        TimePoint timePointOfLastChangeOfSetOfLandscapeManagers = Activator.getInstance().getTimePointOfLastChangeOfSetOfLandscapeManagers();
        result.put((Object)"timePointOfLastChangeOfSetOfLandscapeManagers-millis", (Object)timePointOfLastChangeOfSetOfLandscapeManagers.asMillis());
        SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.mmmX");
        result.put((Object)"timePointOfLastChangeOfSetOfLandscapeManagers-iso", (Object)isoDateFormat.format(timePointOfLastChangeOfSetOfLandscapeManagers.asDate()));
        return Response.ok((Object)this.streamingOutput(result)).build();
    }
}

