/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

import com.sap.sse.common.Util;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObscuringIterable<T>
implements Iterable<T> {
    private final Iterable<T> allTs;
    private final Iterable<T> suppressed;

    public ObscuringIterable(Iterable<T> allTs, Iterable<T> suppressed) {
        this.allTs = allTs;
        this.suppressed = suppressed;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator result = this.suppressed == null || Util.isEmpty(this.suppressed) ? this.allTs.iterator() : new Iterator<T>(){
            private final Iterator<T> allIter;
            private T next;
            {
                this.allIter = ObscuringIterable.this.allTs.iterator();
                this.next = this.advance();
            }

            private T advance() {
                this.next = null;
                while (this.allIter.hasNext() && this.next == null) {
                    this.next = this.allIter.next();
                    if (!Util.contains(ObscuringIterable.this.suppressed, this.next)) continue;
                    this.next = null;
                }
                return this.next;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.advance();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return result;
    }
}

