/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.yellowbrickadapter.persistence.impl;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickConfiguration;
import com.sap.sailing.domain.yellowbrickadapter.impl.YellowBrickConfigurationImpl;
import com.sap.sailing.domain.yellowbrickadapter.persistence.DomainObjectFactory;
import com.sap.sailing.domain.yellowbrickadapter.persistence.impl.CollectionNames;
import com.sap.sailing.domain.yellowbrickadapter.persistence.impl.FieldNames;
import com.sap.sailing.domain.yellowbrickadapter.persistence.impl.MongoObjectFactoryImpl;
import java.util.ArrayList;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.types.Binary;

public class DomainObjectFactoryImpl
implements DomainObjectFactory {
    private static final Logger logger = Logger.getLogger(DomainObjectFactoryImpl.class.getName());
    private final MongoDatabase database;

    public DomainObjectFactoryImpl(MongoDatabase db) {
        this.database = db;
    }

    @Override
    public Iterable<YellowBrickConfiguration> getYellowBrickConfigurations() {
        ArrayList<YellowBrickConfiguration> result = new ArrayList<YellowBrickConfiguration>();
        try {
            MongoCollection ybConfigs = this.database.getCollection(CollectionNames.YELLOWBRICK_CONFIGURATIONS.name());
            for (Document o : ybConfigs.find()) {
                YellowBrickConfiguration ybConfig = this.loadYellowBrickConfiguration(o);
                result.add(ybConfig);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load recorded YellowBrick configurations. Check MongoDB settings.", e);
        }
        return result;
    }

    private YellowBrickConfiguration loadYellowBrickConfiguration(Document object) {
        boolean needsUpdate;
        String name = (String)object.get((Object)FieldNames.YB_CONFIG_NAME.name());
        Object usernameObject = object.get((Object)FieldNames.YB_CONFIG_USERNAME.name());
        Object passwordObject = object.get((Object)FieldNames.YB_CONFIG_PASSWORD.name());
        String username = usernameObject == null ? "" : (String)usernameObject;
        String password = passwordObject == null ? "" : new String(Base64.getDecoder().decode(((Binary)passwordObject).getData()));
        String creatorName = (String)object.get((Object)FieldNames.YB_CONFIG_CREATOR_NAME.name());
        String raceURL = (String)object.get((Object)FieldNames.YB_CONFIG_RACE_URL.name());
        boolean bl = needsUpdate = creatorName == null;
        if (needsUpdate) {
            creatorName = "admin";
        }
        YellowBrickConfigurationImpl loadedYellowBrickConfiguration = new YellowBrickConfigurationImpl(name, raceURL, username, password, creatorName);
        if (needsUpdate) {
            new MongoObjectFactoryImpl(this.database).deleteYellowBrickConfiguration(null, raceURL);
            new MongoObjectFactoryImpl(this.database).createYellowBrickConfiguration((YellowBrickConfiguration)loadedYellowBrickConfiguration);
        }
        return loadedYellowBrickConfiguration;
    }
}

