/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.xrr.resultimport.impl;

import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.xrr.resultimport.Parser;
import com.sap.sailing.xrr.resultimport.impl.ScoreCorrectionForRaceResult;
import com.sap.sailing.xrr.schema.Division;
import com.sap.sailing.xrr.schema.Event;
import com.sap.sailing.xrr.schema.Race;
import com.sap.sailing.xrr.schema.RaceResult;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class XRRRegattaResultsAsScoreCorrections
implements RegattaScoreCorrections {
    private final Event event;
    private final Division division;
    private final Parser parser;
    private final ScoreCorrectionProvider provider;

    public XRRRegattaResultsAsScoreCorrections(Event event, Division division, ScoreCorrectionProvider provider, Parser parser) {
        this.event = event;
        this.division = division;
        this.provider = provider;
        this.parser = parser;
    }

    public String getRegattaName() {
        return String.valueOf(this.event.getTitle()) + " (" + this.parser.getBoatClassName(this.division) + ")";
    }

    public ScoreCorrectionProvider getProvider() {
        return this.provider;
    }

    public Iterable<RegattaScoreCorrections.ScoreCorrectionsForRace> getScoreCorrectionsForRaces() {
        ArrayList<RegattaScoreCorrections.ScoreCorrectionsForRace> result = new ArrayList<RegattaScoreCorrections.ScoreCorrectionsForRace>();
        LinkedHashSet<String> raceIDsForWhichWeHaveResults = new LinkedHashSet<String>();
        TreeMap<BigInteger, HashSet<String>> raceNumberToRaceIDs = new TreeMap<BigInteger, HashSet<String>>();
        for (Object e : this.event.getRaceOrDivisionOrRegattaSeriesResult()) {
            if (!(e instanceof Race)) continue;
            Race race = (Race)e;
            BigInteger raceNumber = race.getRaceNumber();
            String raceID = race.getRaceID();
            HashSet<String> raceIDsForRaceNumber = (HashSet<String>)raceNumberToRaceIDs.get(raceNumber);
            if (raceIDsForRaceNumber == null) {
                raceIDsForRaceNumber = new HashSet<String>();
                raceNumberToRaceIDs.put(raceNumber, raceIDsForRaceNumber);
            }
            raceIDsForRaceNumber.add(raceID);
        }
        for (Object e : this.division.getSeriesResultOrRaceResultOrTRResult()) {
            String raceID;
            if (!(e instanceof RaceResult) || raceIDsForWhichWeHaveResults.contains(raceID = ((RaceResult)e).getRaceID())) continue;
            raceIDsForWhichWeHaveResults.add(raceID);
        }
        for (Map.Entry entry : raceNumberToRaceIDs.entrySet()) {
            HashSet intersectionWithRaceIDsForWhichWeHaveResults = new HashSet((Collection)entry.getValue());
            intersectionWithRaceIDsForWhichWeHaveResults.retainAll(raceIDsForWhichWeHaveResults);
            if (intersectionWithRaceIDsForWhichWeHaveResults.isEmpty()) continue;
            result.add(new ScoreCorrectionForRaceResult(this.parser, this.division, (BigInteger)entry.getKey(), (Set)entry.getValue()));
        }
        return result;
    }
}

