/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.CentralAngleDistance;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.RadianBearingImpl;
import com.sap.sailing.domain.common.impl.RadianPosition;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.util.RoundingUtil;

public class AbstractPosition
implements Position {
    private static final long serialVersionUID = -3057027562787541064L;

    public int hashCode() {
        return (int)(4711.0 * this.getLngRad() * this.getLatRad());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        return o instanceof Position && this.getLatRad() == ((Position)o).getLatRad() && this.getLngRad() == ((Position)o).getLngRad();
    }

    @Override
    public double getLngRad() {
        return this.getLngDeg() / 180.0 * Math.PI;
    }

    @Override
    public double getLatRad() {
        return this.getLatDeg() / 180.0 * Math.PI;
    }

    @Override
    public double getLatDeg() {
        return this.getLatRad() / Math.PI * 180.0;
    }

    @Override
    public double getLngDeg() {
        return this.getLngRad() / Math.PI * 180.0;
    }

    @Override
    public double getCentralAngleRad(Position p) {
        double dLat = p.getLatRad() - this.getLatRad();
        double dLon = p.getLngRad() - this.getLngRad();
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(this.getLatRad()) * Math.cos(p.getLatRad()) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        return 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
    }

    @Override
    public Distance getDistance(Position p) {
        Object result = p == this || this.equals(p) ? Distance.NULL : new CentralAngleDistance(this.getCentralAngleRad(p));
        return result;
    }

    @Override
    public double getQuickApproximateNauticalMileDistance(Position p) {
        double latDeg = this.getLatDeg();
        double pLatDeg = p.getLatDeg();
        double latDiffDeg = Math.abs(latDeg - pLatDeg);
        double cosineOfAverageLatitude = Math.cos((latDeg + pLatDeg) / 2.0 / 180.0 * Math.PI);
        double normalizedLngDiffDeg = cosineOfAverageLatitude * Math.abs(this.getLngDeg() - p.getLngDeg());
        return Math.sqrt(latDiffDeg * latDiffDeg + normalizedLngDiffDeg * normalizedLngDiffDeg) * 60.0;
    }

    @Override
    public Bearing getBearingGreatCircle(Position p) {
        RadianBearingImpl bearing;
        if (p != null) {
            double result = Math.atan2(Math.sin(p.getLngRad() - this.getLngRad()) * Math.cos(p.getLatRad()), Math.cos(this.getLatRad()) * Math.sin(p.getLatRad()) - Math.sin(this.getLatRad()) * Math.cos(p.getLatRad()) * Math.cos(p.getLngRad() - this.getLngRad()));
            if (result < 0.0) {
                result += Math.PI * 2;
            }
            bearing = new RadianBearingImpl(result);
        } else {
            bearing = null;
        }
        return bearing;
    }

    @Override
    public Position translateRhumb(Bearing bearing, Distance distance) {
        double distanceRad = distance.getKilometers() / 6371.0;
        double lat1 = this.getLatRad();
        double lon1 = this.getLngRad();
        double bearingRad = bearing.getRadians();
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(distanceRad) + Math.cos(lat1) * Math.sin(distanceRad) * Math.cos(bearingRad));
        double lon2 = lon1 + Math.atan2(Math.sin(bearingRad) * Math.sin(distanceRad) * Math.cos(lat1), Math.cos(distanceRad) - Math.sin(lat1) * Math.sin(lat2));
        lon2 = (lon2 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return new DegreePosition(lat2 / Math.PI * 180.0, lon2 / Math.PI * 180.0);
    }

    @Override
    public Position translateGreatCircle(Bearing bearing, Distance distance) {
        double lat = Math.asin(Math.sin(this.getLatRad()) * Math.cos(distance.getCentralAngleRad()) + Math.cos(this.getLatRad()) * Math.sin(distance.getCentralAngleRad()) * Math.cos(bearing.getRadians()));
        double lng = this.getLngRad() + Math.atan2(Math.sin(bearing.getRadians()) * Math.sin(distance.getCentralAngleRad()) * Math.cos(this.getLatRad()), Math.cos(distance.getCentralAngleRad()) - Math.sin(this.getLatRad()) * Math.sin(lat));
        return new RadianPosition(lat, lng);
    }

    @Override
    public Distance absoluteCrossTrackError(Position p, Bearing bearing) {
        return new CentralAngleDistance(Math.abs(this.crossTrackError(p, bearing).getCentralAngleRad()));
    }

    @Override
    public Distance crossTrackError(Position p, Bearing bearing) {
        return new CentralAngleDistance(Math.asin(Math.sin(p.getCentralAngleRad(this)) * Math.sin(p.getBearingGreatCircle(this).getRadians() - bearing.getRadians())));
    }

    @Override
    public Position projectToLineThrough(Position pos, Bearing bearing) {
        return pos.translateGreatCircle(bearing, this.alongTrackDistance(pos, bearing));
    }

    @Override
    public Distance alongTrackDistance(Position from, Bearing bearing) {
        CentralAngleDistance result;
        if (from != null && bearing != null) {
            double direction = Math.signum(Math.cos(from.getBearingGreatCircle(this).getRadians() - bearing.getRadians()));
            result = new CentralAngleDistance(direction * Math.acos(Math.cos(from.getCentralAngleRad(this)) / Math.cos(this.crossTrackError(from, bearing).getCentralAngleRad())));
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Distance getDistanceToLine(Position left, Position right) {
        Distance crossTrackError = this.crossTrackError(left, left.getBearingGreatCircle(right));
        int factor = crossTrackError.getMeters() > 0.0 ? 1 : -1;
        double toLeft = Math.abs(left.getBearingGreatCircle(this).getDifferenceTo(left.getBearingGreatCircle(right)).getDegrees());
        double toRight = Math.abs(right.getBearingGreatCircle(this).getDifferenceTo(right.getBearingGreatCircle(left)).getDegrees());
        Distance result = toLeft > 90.0 ? this.getDistance(left).scale((double)factor) : (toRight > 90.0 ? this.getDistance(right).scale((double)factor) : crossTrackError);
        return result;
    }

    @Override
    public Position getLocalCoordinates(Position localOrigin, Bearing localEquatorBearing) {
        return this.getTargetCoordinates(localOrigin, localEquatorBearing, new DegreePosition(0.0, 0.0), (Bearing)new DegreeBearingImpl(90.0));
    }

    @Override
    public Position getTargetCoordinates(Position localOrigin, Bearing localEquatorBearing, Position targetOrigin, Bearing targetEquatorBearing) {
        Bearing localBearing = localEquatorBearing.getDifferenceTo(localOrigin.getBearingGreatCircle(this));
        Distance localDistance = this.getDistance(localOrigin);
        return targetOrigin.translateGreatCircle(targetEquatorBearing.add(localBearing), localDistance);
    }

    public String toString() {
        return "(" + this.getLatDeg() + "," + this.getLngDeg() + ")";
    }

    @Override
    public Position getIntersection(Bearing thisBearing, Position to, Bearing toBearing) {
        Distance sumOfDistances2;
        double radBearing1 = thisBearing.getRadians();
        double radLatPos1 = this.getLatRad();
        double radLngPos1 = this.getLngRad();
        double[] greatCircle1 = this.createGreatCircleVector(radBearing1, radLatPos1, radLngPos1);
        double radBearing2 = toBearing.getRadians();
        double radLatPos2 = to.getLatRad();
        double radLngPos2 = to.getLngRad();
        double[] greatCircle2 = this.createGreatCircleVector(radBearing2, radLatPos2, radLngPos2);
        double[] intersection1 = this.computeCrossProductOf3PartVectors(greatCircle1, greatCircle2);
        double[] intersection2 = this.computeCrossProductOf3PartVectors(greatCircle2, greatCircle1);
        Position intersectionPosition1 = this.cartesianVectorToPosition(intersection1);
        Position intersectionPosition2 = this.cartesianVectorToPosition(intersection2);
        Distance sumOfDistances1 = this.getDistance(intersectionPosition1).add(intersectionPosition1.getDistance(to));
        return sumOfDistances1.compareTo((Object)(sumOfDistances2 = this.getDistance(intersectionPosition2).add(intersectionPosition2.getDistance(to)))) < 0 ? intersectionPosition1 : intersectionPosition2;
    }

    @Override
    public SpeedWithBearing getSpeedWithBearingToReachOnGreatCircle(Position to, Duration inTime) {
        Bearing bearing = this.getBearingGreatCircle(to);
        Distance distance = this.getDistance(to);
        Speed speed = distance.inTime(inTime);
        return new KnotSpeedWithBearingImpl(speed.getKnots(), bearing);
    }

    private Position cartesianVectorToPosition(double[] vector) {
        double lat = Math.atan2(vector[2], Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1]));
        double lng = Math.atan2(vector[1], vector[0]);
        return new RadianPosition(lat, lng);
    }

    private double[] computeCrossProductOf3PartVectors(double[] vec1, double[] vec2) {
        double[] crossProduct = new double[]{vec1[1] * vec2[2] - vec1[2] * vec2[1], vec1[2] * vec2[0] - vec1[0] * vec2[2], vec1[0] * vec2[1] - vec1[1] * vec2[0]};
        return crossProduct;
    }

    private double[] createGreatCircleVector(double radBearing, double radLatPos, double radLngPos) {
        double[] greatCircle = new double[]{Math.sin(radLngPos) * Math.cos(radBearing) - Math.sin(radLatPos) * Math.cos(radLngPos) * Math.sin(radBearing), -Math.cos(radLngPos) * Math.cos(radBearing) - Math.sin(radLatPos) * Math.sin(radLngPos) * Math.sin(radBearing), Math.cos(radLatPos) * Math.sin(radBearing)};
        return greatCircle;
    }

    @Override
    public String getAsDegreesAndDecimalMinutesWithCardinalPoints() {
        String lat = String.valueOf(this.getLatDeg() >= 0.0 ? "N" : "S") + this.getDegreesAndDecimalMinutesOfNonNegativeAngle(Math.abs(this.getLatDeg()), 2, 3);
        String lng = String.valueOf(this.getLngDeg() >= 0.0 ? "E" : "W") + this.getDegreesAndDecimalMinutesOfNonNegativeAngle(Math.abs(this.getLngDeg()), 3, 3);
        return String.valueOf(lat) + " " + lng;
    }

    private String getDegreesAndDecimalMinutesOfNonNegativeAngle(double nonNegativeAngle, int degreePlaces, int minuteDecimals) {
        double abs = Math.abs(nonNegativeAngle);
        int integerDegrees = (int)nonNegativeAngle;
        double minutes = RoundingUtil.format((double)((abs - (double)((int)abs)) * 60.0), (int)3);
        if (minutes >= 60.0) {
            minutes -= 60.0;
            ++integerDegrees;
        }
        return String.valueOf(Util.padPositiveValue((double)integerDegrees, (int)degreePlaces, (int)0, (boolean)true)) + "\u00b0" + Util.padPositiveValue((double)minutes, (int)2, (int)minuteDecimals, (boolean)true) + "'";
    }

    @Override
    public String getAsSignedDecimalDegrees() {
        return "(" + this.getLatDeg() + ", " + this.getLngDeg() + ")";
    }
}

