/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sailing.domain.common.impl.KilometersPerHourSpeedImpl;
import com.sap.sailing.domain.common.impl.NauticalMileDistance;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.impl.SecondsDurationImpl;

public abstract class AbstractDistance
implements Distance {
    private static final long serialVersionUID = 4393500221539639333L;

    public boolean equals(Object o) {
        return o instanceof Distance && this.compareTo((Distance)o) == 0;
    }

    public int hashCode() {
        return 0x8B499B ^ (int)this.getMeters();
    }

    public int compareTo(Distance o) {
        double otherMeters;
        double meters = this.getMeters();
        return meters > (otherMeters = o.getMeters()) ? 1 : (meters == otherMeters ? 0 : -1);
    }

    private Speed inSeconds(double seconds) {
        return new KilometersPerHourSpeedImpl(this.getKilometers() * 3600.0 / seconds);
    }

    public Speed inTime(long milliseconds) {
        return new KilometersPerHourSpeedImpl(this.getKilometers() * 1000.0 * 3600.0 / (double)milliseconds);
    }

    public Speed inTime(Duration duration) {
        return this.inSeconds(duration.asSeconds());
    }

    public Duration atSpeed(Speed speed) {
        return new SecondsDurationImpl(this.getMeters() / speed.getMetersPerSecond());
    }

    public double getNauticalMiles() {
        return this.getMeters() / 1852.0;
    }

    public double getMeters() {
        return this.getNauticalMiles() * 1852.0;
    }

    public double getKilometers() {
        return this.getMeters() / 1000.0;
    }

    public double getGeographicalMiles() {
        return this.getMeters() / 1852.2222222222222;
    }

    public double getSeaMiles() {
        return this.getMeters() / 1852.3;
    }

    public double getCentralAngleDeg() {
        return this.getCentralAngleRad() / Math.PI * 180.0;
    }

    public double getCentralAngleRad() {
        return this.getCentralAngleDeg() * Math.PI / 180.0;
    }

    public String toString() {
        return String.valueOf(this.getMeters()) + "m";
    }

    public Distance add(Distance d) {
        return new NauticalMileDistance(this.getNauticalMiles() + d.getNauticalMiles());
    }

    public double divide(Distance other) {
        return this.getMeters() / other.getMeters();
    }

    public Distance abs() {
        AbstractDistance result = this.getMeters() >= 0.0 ? this : this.scale(-1.0);
        return result;
    }
}

