/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.authentication.decorator;

import com.google.gwt.uibinder.client.UiChild;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HeaderPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.authentication.app.AuthenticationContext;
import com.sap.sse.security.ui.authentication.app.NeedsAuthenticationContext;
import com.sap.sse.security.ui.authentication.decorator.NotLoggedInPresenter;
import com.sap.sse.security.ui.authentication.decorator.NotLoggedInView;
import com.sap.sse.security.ui.authentication.decorator.WidgetFactory;
import com.sap.sse.security.ui.client.i18n.StringMessages;

public class AuthorizedContentDecorator
extends Composite
implements RequiresResize,
NeedsAuthenticationContext {
    private final SimplePanel contentHolder = new SimplePanel();
    private Widget content;
    private WidgetFactory contentWidgetFactory;
    private final NotLoggedInView notLoggedInView;
    private SecuredDTO securedDTO;
    private HasPermissions.Action action;

    public AuthorizedContentDecorator(NotLoggedInPresenter presenter, NotLoggedInView notLoggedInView) {
        this.notLoggedInView = notLoggedInView;
        notLoggedInView.setPresenter(presenter);
        notLoggedInView.setSignInText(StringMessages.INSTANCE.signIn());
        this.initWidget((Widget)this.contentHolder);
    }

    @UiChild(limit=1)
    public void addContent(Widget content) {
        this.content = content;
    }

    public void setContentWidgetFactory(WidgetFactory contentWidgetFactory) {
        this.contentWidgetFactory = contentWidgetFactory;
    }

    private Widget getContentWidget() {
        if (this.contentWidgetFactory != null) {
            this.content = this.contentWidgetFactory.get();
            this.contentWidgetFactory = null;
        }
        return this.content;
    }

    protected void onLoad() {
        super.onLoad();
        if (this.getParent() instanceof ProvidesResize || this.getParent() instanceof HeaderPanel) {
            this.contentHolder.setSize("100%", "100%");
        }
    }

    public void onResize() {
        Widget currentContentWidget = this.contentHolder.getWidget();
        if (currentContentWidget instanceof RequiresResize) {
            ((RequiresResize)currentContentWidget).onResize();
        }
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        Widget widget;
        Widget isWidget;
        boolean isAuthenticated = authenticationContext.isLoggedIn();
        boolean isPermitted = this.isPermitted(authenticationContext);
        boolean maySeeRealContent = isAuthenticated && isPermitted;
        Object object = isWidget = maySeeRealContent ? this.getContentWidget() : this.notLoggedInView;
        if (!maySeeRealContent) {
            String message = !isAuthenticated ? StringMessages.INSTANCE.youAreNotSignedIn() : StringMessages.INSTANCE.youDontHaveRequiredPermission();
            this.notLoggedInView.setMessage(message);
        }
        if ((widget = isWidget.asWidget()) instanceof RequiresResize) {
            widget.setSize("100%", "100%");
        }
        this.contentHolder.setWidget(widget);
        if (widget instanceof RequiresResize) {
            ((RequiresResize)widget).onResize();
        }
    }

    private boolean isPermitted(AuthenticationContext userManagementContext) {
        return this.securedDTO == null && this.action == null || userManagementContext.hasPermission(this.securedDTO, this.action);
    }

    public void setPermissionToCheck(SecuredDTO securedDTO, HasPermissions.Action action) {
        this.securedDTO = securedDTO;
        this.action = action;
    }
}

