/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.common.TargetTimeInfo;
import com.sap.sailing.domain.common.Wind;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class TargetTimeInfoSerializer
implements JsonSerializer<TargetTimeInfo> {
    public static final String LEGS = "legs";
    public static final String DURATION_MILLIS = "durationMillis";
    public static final String LEG_START_TIME_MILLIS = "legStartMillis";
    public static final String LEG_DURATION_MILLIS = "legDurationMillis";
    public static final String LEG_DISTANCE_METERS = "legDistanceMeters";
    public static final String LEG_BEARING_DEGREES = "legBearingDegrees";
    public static final String LEG_TRUE_WIND_ANGLE_TO_LEG_DEGREES = "legTrueWindAngleToLegDegrees";
    public static final String LEG_WIND = "legWind";
    public static final String LEG_TYPE = "legType";
    private final JsonSerializer<Wind> windSerializer;

    public TargetTimeInfoSerializer(JsonSerializer<Wind> windSerializer) {
        this.windSerializer = windSerializer;
    }

    public JSONObject serialize(TargetTimeInfo object) {
        JSONArray legsAsJson = new JSONArray();
        JSONObject result = new JSONObject();
        result.put((Object)DURATION_MILLIS, (Object)object.getExpectedDuration().asMillis());
        result.put((Object)LEGS, (Object)legsAsJson);
        for (TargetTimeInfo.LegTargetTimeInfo legInfo : object.getLegTargetTimes()) {
            JSONObject legAsJson = new JSONObject();
            legAsJson.put((Object)LEG_START_TIME_MILLIS, (Object)legInfo.getExpectedStartTimePoint().asMillis());
            legAsJson.put((Object)LEG_DURATION_MILLIS, (Object)legInfo.getExpectedDuration().asMillis());
            legAsJson.put((Object)LEG_DISTANCE_METERS, (Object)legInfo.getDistance().getMeters());
            legAsJson.put((Object)LEG_BEARING_DEGREES, (Object)legInfo.getLegBearing().getDegrees());
            legAsJson.put((Object)LEG_TRUE_WIND_ANGLE_TO_LEG_DEGREES, (Object)legInfo.getTrueWindAngleToLeg().getDegrees());
            legAsJson.put((Object)LEG_TYPE, (Object)legInfo.getLegType().name());
            legAsJson.put((Object)LEG_WIND, (Object)this.windSerializer.serialize((Object)legInfo.getWind()));
            legsAsJson.add((Object)legAsJson);
        }
        return result;
    }
}

