/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.racegroup.impl;

import com.sap.sailing.domain.base.racegroup.RaceRow;
import com.sap.sailing.domain.base.racegroup.SeriesWithRows;
import com.sap.sailing.domain.base.racegroup.impl.SeriesWithRowsImpl;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.ArrayList;
import org.json.simple.JSONObject;

public class SeriesWithRowsDeserializer
implements JsonDeserializer<SeriesWithRows> {
    private JsonDeserializer<RaceRow> raceRowDeserializer;

    public SeriesWithRowsDeserializer(JsonDeserializer<RaceRow> raceRowDeserializer) {
        this.raceRowDeserializer = raceRowDeserializer;
    }

    public SeriesWithRows deserialize(JSONObject object) throws JsonDeserializationException {
        String name = object.get((Object)"name").toString();
        boolean isMedal = (Boolean)object.get((Object)"isMedal");
        Boolean isFleetsCanRunInParallel = (Boolean)object.get((Object)"isFleetsCanRunInParallel");
        if (isFleetsCanRunInParallel == null) {
            isFleetsCanRunInParallel = true;
        }
        ArrayList<RaceRow> rows = new ArrayList<RaceRow>();
        for (Object fleetObject : Helpers.getNestedArraySafe(object, "fleets")) {
            JSONObject fleetJson = Helpers.toJSONObjectSafe(fleetObject);
            rows.add((RaceRow)this.raceRowDeserializer.deserialize(fleetJson));
        }
        return new SeriesWithRowsImpl(name, isMedal, isFleetsCanRunInParallel.booleanValue(), rows);
    }
}

