/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.base.configuration.impl.DeviceConfigurationImpl;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.deserialization.impl.RegattaConfigurationJsonDeserializer;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.ArrayList;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DeviceConfigurationJsonDeserializer
implements JsonDeserializer<DeviceConfiguration> {
    private final JsonDeserializer<RegattaConfiguration> regattaConfigurationDeserializer;

    public static DeviceConfigurationJsonDeserializer create() {
        return new DeviceConfigurationJsonDeserializer(RegattaConfigurationJsonDeserializer.create());
    }

    public DeviceConfigurationJsonDeserializer(JsonDeserializer<RegattaConfiguration> regattaConfigurationDeserializer) {
        this.regattaConfigurationDeserializer = regattaConfigurationDeserializer;
    }

    public DeviceConfiguration deserialize(JSONObject object) throws JsonDeserializationException {
        UUID uuid;
        RegattaConfiguration proceduresConfiguration = null;
        String name = (String)object.get((Object)"name");
        String idAsString = (String)object.get((Object)"idAsString");
        UUID uUID = uuid = idAsString == null ? null : UUID.fromString(idAsString);
        if (object.containsKey((Object)"procedures")) {
            JSONObject proceduresObject = Helpers.getNestedObjectSafe(object, "procedures");
            proceduresConfiguration = (RegattaConfiguration)this.regattaConfigurationDeserializer.deserialize(proceduresObject);
        }
        DeviceConfigurationImpl configuration = new DeviceConfigurationImpl(proceduresConfiguration, uuid, name);
        if (object.containsKey((Object)"courseAreaNames")) {
            JSONArray courseAreaNames = Helpers.getNestedArraySafe(object, "courseAreaNames");
            ArrayList<String> allowedCourseAreaNames = new ArrayList<String>();
            for (Object courseAreaName : courseAreaNames) {
                allowedCourseAreaNames.add(courseAreaName.toString());
            }
            configuration.setAllowedCourseAreaNames(allowedCourseAreaNames);
        }
        if (object.containsKey((Object)"resultsRecipient")) {
            String resultsRecipient = (String)object.get((Object)"resultsRecipient");
            configuration.setResultsMailRecipient(resultsRecipient);
        }
        if (object.containsKey((Object)"byValueCourseNames")) {
            JSONArray namesArray = Helpers.getNestedArraySafe(object, "byValueCourseNames");
            ArrayList<String> names = new ArrayList<String>();
            for (Object courseName : namesArray) {
                names.add(courseName.toString());
            }
            configuration.setByNameDesignerCourseNames(names);
        }
        if (object.containsKey((Object)"eventId")) {
            configuration.setEventId(UUID.fromString((String)object.get((Object)"eventId")));
        }
        if (object.containsKey((Object)"courseAreaId")) {
            configuration.setCourseAreaId(UUID.fromString((String)object.get((Object)"courseAreaId")));
        }
        if (object.containsKey((Object)"priority")) {
            configuration.setPriority(Integer.valueOf(((Number)object.get((Object)"priority")).intValue()));
        }
        return configuration;
    }

    protected DeviceConfigurationImpl createConfiguration(RegattaConfiguration proceduresConfiguration, UUID uuid, String name) {
        return new DeviceConfigurationImpl(proceduresConfiguration, uuid, name);
    }
}

