/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.coursedata.impl;

import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.CourseDataImpl;
import com.sap.sailing.server.gateway.deserialization.coursedata.impl.WaypointDeserializer;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CourseBaseDeserializer
implements JsonDeserializer<CourseBase> {
    private final WaypointDeserializer waypointDeserializer;

    public CourseBaseDeserializer(WaypointDeserializer waypointDeserializer) {
        this.waypointDeserializer = waypointDeserializer;
    }

    public CourseBase deserialize(JSONObject object) throws JsonDeserializationException {
        String courseName = (String)object.get((Object)"name");
        JSONArray jsonWaypoints = (JSONArray)object.get((Object)"waypoints");
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        for (Object waypointObject : jsonWaypoints) {
            JSONObject jsonWaypoint = (JSONObject)waypointObject;
            Waypoint waypoint = this.waypointDeserializer.deserialize(jsonWaypoint);
            waypoints.add(waypoint);
        }
        CourseDataImpl courseBase = new CourseDataImpl(courseName);
        int i = 0;
        while (i < waypoints.size()) {
            courseBase.addWaypoint(i, (Waypoint)waypoints.get(i));
            ++i;
        }
        return courseBase;
    }
}

