/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.sap.sse.common.TimePoint;
import java.util.Deque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

public class OperationQueueByKeyExecutor {
    private static final Logger logger = Logger.getLogger(OperationQueueByKeyExecutor.class.getName());
    private final Executor executor;
    private final ConcurrentMap<Object, Deque<Runnable>> operationQueuesByKey;
    private final ConcurrentMap<Object, Object> monitorsPerKey;

    OperationQueueByKeyExecutor(Executor executor) {
        this.executor = executor;
        this.operationQueuesByKey = new ConcurrentHashMap<Object, Deque<Runnable>>();
        this.monitorsPerKey = new ConcurrentHashMap<Object, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Object keyForAsynchronousExecution, Runnable runnable) {
        boolean queueCreated;
        Object monitorForKey;
        ConcurrentLinkedDeque<Runnable> queueForKey;
        OperationQueueByKeyExecutor operationQueueByKeyExecutor = this;
        synchronized (operationQueueByKeyExecutor) {
            if (this.operationQueuesByKey.containsKey(keyForAsynchronousExecution)) {
                queueForKey = (ConcurrentLinkedDeque<Runnable>)this.operationQueuesByKey.get(keyForAsynchronousExecution);
                monitorForKey = this.monitorsPerKey.get(keyForAsynchronousExecution);
                queueCreated = false;
            } else {
                logger.fine(() -> "Creating operation queue for key " + keyForAsynchronousExecution);
                queueForKey = new ConcurrentLinkedDeque<Runnable>();
                queueCreated = true;
                this.operationQueuesByKey.put(keyForAsynchronousExecution, queueForKey);
                monitorForKey = new Object();
                this.monitorsPerKey.put(keyForAsynchronousExecution, monitorForKey);
            }
        }
        operationQueueByKeyExecutor = monitorForKey;
        synchronized (operationQueueByKeyExecutor) {
            if (queueCreated) {
                this.executor.execute(() -> this.workOnQueueForKey(keyForAsynchronousExecution));
            }
            queueForKey.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workOnQueueForKey(Object keyForAsynchronousExecution) {
        Runnable nextOperation;
        Deque queueForKey;
        int[] count = new int[]{1};
        TimePoint[] started = new TimePoint[1];
        logger.fine(() -> {
            timePointArray[0] = TimePoint.now();
            return "Started work on queue for key " + keyForAsynchronousExecution;
        });
        Object v = this.monitorsPerKey.get(keyForAsynchronousExecution);
        synchronized (v) {
            queueForKey = (Deque)this.operationQueuesByKey.get(keyForAsynchronousExecution);
            nextOperation = (Runnable)queueForKey.pollFirst();
        }
        do {
            nextOperation.run();
            v = this.monitorsPerKey.get(keyForAsynchronousExecution);
            synchronized (v) {
                if (queueForKey.isEmpty()) {
                    nextOperation = null;
                    OperationQueueByKeyExecutor operationQueueByKeyExecutor = this;
                    synchronized (operationQueueByKeyExecutor) {
                        this.monitorsPerKey.remove(keyForAsynchronousExecution);
                        this.operationQueuesByKey.remove(keyForAsynchronousExecution);
                    }
                } else {
                    nextOperation = (Runnable)queueForKey.pollFirst();
                    count[0] = count[0] + 1;
                }
            }
        } while (nextOperation != null);
        logger.fine(() -> "Terminating tasks for operation queue for key " + keyForAsynchronousExecution + " after running " + count[0] + " operations " + "which took " + started[0].until(TimePoint.now()));
    }
}

