/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.criterias;

import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.functions.ParameterProvider;
import com.sap.sse.datamining.impl.criterias.AbstractFilterCriterion;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

public class FunctionValuesFilterCriterion<ElementType>
extends AbstractFilterCriterion<ElementType> {
    private final Function<?> function;
    private final ParameterProvider parameterProvider;
    private final Collection<?> valuesToMatch;

    public FunctionValuesFilterCriterion(Class<ElementType> elementType, Function<?> function, Collection<?> valuesToMatch) {
        this(elementType, function, ParameterProvider.NULL, valuesToMatch);
    }

    public FunctionValuesFilterCriterion(Class<ElementType> elementType, Function<?> function, ParameterProvider parameterProvider, Collection<?> valuesToMatch) {
        super(elementType);
        this.function = function;
        this.parameterProvider = parameterProvider;
        this.valuesToMatch = new HashSet(valuesToMatch);
    }

    @Override
    public boolean matches(ElementType dataEntry) {
        Object value = this.function.tryToInvoke(dataEntry, this.parameterProvider);
        for (Object valueToMatch : this.valuesToMatch) {
            if (!Objects.equals(value, valueToMatch)) continue;
            return true;
        }
        return false;
    }
}

