/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.aggregators;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.components.AdditionalResultDataBuilder;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

public class ParallelGroupedDataCountDistinctAggregationProcessor
extends AbstractParallelGroupedDataAggregationProcessor<Object, Number> {
    private static final AggregationProcessorDefinition<Object, Number> DEFINITION = new SimpleAggregationProcessorDefinition<Object, Number>(Object.class, Number.class, "CountDistinct", ParallelGroupedDataCountDistinctAggregationProcessor.class);
    private ConcurrentHashMap<GroupKey, Set<Object>> countMap = new ConcurrentHashMap();

    public static AggregationProcessorDefinition<Object, Number> getDefinition() {
        return DEFINITION;
    }

    public ParallelGroupedDataCountDistinctAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, Number>, ?>> resultReceivers) {
        super(executor, resultReceivers, "CountDistinct");
    }

    @Override
    protected boolean needsSynchronization() {
        return false;
    }

    @Override
    protected void handleElement(GroupedDataEntry<Object> element) {
        GroupKey key = element.getKey();
        Util.addToValueSet(this.countMap, (Object)key, (Object)element.getDataEntry(), ConcurrentHashMap::newKeySet);
    }

    @Override
    protected Map<GroupKey, Number> getResult() {
        HashMap<GroupKey, Number> result = new HashMap<GroupKey, Number>();
        for (Map.Entry<GroupKey, Set<Object>> e : this.countMap.entrySet()) {
            result.put(e.getKey(), e.getValue().size());
        }
        return result;
    }

    @Override
    protected void setAdditionalData(AdditionalResultDataBuilder additionalDataBuilder) {
        super.setAdditionalData(additionalDataBuilder);
        additionalDataBuilder.setResultDecimals(0);
    }
}

