/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.gateway.impl;

import com.sap.sailing.landscape.gateway.impl.HostJsonSerializer;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.AwsApplicationProcess;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.logging.Logger;
import org.json.simple.JSONObject;

public class AwsApplicationProcessJsonSerializer<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>>
implements JsonSerializer<ProcessT> {
    private static final Logger logger = Logger.getLogger(AwsApplicationProcessJsonSerializer.class.getName());
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String SERVER_DIRECTORY = "serverDirectory";

    public JSONObject serialize(ProcessT object) {
        JSONObject result = new JSONObject();
        result.put((Object)HOST, (Object)new HostJsonSerializer().serialize(object.getHost()));
        result.put((Object)PORT, (Object)object.getPort());
        try {
            result.put((Object)SERVER_DIRECTORY, (Object)object.getServerDirectory(Landscape.WAIT_FOR_PROCESS_TIMEOUT));
        }
        catch (Exception e) {
            logger.warning("Unable to obtain server directory for host " + result.get((Object)HOST) + ":" + result.get((Object)PORT) + ": " + e.getMessage());
        }
        return result;
    }
}

