/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class FilterAndSelectParameters
implements Serializable {
    private static final long serialVersionUID = 8498346319001912273L;
    private final String filter;
    private final String select;
    private final String selectExact;
    private final String filterAndSelect;

    public FilterAndSelectParameters(String filter, String select, String selectExact, String filterAndSelect) {
        this.filter = filter;
        this.select = select;
        this.selectExact = selectExact;
        this.filterAndSelect = filterAndSelect;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getSelect() {
        return this.select;
    }

    public String getSelectExact() {
        return this.selectExact;
    }

    public String getFilterAndSelect() {
        return this.filterAndSelect;
    }

    public String getFilterString() {
        StringJoiner filterString = new StringJoiner(" ");
        if (this.filter != null) {
            filterString.add(this.filter);
        }
        if (this.filterAndSelect != null) {
            filterString.add(this.filterAndSelect);
        }
        return filterString.length() <= 0 && !this.isSelectParameterSet() ? null : filterString.toString();
    }

    public List<String> getSelectList() {
        ArrayList<String> selects = new ArrayList<String>();
        if (this.select != null) {
            selects.add(this.select);
        }
        if (this.filterAndSelect != null) {
            selects.add(this.filterAndSelect);
        }
        return selects;
    }

    private boolean isSelectParameterSet() {
        return this.select != null || this.selectExact != null || this.filterAndSelect != null;
    }

    public boolean isAnyParameterSet() {
        return this.isSelectParameterSet() || this.getFilterString() != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + (this.filterAndSelect == null ? 0 : this.filterAndSelect.hashCode());
        result = 31 * result + (this.select == null ? 0 : this.select.hashCode());
        result = 31 * result + (this.selectExact == null ? 0 : this.selectExact.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterAndSelectParameters other = (FilterAndSelectParameters)obj;
        if (this.filter == null ? other.filter != null : !this.filter.equals(other.filter)) {
            return false;
        }
        if (this.filterAndSelect == null ? other.filterAndSelect != null : !this.filterAndSelect.equals(other.filterAndSelect)) {
            return false;
        }
        if (this.select == null ? other.select != null : !this.select.equals(other.select)) {
            return false;
        }
        return !(this.selectExact == null ? other.selectExact != null : !this.selectExact.equals(other.selectExact));
    }
}

