/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.polarsfitting;

import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.windestimation.aggregator.polarsfitting.CoarseGrainedPointOfSail;

public enum FineGrainedPointOfSail {
    VERY_CLOSE_HAULED_STARBOARD(30, CoarseGrainedPointOfSail.UPWIND_STARBOARD),
    CLOSE_HAULED_STARBOARD(45, CoarseGrainedPointOfSail.UPWIND_STARBOARD),
    CLOSE_REACH_STARBOARD(60, CoarseGrainedPointOfSail.UPWIND_STARBOARD),
    BEAM_REACH_STARBOARD(90, CoarseGrainedPointOfSail.REACHING_STARBOARD),
    BROAD_REACH_STARBOARD(120, CoarseGrainedPointOfSail.DOWNWIND_STARBOARD),
    VERY_BROAD_REACH_STARBOARD(150, CoarseGrainedPointOfSail.DOWNWIND_STARBOARD),
    RUNNING_STARBOARD(175, CoarseGrainedPointOfSail.DOWNWIND_STARBOARD),
    RUNNING_PORT(185, CoarseGrainedPointOfSail.DOWNWIND_PORT),
    VERY_BROAD_REACH_PORT(210, CoarseGrainedPointOfSail.DOWNWIND_PORT),
    BROAD_REACH_PORT(240, CoarseGrainedPointOfSail.DOWNWIND_PORT),
    BEAM_REACH_PORT(270, CoarseGrainedPointOfSail.REACHING_PORT),
    CLOSE_REACH_PORT(300, CoarseGrainedPointOfSail.UPWIND_PORT),
    CLOSE_HAULED_PORT(315, CoarseGrainedPointOfSail.UPWIND_PORT),
    VERY_CLOSE_HAULED_PORT(330, CoarseGrainedPointOfSail.UPWIND_PORT);

    private final int twa;
    private final CoarseGrainedPointOfSail coarseGrainedPointOfSail;

    private FineGrainedPointOfSail(int twa, CoarseGrainedPointOfSail coarseGrainedPointOfSail) {
        this.twa = twa;
        this.coarseGrainedPointOfSail = coarseGrainedPointOfSail;
    }

    public FineGrainedPointOfSail getNextPointOfSail(NauticalSide toSide) {
        int nextOrdinal = 0;
        switch (toSide) {
            case STARBOARD: {
                nextOrdinal = (this.ordinal() + 1) % FineGrainedPointOfSail.values().length;
                break;
            }
            case PORT: {
                nextOrdinal = (this.ordinal() - 1 + FineGrainedPointOfSail.values().length) % FineGrainedPointOfSail.values().length;
            }
        }
        return FineGrainedPointOfSail.values()[nextOrdinal];
    }

    public FineGrainedPointOfSail getNextPointOfSail(double degreesToAdd) {
        double newTwa = ((double)this.getTwa() + degreesToAdd) % 360.0;
        if (newTwa < 0.0) {
            newTwa += 360.0;
        }
        return FineGrainedPointOfSail.valueOf(newTwa);
    }

    public int getDifferenceInDegrees(FineGrainedPointOfSail otherPointOfSail) {
        int deviationDeg = this.getTwa() - otherPointOfSail.getTwa();
        if (deviationDeg < -180) {
            deviationDeg += 360;
        } else if (deviationDeg > 180) {
            deviationDeg -= 360;
        }
        return deviationDeg;
    }

    public LegType getLegType() {
        switch (this) {
            case VERY_BROAD_REACH_STARBOARD: 
            case RUNNING_STARBOARD: 
            case RUNNING_PORT: 
            case VERY_BROAD_REACH_PORT: {
                return LegType.DOWNWIND;
            }
            case VERY_CLOSE_HAULED_STARBOARD: 
            case CLOSE_HAULED_STARBOARD: 
            case CLOSE_HAULED_PORT: 
            case VERY_CLOSE_HAULED_PORT: {
                return LegType.UPWIND;
            }
            case CLOSE_REACH_STARBOARD: 
            case BEAM_REACH_STARBOARD: 
            case BROAD_REACH_STARBOARD: 
            case BROAD_REACH_PORT: 
            case BEAM_REACH_PORT: 
            case CLOSE_REACH_PORT: {
                return LegType.REACHING;
            }
        }
        return null;
    }

    public Tack getTack() {
        switch (this) {
            case VERY_CLOSE_HAULED_STARBOARD: 
            case CLOSE_HAULED_STARBOARD: 
            case CLOSE_REACH_STARBOARD: 
            case BEAM_REACH_STARBOARD: 
            case BROAD_REACH_STARBOARD: 
            case VERY_BROAD_REACH_STARBOARD: 
            case RUNNING_STARBOARD: {
                return Tack.STARBOARD;
            }
            case RUNNING_PORT: 
            case VERY_BROAD_REACH_PORT: 
            case BROAD_REACH_PORT: 
            case BEAM_REACH_PORT: 
            case CLOSE_REACH_PORT: 
            case CLOSE_HAULED_PORT: 
            case VERY_CLOSE_HAULED_PORT: {
                return Tack.PORT;
            }
        }
        return null;
    }

    public int getTwa() {
        return this.twa;
    }

    public CoarseGrainedPointOfSail getCoarseGrainedPointOfSail() {
        return this.coarseGrainedPointOfSail;
    }

    public double getWindCourse(double boatCourseInDegrees) {
        double windCourse = (boatCourseInDegrees - (double)this.twa + 180.0) % 360.0;
        if (windCourse < 0.0) {
            windCourse += 360.0;
        }
        return windCourse;
    }

    public static FineGrainedPointOfSail valueOf(String string) {
        return Enum.valueOf(FineGrainedPointOfSail.class, string);
    }
}

