/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.debranding;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;

public class ClientConfigurationListener
implements ServletRequestListener {
    public static final String DEBRANDING_PROPERTY_NAME = "com.sap.sse.debranding";

    public void requestInitialized(ServletRequestEvent sre) {
        String path;
        if (sre.getServletRequest().getScheme().startsWith("http") && (path = ((HttpServletRequest)sre.getServletRequest()).getServletPath()) != null && (path.endsWith("/") || path.endsWith(".html"))) {
            ServletContext ctx = sre.getServletContext();
            String ctxDebrandingActive = (String)ctx.getAttribute("clientConfigurationContext.debrandingActive");
            boolean deBrandingActive = Boolean.valueOf(System.getProperty(DEBRANDING_PROPERTY_NAME, "true"));
            if (ctxDebrandingActive == null || !Boolean.toString(deBrandingActive).equalsIgnoreCase(ctxDebrandingActive)) {
                this.createReplacementMap(deBrandingActive).forEach((k, v) -> sre.getServletContext().setAttribute("clientConfigurationContext." + k, v));
            }
        }
    }

    public void requestDestroyed(ServletRequestEvent sre) {
    }

    private Map<String, String> createReplacementMap(boolean deBrandingActive) {
        String whitelabeled;
        String title;
        HashMap<String, String> map = new HashMap<String, String>();
        if (deBrandingActive) {
            title = "";
            whitelabeled = "-whitelabeled";
        } else {
            title = "SAP ";
            whitelabeled = "";
        }
        map.put("SAP", title);
        map.put("debrandingActive", Boolean.toString(deBrandingActive));
        map.put("whitelabeled", whitelabeled);
        return map;
    }
}

