/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.datamining.components;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.polars.datamining.data.HasBackendPolarBoatClassContext;
import com.sap.sailing.polars.datamining.data.impl.BoatClassWithBackendPolarContext;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;

public class BackendPolarsBoatClassRetrievalProcessor
extends AbstractRetrievalProcessor<RacingEventService, HasBackendPolarBoatClassContext> {
    public BackendPolarsBoatClassRetrievalProcessor(ExecutorService executor, Collection<Processor<HasBackendPolarBoatClassContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(RacingEventService.class, HasBackendPolarBoatClassContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasBackendPolarBoatClassContext> retrieveData(RacingEventService element) {
        HashSet<HasBackendPolarBoatClassContext> data = new HashSet<HasBackendPolarBoatClassContext>();
        PolarDataService polarDataService = element.getPolarDataService();
        for (BoatClass boatClass : polarDataService.getAllBoatClassesWithPolarSheetsAvailable()) {
            if (this.isAborted()) break;
            data.add(new BoatClassWithBackendPolarContext(boatClass, polarDataService));
        }
        return data;
    }
}

