/*
 * Decompiled with CFR 0.152.
 */
package org.moxieapps.gwt.highcharts.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONBoolean;
import com.google.gwt.json.client.JSONNull;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;

public abstract class Configurable<T> {
    private JSONObject options;

    public T setOption(String path, Object value) {
        if (this.options == null) {
            this.options = new JSONObject();
        }
        this.setOption(this.options, path, value);
        Configurable instance = this;
        return (T)instance;
    }

    public JSONObject getOptions() {
        return this.options;
    }

    private void setOption(JSONObject rootObject, String path, Object value) {
        if (path == null) {
            return;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() <= 0) {
            return;
        }
        String nodeName = path;
        if (nodeName.contains("/")) {
            JSONValue objectAsValue = rootObject.get(nodeName = nodeName.substring(0, nodeName.indexOf("/")));
            if (objectAsValue == null || objectAsValue.isObject() == null) {
                rootObject.put(nodeName, (JSONValue)new JSONObject());
            }
            JSONObject object = (JSONObject)rootObject.get(nodeName);
            this.setOption(object, path.substring(path.indexOf("/") + 1), value);
        } else {
            rootObject.put(nodeName, this.convertToJSONValue(value));
        }
    }

    private JSONValue convertToJSONValue(Object value) {
        if (value == null) {
            return JSONNull.getInstance();
        }
        if (value instanceof JSONValue) {
            return (JSONValue)value;
        }
        if (value instanceof Boolean) {
            return JSONBoolean.getInstance((boolean)((Boolean)value));
        }
        if (value instanceof Number) {
            return new JSONNumber(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return new JSONString((String)value);
        }
        if (value instanceof JavaScriptObject) {
            return new JSONObject((JavaScriptObject)value);
        }
        if (value instanceof Configurable) {
            return ((Configurable)value).getOptions();
        }
        if (value.getClass().isArray()) {
            JSONArray jsonArray = new JSONArray();
            Object[] valueArray = (Object[])value;
            int i = 0;
            int valueArrayLength = valueArray.length;
            while (i < valueArrayLength) {
                Object arrayValue = valueArray[i];
                jsonArray.set(i, this.convertToJSONValue(arrayValue));
                ++i;
            }
            return jsonArray;
        }
        return null;
    }
}

