/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupResolver;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.tracking.AbstractRaceTrackerImpl;
import com.sap.sailing.domain.tracking.DynamicRaceDefinitionSet;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.TrackingDataLoader;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.domain.tracking.impl.EmptyWindStore;
import com.sap.sailing.domain.tracking.impl.TrackedRaceStatusImpl;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.Receiver;
import com.sap.sailing.domain.tractracadapter.TracTracConnectionConstants;
import com.sap.sailing.domain.tractracadapter.TracTracRaceTracker;
import com.sap.sailing.domain.tractracadapter.impl.AbstractLoadingQueueDoneCallBack;
import com.sap.sailing.domain.tractracadapter.impl.RaceAndCompetitorStatusWithRaceLogReconciler;
import com.sap.sailing.domain.tractracadapter.impl.RaceHandleImpl;
import com.sap.sailing.domain.tractracadapter.impl.RaceTrackingConnectivityParametersImpl;
import com.sap.sailing.domain.tractracadapter.impl.Simulator;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.util.impl.ThreadFactoryWithPriority;
import com.tractrac.model.lib.api.event.CreateModelException;
import com.tractrac.model.lib.api.event.DataSource;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.model.lib.api.event.IRaceCompetitor;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.IRaceSubscriber;
import com.tractrac.subscription.lib.api.SubscriberInitializationException;
import com.tractrac.subscription.lib.api.SubscriptionLocator;
import com.tractrac.subscription.lib.api.event.IConnectionStatusListener;
import com.tractrac.subscription.lib.api.event.ILiveDataEvent;
import com.tractrac.subscription.lib.api.event.IStoredDataEvent;
import com.tractrac.subscription.lib.api.race.IRaceCompetitorListener;
import com.tractrac.subscription.lib.api.race.IRacesListener;
import com.tractrac.util.lib.api.exceptions.TimeOutException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TracTracRaceTrackerImpl
extends AbstractRaceTrackerImpl<RaceTrackingConnectivityParametersImpl>
implements IConnectionStatusListener,
TracTracRaceTracker,
DynamicRaceDefinitionSet,
TrackingDataLoader {
    private static final Logger logger = Logger.getLogger(TracTracRaceTrackerImpl.class.getName());
    static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new ThreadFactoryWithPriority(5, Boolean.valueOf(true)));
    static final Integer MAX_STORED_PACKET_HOP_ALLOWANCE = 1000;
    private static final long TIMEOUT_FOR_RACE_TO_APPEAR_FOR_STOPPING_TRACKING_IN_MILLIS = Duration.ONE_MINUTE.times(5L).asMillis();
    private final IEvent tractracEvent;
    private final IRace tractracRace;
    private final Regatta regatta;
    private final IEventSubscriber eventSubscriber;
    private final IRaceSubscriber raceSubscriber;
    private final IRacesListener racesListener;
    private final IRaceCompetitorListener competitorsListener;
    private final Set<Receiver> receivers;
    private final DomainFactory domainFactory;
    private final WindStore windStore;
    private volatile RaceDefinition race;
    private final DynamicTrackedRegatta trackedRegatta;
    private TrackedRaceStatus lastStatus;
    private Map<Object, Util.Pair<Integer, Float>> lastProgressPerID;
    private final Object id;
    private final boolean isLiveTracking;
    private boolean stopped;
    private final TrackedRegattaRegistry trackedRegattaRegistry;
    private final Simulator simulator;
    private final RaceAndCompetitorStatusWithRaceLogReconciler reconciler;

    TracTracRaceTrackerImpl(DomainFactory domainFactory, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, WindStore windStore, TrackedRegattaRegistry trackedRegattaRegistry, RaceLogAndTrackedRaceResolver raceLogResolver, LeaderboardGroupResolver leaderboardGroupResolver, RaceTrackingConnectivityParametersImpl connectivityParams, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) throws URISyntaxException, SubscriberInitializationException, IOException, InterruptedException, CreateModelException, TimeOutException {
        this(null, domainFactory, raceLogStore, regattaLogStore, windStore, trackedRegattaRegistry, raceLogResolver, leaderboardGroupResolver, connectivityParams, timeoutInMilliseconds, raceTrackingHandler, markPassingRaceFingerprintRegistry);
    }

    TracTracRaceTrackerImpl(Regatta regatta, DomainFactory domainFactory, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, WindStore windStore, final TrackedRegattaRegistry trackedRegattaRegistry, RaceLogAndTrackedRaceResolver raceLogResolver, LeaderboardGroupResolver leaderboardGroupResolver, RaceTrackingConnectivityParametersImpl connectivityParams, long timeoutInMilliseconds, final RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) throws URISyntaxException, SubscriberInitializationException, IOException, InterruptedException, CreateModelException, TimeOutException {
        super((RaceTrackingConnectivityParameters)connectivityParams);
        Regatta effectiveRegatta;
        URL paramURL = connectivityParams.getParamURL();
        URI liveURI = connectivityParams.getLiveURI();
        URI storedURI = connectivityParams.getStoredURI();
        URI tracTracUpdateURI = connectivityParams.getUpdateURI();
        TimePoint startOfTracking = connectivityParams.getStartOfTracking();
        TimePoint endOfTracking = connectivityParams.getEndOfTracking();
        long delayToLiveInMillis = connectivityParams.getDelayToLiveInMillis();
        Duration offsetToStartTimeOfSimulatedRace = connectivityParams.getOffsetToStartTimeOfSimulatedRace();
        boolean useInternalMarkPassingAlgorithm = connectivityParams.isUseInternalMarkPassingAlgorithm();
        String tracTracUsername = connectivityParams.getTracTracUsername();
        String tracTracPassword = connectivityParams.getTracTracPassword();
        String raceStatus = connectivityParams.getRaceStatus();
        String raceVisibility = connectivityParams.getRaceVisibility();
        boolean useOfficialEventsToUpdateRaceLog = connectivityParams.isUseOfficialEventsToUpdateRaceLog();
        this.trackedRegattaRegistry = trackedRegattaRegistry;
        this.tractracRace = connectivityParams.getTractracRace();
        this.tractracEvent = this.tractracRace.getEvent();
        this.id = TracTracRaceTrackerImpl.createID(paramURL, liveURI, storedURI);
        this.isLiveTracking = liveURI != null;
        this.race = null;
        this.domainFactory = domainFactory;
        this.lastProgressPerID = new HashMap<Object, Util.Pair<Integer, Float>>();
        if (offsetToStartTimeOfSimulatedRace != null) {
            this.simulator = new Simulator(windStore, offsetToStartTimeOfSimulatedRace);
            this.windStore = EmptyWindStore.INSTANCE;
        } else {
            this.simulator = null;
            this.windStore = windStore;
        }
        URI effectiveStoredURI = raceStatus != null && raceStatus.equals(TracTracConnectionConstants.REPLAY_STATUS) || raceVisibility != null && raceVisibility.equals(TracTracConnectionConstants.REPLAY_VISIBILITY) ? this.checkForCachedStoredData(storedURI) : storedURI;
        logger.info("Starting race tracker: " + this.tractracRace.getName() + " " + paramURL + " " + liveURI + " " + effectiveStoredURI + " startOfTracking:" + (startOfTracking != null ? Long.valueOf(startOfTracking.asMillis()) : "n/a") + " endOfTracking:" + (endOfTracking != null ? Long.valueOf(endOfTracking.asMillis()) : "n/a"));
        this.eventSubscriber = domainFactory.getOrCreateEventSubscriber(this.tractracEvent, liveURI, effectiveStoredURI);
        this.reconciler = useOfficialEventsToUpdateRaceLog ? new RaceAndCompetitorStatusWithRaceLogReconciler(domainFactory, (RaceLogResolver)raceLogResolver, this.tractracRace) : null;
        this.racesListener = new IRacesListener(){

            public void abandonRace(long timestamp, UUID raceId) {
            }

            public void addRace(long timestamp, IRace race) {
            }

            public void deleteRace(long timestamp, UUID raceId) {
            }

            public void reloadRace(long timestamp, UUID raceId) {
                if (raceId.equals(TracTracRaceTrackerImpl.this.tractracRace.getId())) {
                    logger.warning("reloadRace(" + raceId + ") for race " + TracTracRaceTrackerImpl.this.tractracRace + " in event " + TracTracRaceTrackerImpl.this.tractracEvent + " not supported yet. Consider re-loading the race manually");
                }
            }

            public void startTracking(long timestamp, UUID raceId) {
            }

            public void dataSourceChanged(long timestamp, IRace race, DataSource oldDataSource, URI oldLiveURI, URI oldStoredURI) {
            }

            public void updateRace(long timestamp, IRace race) {
                if (Util.equalsWithNull((Object)race.getId(), (Object)TracTracRaceTrackerImpl.this.tractracRace.getId())) {
                    DynamicTrackedRace trackedRace;
                    int delayToLiveInMillis = race.getLiveDelay() * 1000;
                    if (TracTracRaceTrackerImpl.this.getRace() != null && (trackedRace = TracTracRaceTrackerImpl.this.getTrackedRegatta().getExistingTrackedRace(TracTracRaceTrackerImpl.this.getRace())) != null) {
                        if (TracTracRaceTrackerImpl.this.reconciler != null) {
                            logger.info("Handling a race status update for race " + race.getName() + " with status " + race.getStatus() + " and status time " + race.getStatusLastChangedTime());
                            TracTracRaceTrackerImpl.this.reconciler.reconcileRaceStatus(race, (TrackedRace)trackedRace);
                        }
                        logger.info("Setting delay to live for race " + trackedRace.getRace().getName() + " to " + delayToLiveInMillis + "ms");
                        trackedRace.setDelayToLiveInMillis((long)delayToLiveInMillis);
                    }
                }
            }
        };
        this.eventSubscriber.subscribeRaces(this.racesListener);
        this.raceSubscriber = SubscriptionLocator.getSusbcriberFactory().createRaceSubscriber(this.tractracRace, liveURI, effectiveStoredURI);
        this.raceSubscriber.subscribeConnectionStatus((IConnectionStatusListener)this);
        if (regatta == null) {
            Serializable raceID = domainFactory.getRaceID(this.tractracRace);
            effectiveRegatta = trackedRegattaRegistry.getRememberedRegattaForRace(raceID);
        } else {
            effectiveRegatta = regatta;
        }
        Regatta regattaInWhichToTryToRemoveExistingRace = effectiveRegatta == null ? domainFactory.getOrCreateDefaultRegatta(raceLogStore, regattaLogStore, this.tractracRace, trackedRegattaRegistry) : effectiveRegatta;
        RaceDefinition raceDefinition = domainFactory.removeRace(this.tractracRace.getEvent(), this.tractracRace, regattaInWhichToTryToRemoveExistingRace, trackedRegattaRegistry);
        if (raceDefinition != null) {
            trackedRegattaRegistry.removeRace(regattaInWhichToTryToRemoveExistingRace, raceDefinition);
        }
        this.regatta = effectiveRegatta == null ? domainFactory.getOrCreateDefaultRegatta(raceLogStore, regattaLogStore, this.tractracRace, trackedRegattaRegistry) : effectiveRegatta;
        this.trackedRegatta = trackedRegattaRegistry.getOrCreateTrackedRegatta(this.regatta);
        this.receivers = new HashSet<Receiver>();
        for (Receiver receiver : domainFactory.getUpdateReceivers(this.getTrackedRegatta(), delayToLiveInMillis, this.simulator, windStore, this, trackedRegattaRegistry, raceLogResolver, markPassingRaceFingerprintRegistry, leaderboardGroupResolver, this.tractracRace, tracTracUpdateURI, tracTracUsername, tracTracPassword, this.eventSubscriber, this.raceSubscriber, useInternalMarkPassingAlgorithm, timeoutInMilliseconds, raceTrackingHandler, this.reconciler)) {
            this.receivers.add(receiver);
        }
        this.competitorsListener = new IRaceCompetitorListener(){

            public void addRaceCompetitor(long timestamp, IRaceCompetitor raceCompetitor) {
                try {
                    trackedRegattaRegistry.updateRaceCompetitors(TracTracRaceTrackerImpl.this.getRegatta(), TracTracRaceTrackerImpl.this.getRace());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void updateRaceCompetitor(long timestamp, IRaceCompetitor raceCompetitor) {
                if (!raceCompetitor.getCompetitor().isNonCompeting()) {
                    TracTracRaceTrackerImpl.this.domainFactory.updateCompetitor(raceCompetitor.getCompetitor(), raceTrackingHandler);
                }
            }

            public void deleteRaceCompetitor(long timestamp, UUID competitorId) {
                try {
                    trackedRegattaRegistry.updateRaceCompetitors(TracTracRaceTrackerImpl.this.getRegatta(), TracTracRaceTrackerImpl.this.getRace());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void removeOffsetPositions(long timestamp, UUID competitorId, int offset) {
            }
        };
        this.raceSubscriber.subscribeRaceCompetitor(this.competitorsListener);
        this.addListenersForStoredDataAndStartController(this.receivers);
    }

    private URI checkForCachedStoredData(URI storedURI) {
        String directory;
        String CACHE_DIR_PROPERTY = "tractrac.mtb.cache.dir";
        if (System.getProperty("tractrac.mtb.cache.dir") != null && new File(directory = System.getProperty("tractrac.mtb.cache.dir")).exists()) {
            String directoryAndFileName;
            block20: {
                String[] pathFragments = storedURI.getPath().split("\\/");
                String mtbFileName = pathFragments[pathFragments.length - 1];
                directoryAndFileName = String.valueOf(directory) + "/" + mtbFileName;
                File f = new File(directoryAndFileName);
                if (!f.exists()) {
                    FileOutputStream mtbOutStream = null;
                    try {
                        try {
                            int count;
                            logger.info("Starting to download " + storedURI + " to cache dir " + directoryAndFileName);
                            InputStream in = storedURI.toURL().openStream();
                            mtbOutStream = new FileOutputStream(f);
                            byte[] data = new byte[1024];
                            while ((count = in.read(data, 0, 1024)) != -1) {
                                mtbOutStream.write(data, 0, count);
                            }
                            logger.info("Finished downloading file to cache!");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            if (mtbOutStream != null) {
                                try {
                                    mtbOutStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        if (mtbOutStream != null) {
                            try {
                                mtbOutStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (mtbOutStream != null) {
                        try {
                            mtbOutStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    logger.info("Found file " + directoryAndFileName + "! Reusing it for this race!");
                }
            }
            try {
                return new URI("file:///" + directoryAndFileName);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return storedURI;
    }

    public DynamicTrackedRegatta getTrackedRegatta() {
        return this.trackedRegatta;
    }

    public static Object createID(URL paramURL, URI liveURI, URI storedURI) {
        return TracTracRaceTrackerImpl.getParamURLStrippedOfRandomParam(paramURL);
    }

    public static URL getParamURLStrippedOfRandomParam(URL paramURL) {
        URL paramURLStrippedOfRandomParam;
        if (paramURL == null) {
            paramURLStrippedOfRandomParam = null;
        } else {
            String query = paramURL.getQuery();
            if (query == null) {
                paramURLStrippedOfRandomParam = paramURL;
            } else {
                String[] queryParams;
                StringJoiner stringJoiner = new StringJoiner("&", "?", "");
                stringJoiner.setEmptyValue("");
                String[] stringArray = queryParams = query.split("&");
                int n = queryParams.length;
                int n2 = 0;
                while (n2 < n) {
                    String queryParam = stringArray[n2];
                    String[] nameValue = queryParam.split("=");
                    if (!"random".equalsIgnoreCase(nameValue[0])) {
                        StringBuilder param = new StringBuilder();
                        param.append(nameValue[0]);
                        if (nameValue.length > 1) {
                            param.append('=');
                            param.append(nameValue[1]);
                        }
                        stringJoiner.add(param.toString());
                    }
                    ++n2;
                }
                try {
                    paramURLStrippedOfRandomParam = new URL(paramURL.getProtocol(), paramURL.getHost(), paramURL.getPort(), String.valueOf(paramURL.getPath()) + stringJoiner.toString() + (paramURL.getRef() == null || paramURL.getRef().isEmpty() ? "" : "#" + paramURL.getRef()));
                }
                catch (MalformedURLException e) {
                    logger.log(Level.SEVERE, "Error trying to strip the \"random\" parameter from the TracTrac params_url " + paramURL, e);
                    paramURLStrippedOfRandomParam = paramURL;
                }
            }
        }
        return paramURLStrippedOfRandomParam;
    }

    public Object getID() {
        return this.id;
    }

    public WindStore getWindStore() {
        return this.windStore;
    }

    public RaceHandle getRaceHandle() {
        return new RaceHandleImpl(this.domainFactory, this.tractracRace, this.getTrackedRegatta(), this);
    }

    public RaceDefinition getRace() {
        return this.race;
    }

    protected void addListenersForStoredDataAndStartController(Iterable<Receiver> listenersForStoredData) {
        for (Receiver receiver : listenersForStoredData) {
            receiver.subscribe();
        }
        this.eventSubscriber.start();
        this.raceSubscriber.start();
    }

    public Regatta getRegatta() {
        return this.regatta;
    }

    protected void onStop(boolean stopReceiversPreemtively, final boolean willBeRemoved) throws InterruptedException {
        if (!this.stopped) {
            this.stopped = true;
            this.eventSubscriber.unsubscribeRaces(this.racesListener);
            this.raceSubscriber.unsubscribeRaceCompetitor(this.competitorsListener);
            this.raceSubscriber.stop();
            this.eventSubscriber.stop();
            this.raceSubscriber.unsubscribeConnectionStatus((IConnectionStatusListener)this);
            for (Receiver receiver : this.receivers) {
                if (stopReceiversPreemtively) {
                    receiver.stopPreemptively();
                    continue;
                }
                receiver.stopAfterProcessingQueuedEvents();
            }
            if (!stopReceiversPreemtively) {
                new AbstractLoadingQueueDoneCallBack(this.receivers){

                    @Override
                    protected void executeWhenAllReceiversAreDoneLoading() {
                        TracTracRaceTrackerImpl.this.lastStatus = (TrackedRaceStatus)new TrackedRaceStatusImpl(willBeRemoved ? TrackedRaceStatusEnum.REMOVED : TrackedRaceStatusEnum.FINISHED, 1.0);
                        TracTracRaceTrackerImpl.this.updateStatusOfTrackedRaces();
                    }
                };
            } else {
                this.lastStatus = new TrackedRaceStatusImpl(willBeRemoved ? TrackedRaceStatusEnum.REMOVED : TrackedRaceStatusEnum.FINISHED, 1.0);
                this.updateStatusOfTrackedRaces();
            }
            if (stopReceiversPreemtively && this.simulator != null) {
                this.simulator.stop();
            }
        }
    }

    private void updateStatusOfTrackedRaces() {
        DynamicTrackedRace trackedRace;
        if (this.getRace() != null && (trackedRace = this.getTrackedRegatta().getExistingTrackedRace(this.getRace())) != null) {
            this.updateStatusOfTrackedRace(trackedRace);
        }
    }

    private void updateStatusOfTrackedRace(DynamicTrackedRace trackedRace) {
        if (this.lastStatus != null && trackedRace.getStatus() != null && trackedRace.getStatus().getStatus() != TrackedRaceStatusEnum.FINISHED) {
            Object status = this.lastStatus.getStatus() == TrackedRaceStatusEnum.FINISHED ? new TrackedRaceStatusImpl(this.lastStatus.getStatus(), trackedRace.getStatus() == null ? 0.0 : trackedRace.getStatus().getLoadingProgress()) : this.lastStatus;
            trackedRace.onStatusChanged((TrackingDataLoader)this, status);
        }
    }

    private void storedDataProgress(final float progress) {
        if (this.lastStatus.getStatus().equals((Object)TrackedRaceStatusEnum.ERROR)) {
            return;
        }
        Integer counter = 0;
        Util.Pair<Integer, Float> lastProgressPair = this.lastProgressPerID.get(this.getID());
        if (lastProgressPair != null) {
            Float lastProgress = (Float)lastProgressPair.getB();
            counter = (Integer)lastProgressPair.getA();
            if (progress < lastProgress.floatValue()) {
                if (counter > MAX_STORED_PACKET_HOP_ALLOWANCE) {
                    try {
                        logger.severe("Got " + MAX_STORED_PACKET_HOP_ALLOWANCE + " times a value for progress " + progress + " that is lower than one already received " + lastProgress + "! This is a severe error - stopping receivers for " + this.getID() + " now!");
                        this.stop(true);
                        this.lastStatus = new TrackedRaceStatusImpl(TrackedRaceStatusEnum.ERROR, 0.0);
                        this.updateStatusOfTrackedRaces();
                        return;
                    }
                    catch (Exception e) {
                        logger.severe("Exception stopping race tracker: " + e.getMessage());
                        e.printStackTrace();
                    }
                } else {
                    counter = counter + 1;
                }
            }
        }
        logger.info("Stored data progress in tracker " + this.getID() + " for race(s) " + this.getRace() + ": " + progress);
        this.lastStatus = new TrackedRaceStatusImpl(TrackedRaceStatusEnum.LOADING, (double)progress);
        if ((double)progress == 1.0) {
            new AbstractLoadingQueueDoneCallBack(this.receivers){

                @Override
                protected void executeWhenAllReceiversAreDoneLoading() {
                    TracTracRaceTrackerImpl.this.lastStatus = (TrackedRaceStatus)new TrackedRaceStatusImpl(TrackedRaceStatusEnum.TRACKING, (double)progress);
                    TracTracRaceTrackerImpl.this.updateStatusOfTrackedRaces();
                }
            };
        }
        this.lastProgressPerID.put(this.getID(), (Util.Pair<Integer, Float>)new Util.Pair((Object)counter, (Object)Float.valueOf(progress)));
        this.updateStatusOfTrackedRaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRaceDefinition(RaceDefinition race, DynamicTrackedRace trackedRace) {
        logger.info("Setting race for tracker " + this + " with ID " + this.getID() + " to " + race);
        TracTracRaceTrackerImpl tracTracRaceTrackerImpl = this;
        synchronized (tracTracRaceTrackerImpl) {
            this.race = race;
        }
        this.updateStatusOfTrackedRace(trackedRace);
        this.registerRaceAndCompetitorStatusWithRaceLogReconciler(trackedRace);
        this.notifyRaceCreationListeners();
    }

    private void registerRaceAndCompetitorStatusWithRaceLogReconciler(final DynamicTrackedRace trackedRace) {
        if (this.reconciler != null) {
            trackedRace.addListener((RaceChangeListener)new AbstractRaceChangeListener(){

                public void raceLogAttached(RaceLog raceLog) {
                    TracTracRaceTrackerImpl.this.reconciler.raceLogAttached((TrackedRace)trackedRace, raceLog);
                }

                public void raceLogDetached(RaceLog raceLog) {
                    TracTracRaceTrackerImpl.this.reconciler.raceLogDetached((TrackedRace)trackedRace, raceLog);
                }
            });
            for (RaceLog alreadyAttachedRaceLog : trackedRace.getAttachedRaceLogs()) {
                this.reconciler.raceLogAttached((TrackedRace)trackedRace, alreadyAttachedRaceLog);
            }
        }
    }

    public void raceNotLoaded(String reason) throws MalformedURLException, IOException, InterruptedException {
        logger.severe("Race for tracker " + this + " with ID " + this.getID() + " did not load: " + reason + ". Stopping tracker.");
        if (this.race != null) {
            if (this.race == null) {
                this.trackedRegattaRegistry.stopTracker(this.regatta, (RaceTracker)this);
            } else {
                this.trackedRegattaRegistry.stopTracking(this.regatta, this.race);
            }
        }
    }

    public void gotLiveDataEvent(ILiveDataEvent liveDataEvent) {
        logger.info("Status change in tracker " + this.getID() + " for race(s) " + this.getRace() + ": " + liveDataEvent);
    }

    public void gotStoredDataEvent(IStoredDataEvent storedDataEvent) {
        logger.info("Status change in tracker " + this + " with ID " + this.getID() + " for race(s) " + this.getRace() + ": " + storedDataEvent);
        switch (storedDataEvent.getType()) {
            case Begin: {
                logger.info("Stored data begin in tracker " + this.getID() + " for race(s) " + this.getRace());
                this.lastStatus = new TrackedRaceStatusImpl(TrackedRaceStatusEnum.LOADING, 0.0);
                this.updateStatusOfTrackedRaces();
                break;
            }
            case End: {
                logger.info("Stored data end in tracker " + this.getID() + " for race(s) " + this.getRace());
                if (!this.isLiveTracking) break;
                this.lastStatus = new TrackedRaceStatusImpl(TrackedRaceStatusEnum.TRACKING, 1.0);
                this.updateStatusOfTrackedRaces();
                break;
            }
            case Progress: {
                this.storedDataProgress(storedDataEvent.getProgress());
                break;
            }
            case Error: {
                logger.warning("Error with stored data in tracker " + this.getID() + " for race(s) " + this.getRace() + ": " + storedDataEvent.getError());
            }
        }
    }

    public void stopped(Object o) {
        logger.info("stopped TracTrac tracking in tracker " + this + " with ID " + this.getID() + " for " + this.getRace() + " while in status " + this.lastStatus);
        new AbstractLoadingQueueDoneCallBack(this.receivers){

            @Override
            protected void executeWhenAllReceiversAreDoneLoading() {
                TracTracRaceTrackerImpl.this.lastStatus = (TrackedRaceStatus)new TrackedRaceStatusImpl(TrackedRaceStatusEnum.FINISHED, 1.0);
                TracTracRaceTrackerImpl.this.updateStatusOfTrackedRaces();
                if (!TracTracRaceTrackerImpl.this.stopped) {
                    Thread stopper = new Thread(() -> {
                        try {
                            if (TracTracRaceTrackerImpl.this.getRaceHandle().getRace(TIMEOUT_FOR_RACE_TO_APPEAR_FOR_STOPPING_TRACKING_IN_MILLIS) != null) {
                                logger.info("Calling stopTracking for tracker " + this + " with ID " + TracTracRaceTrackerImpl.this.getID());
                                TracTracRaceTrackerImpl.this.trackedRegattaRegistry.stopTracking(TracTracRaceTrackerImpl.this.regatta, TracTracRaceTrackerImpl.this.getRace());
                            } else {
                                logger.warning("Didn't receive RaceDefinition for tracker " + this + " with ID " + TracTracRaceTrackerImpl.this.getID() + " within " + TIMEOUT_FOR_RACE_TO_APPEAR_FOR_STOPPING_TRACKING_IN_MILLIS + "ms; unable to call stopTracking(...)");
                            }
                        }
                        catch (IOException | InterruptedException e) {
                            logger.log(Level.INFO, "Interrupted while trying to stop tracker " + this, e);
                        }
                    }, "Stopper for tracker " + this + " with ID " + TracTracRaceTrackerImpl.this.getID());
                    stopper.setDaemon(true);
                    stopper.start();
                }
            }
        };
    }
}

