/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.tractracadapter.JSONService;
import com.sap.sailing.domain.tractracadapter.RaceRecord;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JSONServiceImpl
implements JSONService {
    private final String regattaName;
    private final List<RaceRecord> raceRecords;

    public JSONServiceImpl(URL jsonURL, boolean loadLiveAndStoredURI) throws IOException, java.text.ParseException, ParseException, URISyntaxException {
        this(jsonURL, null, loadLiveAndStoredURI);
    }

    private RaceRecord createRaceRecord(URL jsonURL, boolean loadLiveAndStoredURI, JSONObject jsonRaceEntry, String defaultUpdateURI) throws URISyntaxException, IOException {
        RaceRecord raceRecord = new RaceRecord(jsonURL, this.regattaName, (String)jsonRaceEntry.get((Object)"name"), (String)jsonRaceEntry.get((Object)"url_html"), (String)jsonRaceEntry.get((Object)"params_url"), (String)jsonRaceEntry.get((Object)"id"), (String)jsonRaceEntry.get((Object)"tracking_starttime"), (String)jsonRaceEntry.get((Object)"tracking_endtime"), (String)jsonRaceEntry.get((Object)"race_starttime"), (String)jsonRaceEntry.get((Object)"classes"), (String)jsonRaceEntry.get((Object)"status"), (String)jsonRaceEntry.get((Object)"visibility"), (Boolean)jsonRaceEntry.get((Object)"has_replay"), loadLiveAndStoredURI, defaultUpdateURI);
        return raceRecord;
    }

    public JSONServiceImpl(URL jsonURL, String raceEntryId, boolean loadLiveAndStoredURI) throws IOException, java.text.ParseException, ParseException, URISyntaxException {
        URLConnection connection = jsonURL.openConnection();
        Charset charset = HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)connection, (String)"UTF-8");
        JSONObject jsonObject = this.parseJSONObject(connection.getInputStream(), charset);
        this.raceRecords = new ArrayList<RaceRecord>();
        this.regattaName = (String)((JSONObject)jsonObject.get((Object)"event")).get((Object)"name");
        String defaultUpdateURI = (String)((JSONObject)jsonObject.get((Object)"event")).get((Object)"server_update_uri");
        for (Object raceEntry : (JSONArray)jsonObject.get((Object)"races")) {
            JSONObject jsonRaceEntry = (JSONObject)raceEntry;
            if (raceEntryId != null && !jsonRaceEntry.get((Object)"id").equals(raceEntryId)) continue;
            RaceRecord raceRecord = this.createRaceRecord(jsonURL, loadLiveAndStoredURI, jsonRaceEntry, defaultUpdateURI);
            this.raceRecords.add(raceRecord);
        }
    }

    @Override
    public String getEventName() {
        return this.regattaName;
    }

    @Override
    public List<RaceRecord> getRaceRecords() {
        return Collections.unmodifiableList(this.raceRecords);
    }

    private JSONObject parseJSONObject(InputStream is, Charset charset) throws IOException, java.text.ParseException, ParseException {
        JSONParser parser = new JSONParser();
        Object result = parser.parse((Reader)new InputStreamReader(is));
        return (JSONObject)result;
    }
}

