/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.datamining.components;

import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.datamining.data.HasUserGroupContext;
import com.sap.sse.security.datamining.data.impl.UserGroupWithContext;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.UserGroup;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;

public class SecurityUserGroupsRetrievalProcessor
extends AbstractRetrievalProcessor<SecurityService, HasUserGroupContext> {
    public SecurityUserGroupsRetrievalProcessor(ExecutorService executor, Collection<Processor<HasUserGroupContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(SecurityService.class, HasUserGroupContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasUserGroupContext> retrieveData(SecurityService securityService) {
        HashSet<HasUserGroupContext> data = new HashSet<HasUserGroupContext>();
        for (UserGroup userGroup : securityService.getUserGroupList()) {
            if (this.isAborted()) break;
            if (!securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)userGroup)) continue;
            data.add(new UserGroupWithContext(userGroup, securityService));
        }
        return data;
    }
}

