/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

import smile.clustering.linkage.Linkage;

public class UPGMCLinkage
extends Linkage {
    private int[] n;

    public UPGMCLinkage(double[][] proximity) {
        int i;
        this.init(proximity);
        this.n = new int[proximity.length];
        for (i = 0; i < this.n.length; ++i) {
            this.n[i] = 1;
        }
        for (i = 0; i < this.proximity.length; ++i) {
            int n = i;
            this.proximity[n] = this.proximity[n] * this.proximity[i];
        }
    }

    public String toString() {
        return "UPGMC linkage";
    }

    @Override
    public void merge(int i, int j) {
        int k;
        float nij = this.n[i] + this.n[j];
        for (k = 0; k < i; ++k) {
            this.proximity[this.index((int)i, (int)k)] = (this.d(i, k) * (float)this.n[i] + this.d(j, k) * (float)this.n[j] - this.d(j, i) * (float)this.n[i] * (float)this.n[j] / nij) / nij;
        }
        for (k = i + 1; k < j; ++k) {
            this.proximity[this.index((int)k, (int)i)] = (this.d(k, i) * (float)this.n[i] + this.d(j, k) * (float)this.n[j] - this.d(j, i) * (float)this.n[i] * (float)this.n[j] / nij) / nij;
        }
        for (k = j + 1; k < this.size; ++k) {
            this.proximity[this.index((int)k, (int)i)] = (this.d(k, i) * (float)this.n[i] + this.d(k, j) * (float)this.n[j] - this.d(j, i) * (float)this.n[i] * (float)this.n[j] / nij) / nij;
        }
        int n = i;
        this.n[n] = this.n[n] + this.n[j];
    }
}

