/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.aicore.impl;

import com.sap.sse.aicore.AICore;
import com.sap.sse.aicore.Credentials;
import com.sap.sse.aicore.Deployment;
import com.sap.sse.aicore.impl.DeploymentImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.util.LaxRedirectStrategyForAllRedirectResponseCodes;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AICoreImpl
implements AICore {
    private static final String DEPLOYMENTS_PATH = "/v2/lm/deployments";
    private static final String DEPLOYMENT_ID = "id";
    private static final String DEPLOYMENT_DETAILS = "details";
    private static final String DEPLOYMENT_DETAILS_RESOURCES = "resources";
    private static final String DEPLOYMENT_DETAILS_RESOURCES_BACKEND_DETAILS = "backendDetails";
    private static final String DEPLOYMENT_DETAILS_RESOURCES_BACKEND_DETAILS_MODEL = "model";
    private static final String DEPLOYMENT_DETAILS_RESOURCES_BACKEND_DETAILS_MODEL_NAME = "name";
    private Credentials credentials;
    private final ScheduledExecutorService executor;
    private TimePoint timePointOfLastRequest;
    private final int maximumNumberOfRetries = 10;
    private static final Duration MAX_DURATION_BETWEEN_RETRIES = Duration.ONE_MINUTE;
    private static final Duration minimumDurationBetweenRequests = Duration.ONE_SECOND.divide(10L);

    public AICoreImpl(Credentials credentials, ScheduledExecutorService executor) {
        this.credentials = credentials;
        this.executor = executor;
    }

    @Override
    public Iterable<Deployment> getDeployments() throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        ArrayList<Deployment> result = new ArrayList<Deployment>();
        JSONObject deploymentsJson = this.getJSONResponse((HttpUriRequest)this.getHttpGetRequest(DEPLOYMENTS_PATH));
        for (Object deploymentJson : (JSONArray)deploymentsJson.get((Object)DEPLOYMENT_DETAILS_RESOURCES)) {
            JSONObject model;
            JSONObject backendDetails;
            JSONObject deploymentDetailsResources;
            JSONObject deploymentDetails;
            JSONObject deploymentJsonObject = (JSONObject)deploymentJson;
            String id = (String)deploymentJsonObject.get((Object)DEPLOYMENT_ID);
            String modelName = deploymentJsonObject.containsKey((Object)DEPLOYMENT_DETAILS) ? ((deploymentDetails = (JSONObject)deploymentJsonObject.get((Object)DEPLOYMENT_DETAILS)).containsKey((Object)DEPLOYMENT_DETAILS_RESOURCES) ? ((deploymentDetailsResources = (JSONObject)deploymentDetails.get((Object)DEPLOYMENT_DETAILS_RESOURCES)).containsKey((Object)DEPLOYMENT_DETAILS_RESOURCES_BACKEND_DETAILS) ? ((backendDetails = (JSONObject)deploymentDetailsResources.get((Object)DEPLOYMENT_DETAILS_RESOURCES_BACKEND_DETAILS)).containsKey((Object)DEPLOYMENT_DETAILS_RESOURCES_BACKEND_DETAILS_MODEL) ? ((model = (JSONObject)backendDetails.get((Object)DEPLOYMENT_DETAILS_RESOURCES_BACKEND_DETAILS_MODEL)).containsKey((Object)DEPLOYMENT_DETAILS_RESOURCES_BACKEND_DETAILS_MODEL_NAME) ? (String)model.get((Object)DEPLOYMENT_DETAILS_RESOURCES_BACKEND_DETAILS_MODEL_NAME) : null) : null) : null) : null) : null;
            if (modelName == null) continue;
            result.add(new DeploymentImpl(id, modelName));
        }
        return result;
    }

    @Override
    public boolean hasCredentials() {
        return this.credentials != null;
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public HttpGet getHttpGetRequest(String pathSuffix) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        HttpGet httpGet = new HttpGet(new URL(this.credentials.getAiApiUrl(), pathSuffix).toString());
        this.credentials.authorize((HttpRequest)httpGet);
        return httpGet;
    }

    @Override
    public HttpPost getHttpPostRequest(String pathSuffix) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        HttpPost httpPost = new HttpPost(new URL(this.credentials.getAiApiUrl(), pathSuffix).toString());
        this.credentials.authorize((HttpRequest)httpPost);
        return httpPost;
    }

    @Override
    public JSONObject getJSONResponse(HttpUriRequest request) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        CloseableHttpClient client = this.getHttpClient();
        CloseableHttpResponse response = client.execute(request);
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new IOException("Error fetching " + request.getRequestLine() + ": (" + response.getStatusLine().getStatusCode() + ") " + response.getStatusLine().getReasonPhrase());
        }
        JSONObject configurationsJson = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(response.getEntity().getContent()));
        return configurationsJson;
    }

    private CloseableHttpClient getHttpClient() throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        return HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategyForAllRedirectResponseCodes()).build();
    }

    @Override
    public void getJSONResponse(HttpUriRequest request, Consumer<JSONObject> resultCallback, Optional<Consumer<Exception>> exceptionHandler) {
        try {
            CloseableHttpClient client = this.getHttpClient();
            this.scheduleWithRateLimit(client, request, resultCallback, exceptionHandler);
        }
        catch (IOException | UnsupportedOperationException | URISyntaxException | ParseException e) {
            exceptionHandler.map(arg_0 -> AICoreImpl.lambda$0((Exception)e, arg_0)).orElseGet(() -> AICoreImpl.lambda$1((Exception)e));
        }
    }

    private synchronized void scheduleWithRateLimit(CloseableHttpClient client, HttpUriRequest request, Consumer<JSONObject> resultCallback, Optional<Consumer<Exception>> exceptionHandler) {
        this.scheduleWithRateLimitAndBackoff(this.getInitialDelayForRateLimiting(), client, request, resultCallback, exceptionHandler, 0);
    }

    private synchronized void scheduleWithRateLimitAndBackoff(Duration delayForRateLimiting, CloseableHttpClient client, HttpUriRequest request, Consumer<JSONObject> resultCallback, Optional<Consumer<Exception>> exceptionHandler, int retryNumber) {
        this.timePointOfLastRequest = TimePoint.now().plus(delayForRateLimiting);
        this.executor.schedule(SecurityUtils.getSubject().associateWith(() -> {
            try {
                String message;
                CloseableHttpResponse response = client.execute(request);
                if (response.getStatusLine().getStatusCode() == 429) {
                    if (retryNumber == 10) {
                        message = retryNumber + " retries failed. Giving up.";
                        this.throwIOExceptionOrLogSevere(exceptionHandler, message);
                    } else {
                        Duration nextDelay = delayForRateLimiting.times(2L).compareTo((Object)MAX_DURATION_BETWEEN_RETRIES) > 0 ? MAX_DURATION_BETWEEN_RETRIES : delayForRateLimiting.times(2L);
                        logger.info("Ran into rate limit; setting delay from " + delayForRateLimiting + " to " + nextDelay);
                        this.scheduleWithRateLimitAndBackoff(nextDelay, client, request, resultCallback, exceptionHandler, retryNumber + 1);
                    }
                } else if (response.getStatusLine().getStatusCode() >= 400) {
                    message = "Error fetching " + request.getRequestLine() + ": (" + response.getStatusLine().getStatusCode() + ") " + response.getStatusLine().getReasonPhrase();
                    this.throwIOExceptionOrLogSevere(exceptionHandler, message);
                }
                JSONObject configurationsJson = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(response.getEntity().getContent()));
                resultCallback.accept(configurationsJson);
            }
            catch (IOException | UnsupportedOperationException | ParseException e) {
                this.throwExceptionOrLogSevere(exceptionHandler, (Exception)e);
            }
        }), delayForRateLimiting.asMillis(), TimeUnit.MILLISECONDS);
    }

    private void throwIOExceptionOrLogSevere(Optional<Consumer<Exception>> exceptionHandler, String message) {
        this.throwExceptionOrLogSevere(exceptionHandler, new IOException(message));
    }

    private void throwExceptionOrLogSevere(Optional<Consumer<Exception>> exceptionHandler, Exception exception) {
        exceptionHandler.map(handler -> {
            handler.accept(exception);
            return null;
        }).orElseGet(() -> {
            logger.severe(exception.getMessage());
            return null;
        });
    }

    private Duration getInitialDelayForRateLimiting() {
        TimePoint now = TimePoint.now();
        Duration result = this.timePointOfLastRequest == null || this.timePointOfLastRequest.plus(minimumDurationBetweenRequests).compareTo((Object)now) < 0 ? Duration.NULL : now.until(this.timePointOfLastRequest.plus(minimumDurationBetweenRequests));
        return result;
    }

    private static /* synthetic */ Object lambda$0(Exception exception, Consumer handler) {
        handler.accept(exception);
        return null;
    }

    private static /* synthetic */ Object lambda$1(Exception exception) {
        logger.log(Level.SEVERE, "Exception trying to obtain HTTP client", exception);
        return null;
    }
}

