/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The snapshot ID and its deletion result code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSnapshotReturnCode implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteSnapshotReturnCode.Builder, DeleteSnapshotReturnCode> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(DeleteSnapshotReturnCode::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<String> RETURN_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReturnCode")
            .getter(getter(DeleteSnapshotReturnCode::returnCodeAsString))
            .setter(setter(Builder::returnCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnCode")
                    .unmarshallLocationName("returnCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            RETURN_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String snapshotId;

    private final String returnCode;

    private DeleteSnapshotReturnCode(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.returnCode = builder.returnCode;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The result code from the snapshot deletion attempt. Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>success</code> - The snapshot was successfully deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>skipped</code> - The snapshot was not deleted because it's associated with other AMIs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>missing-permissions</code> - The snapshot was not deleted because the role lacks
     * <code>DeleteSnapshot</code> permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/security_iam_service-with-iam.html">How Amazon EBS works
     * with IAM</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>internal-error</code> - The snapshot was not deleted due to a server error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client-error</code> - The snapshot was not deleted due to a client configuration error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For details about an error, check the <code>DeleteSnapshot</code> event in the CloudTrail event history. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/tutorial-event-history.html">View event
     * history</a> in the <i>Amazon Web Services CloudTrail User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #returnCode} will
     * return {@link SnapshotReturnCodes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #returnCodeAsString}.
     * </p>
     * 
     * @return The result code from the snapshot deletion attempt. Possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>success</code> - The snapshot was successfully deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>skipped</code> - The snapshot was not deleted because it's associated with other AMIs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>missing-permissions</code> - The snapshot was not deleted because the role lacks
     *         <code>DeleteSnapshot</code> permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/security_iam_service-with-iam.html">How Amazon EBS
     *         works with IAM</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>internal-error</code> - The snapshot was not deleted due to a server error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client-error</code> - The snapshot was not deleted due to a client configuration error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For details about an error, check the <code>DeleteSnapshot</code> event in the CloudTrail event history.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/tutorial-event-history.html">View event
     *         history</a> in the <i>Amazon Web Services CloudTrail User Guide</i>.
     * @see SnapshotReturnCodes
     */
    public final SnapshotReturnCodes returnCode() {
        return SnapshotReturnCodes.fromValue(returnCode);
    }

    /**
     * <p>
     * The result code from the snapshot deletion attempt. Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>success</code> - The snapshot was successfully deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>skipped</code> - The snapshot was not deleted because it's associated with other AMIs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>missing-permissions</code> - The snapshot was not deleted because the role lacks
     * <code>DeleteSnapshot</code> permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/security_iam_service-with-iam.html">How Amazon EBS works
     * with IAM</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>internal-error</code> - The snapshot was not deleted due to a server error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client-error</code> - The snapshot was not deleted due to a client configuration error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For details about an error, check the <code>DeleteSnapshot</code> event in the CloudTrail event history. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/tutorial-event-history.html">View event
     * history</a> in the <i>Amazon Web Services CloudTrail User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #returnCode} will
     * return {@link SnapshotReturnCodes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #returnCodeAsString}.
     * </p>
     * 
     * @return The result code from the snapshot deletion attempt. Possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>success</code> - The snapshot was successfully deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>skipped</code> - The snapshot was not deleted because it's associated with other AMIs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>missing-permissions</code> - The snapshot was not deleted because the role lacks
     *         <code>DeleteSnapshot</code> permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/security_iam_service-with-iam.html">How Amazon EBS
     *         works with IAM</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>internal-error</code> - The snapshot was not deleted due to a server error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client-error</code> - The snapshot was not deleted due to a client configuration error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For details about an error, check the <code>DeleteSnapshot</code> event in the CloudTrail event history.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/tutorial-event-history.html">View event
     *         history</a> in the <i>Amazon Web Services CloudTrail User Guide</i>.
     * @see SnapshotReturnCodes
     */
    public final String returnCodeAsString() {
        return returnCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(returnCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSnapshotReturnCode)) {
            return false;
        }
        DeleteSnapshotReturnCode other = (DeleteSnapshotReturnCode) obj;
        return Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(returnCodeAsString(), other.returnCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSnapshotReturnCode").add("SnapshotId", snapshotId())
                .add("ReturnCode", returnCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "ReturnCode":
            return Optional.ofNullable(clazz.cast(returnCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("ReturnCode", RETURN_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSnapshotReturnCode, T> g) {
        return obj -> g.apply((DeleteSnapshotReturnCode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteSnapshotReturnCode> {
        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The result code from the snapshot deletion attempt. Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>success</code> - The snapshot was successfully deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>skipped</code> - The snapshot was not deleted because it's associated with other AMIs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>missing-permissions</code> - The snapshot was not deleted because the role lacks
         * <code>DeleteSnapshot</code> permissions. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/security_iam_service-with-iam.html">How Amazon EBS
         * works with IAM</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>internal-error</code> - The snapshot was not deleted due to a server error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-error</code> - The snapshot was not deleted due to a client configuration error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For details about an error, check the <code>DeleteSnapshot</code> event in the CloudTrail event history. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/tutorial-event-history.html">View event
         * history</a> in the <i>Amazon Web Services CloudTrail User Guide</i>.
         * </p>
         * 
         * @param returnCode
         *        The result code from the snapshot deletion attempt. Possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>success</code> - The snapshot was successfully deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>skipped</code> - The snapshot was not deleted because it's associated with other AMIs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>missing-permissions</code> - The snapshot was not deleted because the role lacks
         *        <code>DeleteSnapshot</code> permissions. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/security_iam_service-with-iam.html">How Amazon
         *        EBS works with IAM</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>internal-error</code> - The snapshot was not deleted due to a server error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client-error</code> - The snapshot was not deleted due to a client configuration error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For details about an error, check the <code>DeleteSnapshot</code> event in the CloudTrail event
         *        history. For more information, see <a
         *        href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/tutorial-event-history.html">View
         *        event history</a> in the <i>Amazon Web Services CloudTrail User Guide</i>.
         * @see SnapshotReturnCodes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotReturnCodes
         */
        Builder returnCode(String returnCode);

        /**
         * <p>
         * The result code from the snapshot deletion attempt. Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>success</code> - The snapshot was successfully deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>skipped</code> - The snapshot was not deleted because it's associated with other AMIs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>missing-permissions</code> - The snapshot was not deleted because the role lacks
         * <code>DeleteSnapshot</code> permissions. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/security_iam_service-with-iam.html">How Amazon EBS
         * works with IAM</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>internal-error</code> - The snapshot was not deleted due to a server error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-error</code> - The snapshot was not deleted due to a client configuration error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For details about an error, check the <code>DeleteSnapshot</code> event in the CloudTrail event history. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/tutorial-event-history.html">View event
         * history</a> in the <i>Amazon Web Services CloudTrail User Guide</i>.
         * </p>
         * 
         * @param returnCode
         *        The result code from the snapshot deletion attempt. Possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>success</code> - The snapshot was successfully deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>skipped</code> - The snapshot was not deleted because it's associated with other AMIs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>missing-permissions</code> - The snapshot was not deleted because the role lacks
         *        <code>DeleteSnapshot</code> permissions. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/security_iam_service-with-iam.html">How Amazon
         *        EBS works with IAM</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>internal-error</code> - The snapshot was not deleted due to a server error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client-error</code> - The snapshot was not deleted due to a client configuration error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For details about an error, check the <code>DeleteSnapshot</code> event in the CloudTrail event
         *        history. For more information, see <a
         *        href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/tutorial-event-history.html">View
         *        event history</a> in the <i>Amazon Web Services CloudTrail User Guide</i>.
         * @see SnapshotReturnCodes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotReturnCodes
         */
        Builder returnCode(SnapshotReturnCodes returnCode);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotId;

        private String returnCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSnapshotReturnCode model) {
            snapshotId(model.snapshotId);
            returnCode(model.returnCode);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getReturnCode() {
            return returnCode;
        }

        public final void setReturnCode(String returnCode) {
            this.returnCode = returnCode;
        }

        @Override
        public final Builder returnCode(String returnCode) {
            this.returnCode = returnCode;
            return this;
        }

        @Override
        public final Builder returnCode(SnapshotReturnCodes returnCode) {
            this.returnCode(returnCode == null ? null : returnCode.toString());
            return this;
        }

        @Override
        public DeleteSnapshotReturnCode build() {
            return new DeleteSnapshotReturnCode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
