/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.windestimation;

import com.sap.sailing.domain.common.confidence.impl.ScalableDouble;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableBearing;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Util;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.common.scalablevalue.ScalableValueWithDistance;

public class ScalableBearingAndScalableDouble
implements ScalableValueWithDistance<Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>> {
    private final ScalableBearing b1;
    private final ScalableDouble b2;

    public ScalableBearingAndScalableDouble(Bearing b1, double b2) {
        this(new ScalableBearing(b1), new ScalableDouble(b2));
    }

    private ScalableBearingAndScalableDouble(ScalableBearing b1, ScalableDouble b2) {
        this.b1 = b1;
        this.b2 = b2;
    }

    public Util.Pair<Bearing, Double> divide(double divisor) {
        return new Util.Pair((Object)this.b1.divide(divisor), (Object)this.b2.divide(divisor));
    }

    public Util.Pair<ScalableBearing, ScalableDouble> getValue() {
        return new Util.Pair((Object)this.b1, (Object)this.b2);
    }

    public double getDistance(Util.Pair<Bearing, Double> other) {
        double b1DiffDeg = this.b1.getApproximateDegreeDistanceTo((Bearing)other.getA());
        double b2DiffDeg = Math.abs(this.b2.divide(1.0) - (Double)other.getB());
        return Math.sqrt(b1DiffDeg * b1DiffDeg + b2DiffDeg * b2DiffDeg);
    }

    public ScalableBearingAndScalableDouble add(ScalableValue<Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>> t) {
        return new ScalableBearingAndScalableDouble(this.b1.add((ScalableValue)((Util.Pair)t.getValue()).getA()), this.b2.add((ScalableValue)((Util.Pair)t.getValue()).getB()));
    }

    public ScalableBearingAndScalableDouble multiply(double factor) {
        return new ScalableBearingAndScalableDouble(this.b1.multiply(factor), this.b2.multiply(factor));
    }
}

