/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.mining;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.confidence.BearingWithConfidence;
import com.sap.sailing.domain.common.confidence.ConfidenceFactory;
import com.sap.sailing.domain.common.confidence.impl.BearingWithConfidenceImpl;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.polars.mining.AngleClusterPolarClusterKey;
import com.sap.sailing.polars.mining.LegTypePolarClusterKey;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.data.ClusterGroup;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class GPSFixMovingWithPolarContext
implements LegTypePolarClusterKey,
AngleClusterPolarClusterKey {
    private final GPSFixMoving fix;
    private final TrackedRace race;
    private final Competitor competitor;
    private final Set<WindSource> windSourcesToExcludeForSpeed;
    private final ClusterGroup<Bearing> angleClusterGroup;
    private final BearingWithConfidence<Void> absTrueWindAngle;
    private final WindWithConfidence<Util.Pair<Position, TimePoint>> wind;
    private final SpeedWithBearingWithConfidence<TimePoint> boatSpeed;
    private LegType legType;

    public GPSFixMovingWithPolarContext(GPSFixMoving fix, TrackedRace race, Competitor competitor, ClusterGroup<Bearing> angleClusterGroup) {
        this.fix = fix;
        this.race = race;
        this.competitor = competitor;
        this.angleClusterGroup = angleClusterGroup;
        this.windSourcesToExcludeForSpeed = this.collectWindSourcesToIgnoreForSpeed();
        this.absTrueWindAngle = this.computeTrueWindAngleAbsolute();
        this.wind = race.getWindWithConfidence(fix.getPosition(), fix.getTimePoint(), this.windSourcesToExcludeForSpeed);
        this.boatSpeed = this.computeBoatSpeed();
    }

    public GPSFixMoving getFix() {
        return this.fix;
    }

    public TrackedRace getRace() {
        return this.race;
    }

    public Competitor getCompetitor() {
        return this.competitor;
    }

    public BearingWithConfidence<Void> getAbsoluteAngleToTheWind() {
        return this.absTrueWindAngle;
    }

    private BearingWithConfidence<Void> computeTrueWindAngleAbsolute() {
        BearingWithConfidenceImpl result = null;
        DegreeBearingImpl bearing = null;
        TrackedLegOfCompetitor currentLeg = this.race.getCurrentLeg(this.competitor, this.fix.getTimePoint());
        if (currentLeg != null) {
            Bearing realBearing = this.race.getTWA(this.competitor, this.fix.getTimePoint());
            bearing = realBearing == null ? null : new DegreeBearingImpl(Math.abs(realBearing.getDegrees()));
        }
        WindWithConfidence wind = this.race.getWindWithConfidence(this.fix.getPosition(), this.fix.getTimePoint());
        if (bearing != null && wind != null) {
            result = new BearingWithConfidenceImpl((Bearing)bearing, wind.getConfidence(), null);
        }
        return result;
    }

    public WindWithConfidence<Util.Pair<Position, TimePoint>> getWind() {
        return this.wind;
    }

    public SpeedWithBearingWithConfidence<TimePoint> getBoatSpeed() {
        return this.boatSpeed;
    }

    private SpeedWithBearingWithConfidence<TimePoint> computeBoatSpeed() {
        GPSFixTrack track = this.race.getTrack(this.competitor);
        return track.getEstimatedSpeed(this.fix.getTimePoint(), ConfidenceFactory.INSTANCE.createExponentialTimeDifferenceWeigher(track.getMillisecondsOverWhichToAverageSpeed() / 2L, 1.0E-8));
    }

    private Set<WindSource> collectWindSourcesToIgnoreForSpeed() {
        HashSet<WindSource> windSourcesToExclude = new HashSet<WindSource>();
        Set combinedSources = this.race.getWindSources(WindSourceType.COMBINED);
        for (WindSource combinedSource : combinedSources) {
            windSourcesToExclude.add(combinedSource);
        }
        Set courseSources = this.race.getWindSources(WindSourceType.COURSE_BASED);
        for (WindSource courseSource : courseSources) {
            windSourcesToExclude.add(courseSource);
        }
        Set trackBasedSources = this.race.getWindSources(WindSourceType.TRACK_BASED_ESTIMATION);
        for (WindSource trackBasedSource : trackBasedSources) {
            windSourcesToExclude.add(trackBasedSource);
        }
        Set maneuverBasedSources = this.race.getWindSources(WindSourceType.MANEUVER_BASED_ESTIMATION);
        for (WindSource maneuverBasedSource : maneuverBasedSources) {
            windSourcesToExclude.add(maneuverBasedSource);
        }
        Set rcSources = this.race.getWindSources(WindSourceType.RACECOMMITTEE);
        for (WindSource rcSource : rcSources) {
            windSourcesToExclude.add(rcSource);
        }
        Set webSources = this.race.getWindSources(WindSourceType.WEB);
        for (WindSource webSource : webSources) {
            windSourcesToExclude.add(webSource);
        }
        return windSourcesToExclude;
    }

    @Override
    public BoatClass getBoatClass() {
        return this.race.getBoatOfCompetitor(this.getCompetitor()).getBoatClass();
    }

    @Override
    public LegType getLegType() {
        LegType result = null;
        if (this.legType == null) {
            TimePoint timePoint = this.fix.getTimePoint();
            try {
                TrackedLegOfCompetitor currentLegOfCompetitor = this.race.getCurrentLeg(this.getCompetitor(), timePoint);
                if (currentLegOfCompetitor != null) {
                    TrackedLeg currentLeg = currentLegOfCompetitor.getTrackedLeg();
                    this.legType = currentLeg == null ? null : currentLeg.getLegType(timePoint);
                }
            }
            catch (NoWindException e) {
                this.legType = null;
            }
            result = this.legType;
        } else {
            result = this.legType;
        }
        return result;
    }

    @Override
    public Cluster<Bearing> getAngleCluster() {
        return this.angleClusterGroup.getClusterFor((Serializable)((Bearing)this.getAbsoluteAngleToTheWind().getObject()));
    }
}

