/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;

public class GPSFixMovingImpl
extends GPSFixImpl
implements GPSFixMoving {
    private static final long serialVersionUID = 6508021498142383100L;
    private final SpeedWithBearing speed;
    private final Bearing optionalTrueHeading;

    public GPSFixMovingImpl(Position position, TimePoint timePoint, SpeedWithBearing speed, Bearing optionalTrueHeading) {
        super(position, timePoint);
        this.speed = speed;
        this.optionalTrueHeading = optionalTrueHeading;
    }

    @Override
    public SpeedWithBearing getSpeed() {
        return this.speed;
    }

    @Override
    public Bearing getOptionalTrueHeading() {
        return this.optionalTrueHeading;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " with " + this.getSpeed();
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.getSpeed().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && other instanceof GPSFixMoving && this.getSpeed().equals(((GPSFixMoving)other).getSpeed());
    }

    public static GPSFixMovingImpl create(double lonDeg, double latDeg, long timeMillis, double speedInKnots, double bearingDeg, Double optionalTrueHeadingDeg) {
        return new GPSFixMovingImpl(new DegreePosition(latDeg, lonDeg), (TimePoint)new MillisecondsTimePoint(timeMillis), new KnotSpeedWithBearingImpl(speedInKnots, (Bearing)new DegreeBearingImpl(bearingDeg)), (Bearing)(optionalTrueHeadingDeg == null ? null : new DegreeBearingImpl(optionalTrueHeadingDeg.doubleValue())));
    }
}

