/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.dto;

import com.sap.sailing.domain.common.LeaderboardType;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.PlacemarkOrderDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTOFactory;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.NamedDTO;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractLeaderboardDTO
extends NamedDTO
implements SecuredDTO {
    private static final long serialVersionUID = -205106531931903527L;
    private List<RaceColumnDTO> races;
    public Map<CompetitorDTO, String> competitorDisplayNames;
    public Map<CompetitorDTO, LeaderboardRowDTO> rows;
    public boolean hasCarriedPoints;
    public int[] discardThresholds;
    private OwnershipDTO ownership;
    private AccessControlListDTO acl;
    public String regattaName;
    private String otherTieBreakingLeaderboardName;
    public String displayName;
    public List<CourseAreaDTO> courseAreas;
    public ScoringSchemeType scoringScheme;
    public LeaderboardType type;
    public boolean canBoatsOfCompetitorsChangePerRace;
    private Long delayToLiveInMillisForLatestRace;
    private BoatClassDTO boatClass;

    @Deprecated
    protected AbstractLeaderboardDTO() {
    }

    public AbstractLeaderboardDTO(String name, BoatClassDTO boatClass) {
        super(name);
        this.boatClass = boatClass;
        this.races = new ArrayList<RaceColumnDTO>();
    }

    public AbstractLeaderboardDTO(BoatClassDTO boatClass) {
        this("", boatClass);
    }

    public AccessControlListDTO getAccessControlList() {
        return this.acl;
    }

    public OwnershipDTO getOwnership() {
        return this.ownership;
    }

    public void setAccessControlList(AccessControlListDTO acl) {
        this.acl = acl;
    }

    public void setOwnership(OwnershipDTO ownership) {
        this.ownership = ownership;
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.LEADERBOARD;
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return new TypeRelativeObjectIdentifier(new String[]{this.getName()});
    }

    public BoatClassDTO getBoatClass() {
        return this.boatClass;
    }

    protected void setBoatClass(BoatClassDTO boatClass) {
        this.boatClass = boatClass;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayName(CompetitorDTO competitor) {
        if (this.competitorDisplayNames == null || this.competitorDisplayNames.get(competitor) == null) {
            return competitor.getName();
        }
        return this.competitorDisplayNames.get(competitor);
    }

    public String getOtherTieBreakingLeaderboardName() {
        return this.otherTieBreakingLeaderboardName;
    }

    public void setOtherTieBreakingLeaderboardName(String otherTieBreakingLeaderboardName) {
        this.otherTieBreakingLeaderboardName = otherTieBreakingLeaderboardName;
    }

    public int getLegCount(String raceColumnName, RaceIdentifier preselectedRace) {
        int result = -1;
        boolean preselectedRaceIsInRaceColumn = this.isRaceInColumn(preselectedRace, raceColumnName);
        for (LeaderboardRowDTO row : this.rows.values()) {
            LeaderboardEntryDTO leaderboardEntryDTO = row.fieldsByRaceColumnName.get(raceColumnName);
            if (leaderboardEntryDTO == null || leaderboardEntryDTO.legDetails == null || preselectedRace != null && preselectedRaceIsInRaceColumn && !preselectedRace.equals(leaderboardEntryDTO.race)) continue;
            result = Math.max(result, leaderboardEntryDTO.legDetails.size());
        }
        return result;
    }

    private boolean isRaceInColumn(RaceIdentifier preselectedRace, String raceColumnName) {
        RaceColumnDTO raceColumn = this.getRaceColumnByName(raceColumnName);
        return raceColumn.containsRace(preselectedRace);
    }

    public boolean scoredInMedalRace(CompetitorWithBoatDTO competitor) {
        LeaderboardRowDTO row = this.rows.get(competitor);
        for (RaceColumnDTO race : this.races) {
            if (!race.isMedalRace() || !(row.fieldsByRaceColumnName.get((Object)race.getRaceColumnName()).netPoints > 0.0)) continue;
            return true;
        }
        return false;
    }

    public Double getTotalPoints(CompetitorWithBoatDTO competitor, String nameOfLastRaceSoFar) {
        LeaderboardEntryDTO field;
        Double totalPoints = null;
        LeaderboardRowDTO row = this.rows.get(competitor);
        if (row != null && (field = row.fieldsByRaceColumnName.get(nameOfLastRaceSoFar)) != null && field.totalPoints != null) {
            totalPoints = field.totalPoints;
        }
        return totalPoints;
    }

    public boolean raceIsTracked(String raceColumnName) {
        for (RaceColumnDTO race : this.races) {
            if (!race.getRaceColumnName().equals(raceColumnName)) continue;
            for (FleetDTO fleet : race.getFleets()) {
                if (!race.isTrackedRace(fleet)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean raceIsMedalRace(String raceColumnName) {
        return this.getRaceColumnByName(raceColumnName).isMedalRace();
    }

    public RaceColumnDTO addRace(String raceColumnName, Double explicitFactor, double effectiveFactor, String regattaName, String seriesName, FleetDTO fleetDTO, boolean medalRace, RegattaAndRaceIdentifier trackedRaceIdentifier, RaceDTO race, boolean isMetaLeaderboardColumn, boolean oneAlwaysStaysOne) {
        assert (fleetDTO != null);
        RaceColumnDTO raceColumnDTO = this.getRaceColumnByName(raceColumnName);
        if (raceColumnDTO == null) {
            raceColumnDTO = RaceColumnDTOFactory.INSTANCE.createRaceColumnDTO(raceColumnName, medalRace, explicitFactor, regattaName, seriesName, isMetaLeaderboardColumn, oneAlwaysStaysOne);
            this.races.add(raceColumnDTO);
        }
        raceColumnDTO.setEffectiveFactor(effectiveFactor);
        boolean contains = false;
        for (FleetDTO fleet : raceColumnDTO.getFleets()) {
            if (!fleet.getName().equals(fleetDTO.getName())) continue;
            contains = true;
            break;
        }
        if (!contains) {
            raceColumnDTO.addFleet(fleetDTO);
        }
        raceColumnDTO.setRaceIdentifier(fleetDTO, trackedRaceIdentifier);
        raceColumnDTO.setRace(fleetDTO, race);
        return raceColumnDTO;
    }

    public RaceColumnDTO createEmptyRaceColumn(String raceColumnName, boolean medalRace, String regattaName, String seriesName, boolean isMetaLeaderboardColumn, boolean oneAlwaysStaysOne) {
        RaceColumnDTO raceColumn = RaceColumnDTOFactory.INSTANCE.createRaceColumnDTO(raceColumnName, medalRace, null, regattaName, seriesName, isMetaLeaderboardColumn, oneAlwaysStaysOne);
        this.races.add(raceColumn);
        return raceColumn;
    }

    public RaceColumnDTO getRaceColumnByName(String raceColumnName) {
        for (RaceColumnDTO race : this.races) {
            if (!race.getRaceColumnName().equals(raceColumnName)) continue;
            return race;
        }
        return null;
    }

    public int getRaceColumnsCount() {
        return this.races.size();
    }

    public int getRacesCount() {
        int result = 0;
        for (RaceColumnDTO race : this.getRaceList()) {
            result += race.getFleets().size();
        }
        return result;
    }

    public int getTrackedRacesCount() {
        int result = 0;
        for (RaceColumnDTO raceColumn : this.getRaceList()) {
            for (FleetDTO fleet : raceColumn.getFleets()) {
                RaceDTO race = raceColumn.getRace(fleet);
                if (race == null || race.trackedRace == null || !race.trackedRace.hasGPSData || !race.trackedRace.hasWindData) continue;
                ++result;
            }
        }
        return result;
    }

    public List<RaceColumnDTO> getRaceList() {
        return this.races;
    }

    public void setRaceList(List<RaceColumnDTO> raceList) {
        this.races = raceList;
    }

    public boolean raceListContains(String raceColumnName) {
        return this.getRaceColumnByName(raceColumnName) != null;
    }

    public void moveRaceUp(String raceColumnName) {
        RaceColumnDTO race = this.getRaceColumnByName(raceColumnName);
        int index = this.races.indexOf(race);
        if (--index >= 0) {
            this.races.remove(index + 1);
            this.races.add(index, race);
        }
    }

    public void moveRaceDown(String raceColumnName) {
        RaceColumnDTO race = this.getRaceColumnByName(raceColumnName);
        int index = this.races.indexOf(race);
        if (index != -1 && ++index < this.races.size()) {
            this.races.remove(index - 1);
            this.races.add(index, race);
        }
    }

    public void setIsMedalRace(String raceColumnName, boolean medalRace) {
        this.getRaceColumnByName(raceColumnName).setMedalRace(medalRace);
    }

    public Date getStartDate() {
        Date leaderboardStart = null;
        for (RaceColumnDTO race : this.getRaceList()) {
            for (FleetDTO fleet : race.getFleets()) {
                Date raceStart = race.getStartDate(fleet);
                if (raceStart == null) continue;
                if (leaderboardStart == null) {
                    leaderboardStart = new Date();
                    continue;
                }
                Date date = leaderboardStart = leaderboardStart.before(raceStart) ? leaderboardStart : raceStart;
            }
        }
        return leaderboardStart;
    }

    public PlacemarkOrderDTO getPlaces() {
        PlacemarkOrderDTO leaderboardPlaces = null;
        for (RaceColumnDTO race : this.getRaceList()) {
            PlacemarkOrderDTO racePlaces = race.getPlaces();
            if (racePlaces == null) continue;
            if (leaderboardPlaces == null) {
                leaderboardPlaces = new PlacemarkOrderDTO();
            }
            leaderboardPlaces.getPlacemarks().addAll(racePlaces.getPlacemarks());
        }
        return leaderboardPlaces;
    }

    public boolean hasLiveRace(long serverTimePointAsMillis) {
        for (RaceColumnDTO race : this.getRaceList()) {
            for (FleetDTO fleet : race.getFleets()) {
                if (!race.isLive(fleet, serverTimePointAsMillis)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Util.Pair<RaceColumnDTO, FleetDTO>> getLiveRaces(long serverTimePointAsMillis) {
        ArrayList<Util.Pair<RaceColumnDTO, FleetDTO>> result = new ArrayList<Util.Pair<RaceColumnDTO, FleetDTO>>();
        for (RaceColumnDTO race : this.getRaceList()) {
            for (FleetDTO fleet : race.getFleets()) {
                if (!race.isLive(fleet, serverTimePointAsMillis)) continue;
                result.add((Util.Pair<RaceColumnDTO, FleetDTO>)new Util.Pair((Object)race, (Object)fleet));
            }
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.competitorDisplayNames == null ? 0 : this.competitorDisplayNames.hashCode());
        result = 31 * result + Arrays.hashCode(this.discardThresholds);
        result = 31 * result + (this.hasCarriedPoints ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.scoringScheme == null ? 0 : this.scoringScheme.hashCode());
        if (this.races == null) {
            result *= 31;
        } else {
            ArrayList<String> raceNames = new ArrayList<String>();
            for (RaceColumnDTO race : this.races) {
                raceNames.add(race != null ? race.getName() : null);
            }
            result = 31 * result + raceNames.hashCode();
        }
        result = 31 * result + (this.rows == null ? 0 : this.rows.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractLeaderboardDTO other = (AbstractLeaderboardDTO)((Object)obj);
        if (this.competitorDisplayNames == null ? other.competitorDisplayNames != null : !this.competitorDisplayNames.equals(other.competitorDisplayNames)) {
            return false;
        }
        if (!Arrays.equals(this.discardThresholds, other.discardThresholds)) {
            return false;
        }
        if (this.hasCarriedPoints != other.hasCarriedPoints) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.scoringScheme != other.scoringScheme) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getOtherTieBreakingLeaderboardName() == null ? other.getOtherTieBreakingLeaderboardName() != null : !this.getOtherTieBreakingLeaderboardName().equals(other.getOtherTieBreakingLeaderboardName())) {
            return false;
        }
        if (this.races == null) {
            if (other.races != null) {
                return false;
            }
        } else {
            if (this.races.size() != (other.races == null ? 0 : other.races.size())) {
                return false;
            }
            ArrayList<String> raceColumnNames = new ArrayList<String>(this.races.size());
            ArrayList<String> otherRaceColumnNames = new ArrayList<String>(this.races.size());
            for (RaceColumnDTO race : this.races) {
                raceColumnNames.add(race != null ? race.getName() : null);
            }
            if (other.races != null) {
                for (RaceColumnDTO otherRace : other.races) {
                    otherRaceColumnNames.add(otherRace != null ? otherRace.getName() : null);
                }
            }
            if (!raceColumnNames.equals(otherRaceColumnNames)) {
                return false;
            }
            if (this.rows == null ? other.rows != null : !this.rows.equals(other.rows)) {
                return false;
            }
        }
        return true;
    }

    public boolean isDisplayNameSet(CompetitorDTO competitor) {
        return this.competitorDisplayNames.get(competitor) != null;
    }

    public Long getDelayToLiveInMillisForLatestRace() {
        return this.delayToLiveInMillisForLatestRace;
    }

    public void setDelayToLiveInMillisForLatestRace(Long delayToLiveInMillisForLatestRace) {
        this.delayToLiveInMillisForLatestRace = delayToLiveInMillisForLatestRace;
    }

    public List<String> getNamesOfRaceColumns() {
        ArrayList<String> result = new ArrayList<String>(this.races.size());
        for (RaceColumnDTO column : this.races) {
            result.add(column.getRaceColumnName());
        }
        return result;
    }
}

