/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.confidence;

import com.sap.sailing.domain.common.DoublePair;
import com.sap.sailing.domain.common.confidence.BearingWithConfidence;
import com.sap.sailing.domain.common.confidence.ConfidenceBasedAverager;
import com.sap.sailing.domain.common.confidence.ConfidenceFactory;
import com.sap.sailing.domain.common.confidence.HasConfidence;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sailing.domain.common.confidence.impl.BearingWithConfidenceImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BearingWithConfidenceCluster<RelativeTo> {
    private final List<BearingWithConfidence<RelativeTo>> bearings = new ArrayList<BearingWithConfidence<RelativeTo>>();
    private final Weigher<RelativeTo> weigher;
    private final ConfidenceBasedAverager<DoublePair, Bearing, RelativeTo> averager;

    public BearingWithConfidenceCluster(Weigher<RelativeTo> weigher) {
        this.weigher = weigher;
        this.averager = ConfidenceFactory.INSTANCE.createAverager(weigher);
    }

    public BearingWithConfidenceCluster<RelativeTo>[] splitInTwo(double minimumDegreeDifferenceBetweenTacks, RelativeTo relativeTo) {
        BearingWithConfidenceCluster<RelativeTo>[] result = this.createBearingClusterArraySizeTwo();
        result[0] = this.createEmptyCluster();
        result[1] = this.createEmptyCluster();
        if (this.bearings.size() >= 2) {
            Util.Pair<BearingWithConfidence<RelativeTo>, BearingWithConfidence<RelativeTo>> extremeBearings = this.getExtremeBearings(minimumDegreeDifferenceBetweenTacks);
            if (extremeBearings != null) {
                result[0].add((BearingWithConfidence)extremeBearings.getA());
                result[1].add((BearingWithConfidence)extremeBearings.getB());
            }
            for (BearingWithConfidence<RelativeTo> bearing : this.bearings) {
                if (extremeBearings != null && (bearing == extremeBearings.getA() || bearing == extremeBearings.getB())) continue;
                if (extremeBearings == null || super.getDifferenceFromAverage((Bearing)bearing.getObject(), relativeTo) <= super.getDifferenceFromAverage((Bearing)bearing.getObject(), relativeTo)) {
                    result[0].add(bearing);
                    continue;
                }
                result[1].add(bearing);
            }
        } else if (!this.bearings.isEmpty()) {
            result[0].add(this.bearings.get(0));
        }
        return result;
    }

    protected BearingWithConfidenceCluster<RelativeTo>[] createBearingClusterArraySizeTwo() {
        return new BearingWithConfidenceCluster[2];
    }

    private Util.Pair<BearingWithConfidence<RelativeTo>, BearingWithConfidence<RelativeTo>> getExtremeBearings(double minimumDegreeDifferenceBetweenTacks) {
        assert (this.bearings.size() >= 2);
        double maxAbsDegDiff = 0.0;
        Util.Pair result = null;
        int i = 0;
        while (i < this.bearings.size()) {
            int j = i + 1;
            while (j < this.bearings.size()) {
                double confidenceScaledDifference = this.getConfidenceScaledDifference(this.bearings.get(i), this.bearings.get(j));
                if (Math.abs(((Bearing)this.bearings.get(i).getObject()).getDifferenceTo((Bearing)this.bearings.get(j).getObject()).getDegrees()) >= minimumDegreeDifferenceBetweenTacks && confidenceScaledDifference > maxAbsDegDiff) {
                    result = new Util.Pair(this.bearings.get(i), this.bearings.get(j));
                    maxAbsDegDiff = confidenceScaledDifference;
                    assert (Math.abs(((Bearing)this.bearings.get(i).getObject()).getDifferenceTo((Bearing)this.bearings.get(j).getObject()).getDegrees()) <= 180.0);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private double getConfidenceScaledDifference(BearingWithConfidence<RelativeTo> bearingWithConfidence1, BearingWithConfidence<RelativeTo> bearingWithConfidence2) {
        return Math.abs(((Bearing)bearingWithConfidence1.getObject()).getDifferenceTo((Bearing)bearingWithConfidence2.getObject()).getDegrees()) * bearingWithConfidence1.getConfidence() * bearingWithConfidence2.getConfidence();
    }

    public boolean isEmpty() {
        return this.bearings.isEmpty();
    }

    public int size() {
        return this.bearings.size();
    }

    public void add(BearingWithConfidence<RelativeTo> bearing) {
        if (bearing.getConfidence() > 0.0) {
            this.bearings.add(bearing);
        }
    }

    public BearingWithConfidence<RelativeTo> getAverage(RelativeTo relativeTo) {
        HasConfidence<DoublePair, Bearing, RelativeTo> average = this.averager.getAverage(this.getBearings(), relativeTo);
        return average == null ? null : new BearingWithConfidenceImpl<RelativeTo>(average.getObject(), average.getConfidence(), average.getRelativeTo());
    }

    private double getDifferenceFromAverage(Bearing bearing, RelativeTo relativeTo) {
        Bearing averageBearing = (Bearing)this.getAverage(relativeTo).getObject();
        return averageBearing == null ? 0.0 : Math.abs(averageBearing.getDifferenceTo(bearing).getDegrees());
    }

    protected Iterable<BearingWithConfidence<RelativeTo>> getBearings() {
        return Collections.unmodifiableCollection(this.bearings);
    }

    public String toString() {
        return this.bearings.toString();
    }

    private BearingWithConfidenceCluster<RelativeTo> createEmptyCluster() {
        return new BearingWithConfidenceCluster<RelativeTo>(this.weigher);
    }

    public void clear() {
        this.bearings.clear();
    }
}

