/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.sap.sse.common.Util;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.AwsShard;
import com.sap.sse.landscape.aws.orchestration.ShardProcedure;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;

public class RemoveShardingKeyFromShard<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends ShardProcedure<ShardingKey, MetricsT, ProcessT> {
    private static final Logger logger = Logger.getLogger(RemoveShardingKeyFromShard.class.getName());

    public RemoveShardingKeyFromShard(BuilderImpl<?, ShardingKey, MetricsT, ProcessT> builder) throws Exception {
        super(builder);
    }

    public void run() throws Exception {
        AwsShard shard = null;
        for (Map.Entry entry : this.replicaSet.getShards().entrySet()) {
            if (!entry.getKey().getName().equals(this.shardName)) continue;
            shard = entry.getKey();
            break;
        }
        if (shard == null) {
            throw new Exception("Shard not found!");
        }
        logger.info("Removing " + Util.joinStrings((String)", ", (Iterable)this.shardingKeys) + " from " + this.shardName);
        HashSet<Object> shardingKeysFromConditions = new HashSet<Object>();
        for (Rule r : shard.getRules()) {
            for (RuleCondition condition : r.conditions()) {
                if (condition.pathPatternConfig() != null) {
                    shardingKeysFromConditions.addAll(Util.asList((Iterable)Util.filter((Iterable)Util.map((Iterable)condition.values(), this::getShardingKeyFromPathCondition), shardingKey -> !this.shardingKeys.contains(shardingKey))));
                    continue;
                }
                logger.warning("This is strange: shard " + shard.getName() + " of replica set " + shard.getReplicaSetName() + " has a rule " + r + " that has no path pattern condition; ignoring that rule while removing shard.");
            }
        }
        if (shardingKeysFromConditions.isEmpty()) {
            shardingKeysFromConditions.add(this.SHARDING_KEY_UNUSED_BY_ANY_APPLICATION);
        }
        this.getLandscape().deleteLoadBalancerListenerRules(this.region, (Rule[])Util.toArray(shard.getRules(), (Object[])new Rule[0]));
        this.addShardingRules(shard.getLoadBalancer(), shardingKeysFromConditions, shard.getTargetGroup());
    }

    public static <MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>, BuilderT extends ShardProcedure.Builder<BuilderT, RemoveShardingKeyFromShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>, ShardingKey> ShardProcedure.Builder<BuilderT, RemoveShardingKeyFromShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT> builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl<BuilderT extends ShardProcedure.Builder<BuilderT, RemoveShardingKeyFromShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends ShardProcedure.BuilderImpl<BuilderT, RemoveShardingKeyFromShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT> {
        BuilderImpl() {
        }

        public RemoveShardingKeyFromShard<ShardingKey, MetricsT, ProcessT> build() throws Exception {
            assert (this.shardingKeys != null);
            assert (this.replicaSet != null);
            assert (this.region != null);
            return new RemoveShardingKeyFromShard(this);
        }
    }
}

