/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.aicore.impl;

import com.sap.sse.aicore.Credentials;
import com.sap.sse.aicore.CredentialsParser;
import com.sap.sse.aicore.impl.CredentialsImpl;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.Base64;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class CredentialsParserImpl
implements CredentialsParser {
    private static final String CLIENT_ID = "clientid";
    private static final String CLIENT_SECRET = "clientsecret";
    private static final String URL = "url";
    private static final String IDENTITY_ZONE = "identityzone";
    private static final String IDENTITY_ZONE_ID = "identityzoneid";
    private static final String APP_NAME = "appname";
    private static final String SERVICE_URLS = "serviceurls";
    private static final String AI_API_URL = "AI_API_URL";

    @Override
    public Credentials parse(Reader r) throws MalformedURLException, IOException, ParseException {
        JSONParser parser = new JSONParser();
        return this.parse((JSONObject)parser.parse(r));
    }

    @Override
    public Credentials parse(CharSequence s) throws MalformedURLException, ParseException {
        JSONParser parser = new JSONParser();
        return this.parse((JSONObject)parser.parse(s.toString()));
    }

    private Credentials parse(JSONObject o) throws MalformedURLException {
        String clientId = (String)o.get((Object)CLIENT_ID);
        String clientSecret = (String)o.get((Object)CLIENT_SECRET);
        String url = (String)o.get((Object)URL);
        String identityZone = (String)o.get((Object)IDENTITY_ZONE);
        String identityZoneId = (String)o.get((Object)IDENTITY_ZONE_ID);
        String appName = (String)o.get((Object)APP_NAME);
        JSONObject serviceURLs = (JSONObject)o.get((Object)SERVICE_URLS);
        String aiApiUrl = (String)serviceURLs.get((Object)AI_API_URL);
        return new CredentialsImpl(clientId, clientSecret, url, identityZone, identityZoneId, appName, aiApiUrl);
    }

    @Override
    public Util.Pair<String, String> getAsEncodedString(Credentials credentials) {
        String clientId = ((CredentialsImpl)credentials).getClientId();
        String clientSecret = ((CredentialsImpl)credentials).getClientSecret();
        String url = ((CredentialsImpl)credentials).getXsuaaUrl().toString();
        String identityZone = credentials.getIdentityZone();
        String identityZoneId = credentials.getIdentityZoneId();
        String appName = credentials.getAppName();
        String aiApiUrl = credentials.getAiApiUrl().toString();
        JSONObject jsonCredentials = new JSONObject();
        jsonCredentials.put((Object)CLIENT_ID, (Object)clientId);
        jsonCredentials.put((Object)CLIENT_SECRET, (Object)clientSecret);
        jsonCredentials.put((Object)URL, (Object)url);
        jsonCredentials.put((Object)IDENTITY_ZONE, (Object)identityZone);
        jsonCredentials.put((Object)IDENTITY_ZONE_ID, (Object)identityZoneId);
        jsonCredentials.put((Object)APP_NAME, (Object)appName);
        JSONObject serviceURLs = new JSONObject();
        jsonCredentials.put((Object)SERVICE_URLS, (Object)serviceURLs);
        serviceURLs.put((Object)AI_API_URL, (Object)aiApiUrl);
        String salt = this.createRandomAESKeyLength16();
        SecretKeySpec secretKey = new SecretKeySpec(salt.getBytes(), "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKey);
            byte[] encryptedBytes = cipher.doFinal(jsonCredentials.toJSONString().getBytes());
            return new Util.Pair((Object)Base64.getEncoder().encodeToString(encryptedBytes), (Object)salt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String createRandomAESKeyLength16() {
        Random random = new Random();
        int numberOfCharacters = 16;
        char[] chars = new char[16];
        int i = 0;
        while (i < 16) {
            chars[i] = (char)(65 + random.nextInt(57));
            ++i;
        }
        return new String(chars);
    }

    @Override
    public Credentials parseFromEncoded(CharSequence encoded, String Key2) {
        byte[] decodedBytes = Base64.getDecoder().decode(encoded.toString().getBytes());
        SecretKeySpec secretKey = new SecretKeySpec(Key2.getBytes(), "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKey);
            byte[] decryptedBytes = cipher.doFinal(decodedBytes);
            String decryptedString = new String(decryptedBytes);
            return this.parse(decryptedString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

