/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.shared.impl.dto;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.shared.data.ReportParameterToDimensionFilterBindings;
import com.sap.sse.datamining.shared.dto.DataMiningReportDTO;
import com.sap.sse.datamining.shared.dto.FilterDimensionIdentifier;
import com.sap.sse.datamining.shared.dto.FilterDimensionParameter;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.shared.impl.dto.ModifiableStatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.ParameterValueChangeListener;
import com.sap.sse.datamining.shared.impl.dto.parameters.ParameterModelListener;
import com.sap.sse.datamining.shared.impl.dto.parameters.ValueListFilterParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ModifiableDataMiningReportDTO
implements DataMiningReportDTO {
    private static final long serialVersionUID = -6512175470789118223L;
    private ArrayList<ModifiableStatisticQueryDefinitionDTO> queryDefinitions = new ArrayList();
    private HashSet<FilterDimensionParameter> parameters;
    private IdentityHashMap<StatisticQueryDefinitionDTO, HashMap<FilterDimensionIdentifier, FilterDimensionParameter>> parameterUsages;
    private ParameterModelListener _serializationDummy = null;
    private HashMap<FilterDimensionParameter, ParameterModelListener> parameterValueChangeListeners = new HashMap();
    private transient Set<ParameterModelListener> parameterModelListeners;

    public ModifiableDataMiningReportDTO() {
        this(Collections.emptySet(), Collections.emptySet());
    }

    public ModifiableDataMiningReportDTO(Iterable<ModifiableStatisticQueryDefinitionDTO> queryDefinitions, Iterable<FilterDimensionParameter> parameters) {
        Util.addAll(queryDefinitions, this.queryDefinitions);
        this.parameters = new HashSet();
        Util.addAll(parameters, this.parameters);
        this.parameterModelListeners = new HashSet<ParameterModelListener>();
        this.parameterUsages = new IdentityHashMap();
    }

    void adjustAllDimensionFiltersInQueriesUsingParameter(FilterDimensionParameter parameter) {
        for (Util.Pair<StatisticQueryDefinitionDTO, FilterDimensionIdentifier> usage : this.getParameterUsages(parameter)) {
            ModifiableStatisticQueryDefinitionDTO query = (ModifiableStatisticQueryDefinitionDTO)usage.getA();
            DataRetrieverLevelDTO retrieverLevel = ((FilterDimensionIdentifier)usage.getB()).getRetrieverLevel();
            HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> selection = query.getFilterSelection();
            HashMap<FunctionDTO, HashSet<? extends Serializable>> selectionForRetrieverLevel = selection.get(retrieverLevel);
            if (selectionForRetrieverLevel == null) continue;
            selectionForRetrieverLevel.put(((FilterDimensionIdentifier)usage.getB()).getDimensionFunction(), this.createHashSetFromIterable(parameter.getValues()));
            query.setFilterSelectionFor(retrieverLevel, selectionForRetrieverLevel);
            query.setQueryChangedSinceLastRun(true);
        }
    }

    private <T extends Serializable> HashSet<T> createHashSetFromIterable(Iterable<T> iterable) {
        HashSet result = new HashSet();
        Util.addAll(iterable, result);
        return result;
    }

    @Override
    public Iterable<StatisticQueryDefinitionDTO> getQueryDefinitions() {
        return new ArrayList<StatisticQueryDefinitionDTO>(this.queryDefinitions);
    }

    @Override
    public void addQueryDefinition(int index, ModifiableStatisticQueryDefinitionDTO queryDefinition) {
        if (!this.queryDefinitions.stream().anyMatch(qd -> qd == queryDefinition)) {
            this.queryDefinitions.add(index, queryDefinition);
        }
    }

    @Override
    public int removeQueryDefinition(StatisticQueryDefinitionDTO queryDefinition) {
        this.parameterUsages.remove(queryDefinition);
        int index = 0;
        int result = -1;
        Iterator<ModifiableStatisticQueryDefinitionDTO> i = this.queryDefinitions.iterator();
        while (i.hasNext()) {
            if (i.next() == queryDefinition) {
                result = index;
                i.remove();
                break;
            }
            ++index;
        }
        return result;
    }

    @Override
    public Iterable<FilterDimensionParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Iterable<Util.Pair<StatisticQueryDefinitionDTO, FilterDimensionIdentifier>> getParameterUsages(FilterDimensionParameter parameter) {
        ArrayList<Util.Pair<StatisticQueryDefinitionDTO, FilterDimensionIdentifier>> result = new ArrayList<Util.Pair<StatisticQueryDefinitionDTO, FilterDimensionIdentifier>>();
        for (Map.Entry<StatisticQueryDefinitionDTO, HashMap<FilterDimensionIdentifier, FilterDimensionParameter>> e : this.parameterUsages.entrySet()) {
            for (FilterDimensionIdentifier f : e.getValue().keySet()) {
                if (e.getValue().get(f) != parameter) continue;
                result.add((Util.Pair<StatisticQueryDefinitionDTO, FilterDimensionIdentifier>)new Util.Pair((Object)e.getKey(), (Object)f));
            }
        }
        return result;
    }

    @Override
    public ReportParameterToDimensionFilterBindings getParameterUsages(StatisticQueryDefinitionDTO query) {
        return new ReportParameterToDimensionFilterBindings((Map<FilterDimensionIdentifier, FilterDimensionParameter>)this.parameterUsages.get(query));
    }

    @Override
    public FilterDimensionParameter getUsedParameter(StatisticQueryDefinitionDTO query, FilterDimensionIdentifier filterDimensionIdentifier) {
        HashMap<FilterDimensionIdentifier, FilterDimensionParameter> parameterUsagesInQuery = this.parameterUsages.get(query);
        FilterDimensionParameter result = parameterUsagesInQuery != null ? parameterUsagesInQuery.get(filterDimensionIdentifier) : null;
        return result;
    }

    @Override
    public FilterDimensionParameter createParameter(String name, String typeName, Iterable<? extends Serializable> values) {
        ValueListFilterParameter parameter = new ValueListFilterParameter(name, typeName, values);
        ParameterValueChangeListener valueChangeListener = new ParameterValueChangeListener(this);
        parameter.addParameterModelListener(valueChangeListener);
        this.parameterValueChangeListeners.put(parameter, valueChangeListener);
        this.parameters.add(parameter);
        this.getParameterModelListeners().forEach(l -> l.parameterAdded(this, parameter));
        return parameter;
    }

    @Override
    public void addParameterUsage(StatisticQueryDefinitionDTO query, FilterDimensionIdentifier filterDimensionIdentifier, FilterDimensionParameter parameter) {
        if (!Util.contains(this.getParameters(), (Object)parameter)) {
            throw new IllegalArgumentException("Parameter " + parameter.getName() + " is not part of this report");
        }
        if (!Util.stream(this.getQueryDefinitions()).anyMatch(q -> q == query)) {
            throw new IllegalArgumentException("Query " + query + " is not part of this report");
        }
        this.parameterUsages.computeIfAbsent(query, k -> new HashMap()).put(filterDimensionIdentifier, parameter);
    }

    @Override
    public void removeParameterUsage(StatisticQueryDefinitionDTO query, FilterDimensionIdentifier filterDimensionIdentifier, FilterDimensionParameter parameter) {
        if (this.parameterUsages.containsKey(query)) {
            this.parameterUsages.get(query).remove(filterDimensionIdentifier);
        }
    }

    @Override
    public void removeParameter(FilterDimensionParameter parameter) {
        ParameterModelListener valueChangeListener = this.parameterValueChangeListeners.get(parameter);
        if (valueChangeListener != null) {
            parameter.removeParameterModelListener(valueChangeListener);
            this.parameterValueChangeListeners.remove(parameter);
        }
        this.parameters.remove(parameter);
        this.getParameterModelListeners().forEach(l -> l.parameterRemoved(this, parameter));
        this.removeParameterUsages(parameter);
    }

    private void removeParameterUsages(FilterDimensionParameter parameter) {
        for (Map.Entry<StatisticQueryDefinitionDTO, HashMap<FilterDimensionIdentifier, FilterDimensionParameter>> parametersUsedInQuery : this.parameterUsages.entrySet()) {
            Iterator<Map.Entry<FilterDimensionIdentifier, FilterDimensionParameter>> parameterUsageInQueryIter = parametersUsedInQuery.getValue().entrySet().iterator();
            while (parameterUsageInQueryIter.hasNext()) {
                Map.Entry<FilterDimensionIdentifier, FilterDimensionParameter> parameterUsageInQuery = parameterUsageInQueryIter.next();
                if (parameterUsageInQuery.getValue() != parameter) continue;
                parameterUsageInQueryIter.remove();
            }
        }
    }

    private Set<ParameterModelListener> getParameterModelListeners() {
        if (this.parameterModelListeners == null) {
            this.parameterModelListeners = new HashSet<ParameterModelListener>();
        }
        return this.parameterModelListeners;
    }

    @Override
    public void addParamterModelListener(ParameterModelListener listener) {
        this.getParameterModelListeners().add(listener);
    }

    @Override
    public void removeParameterModelListener(ParameterModelListener listener) {
        this.getParameterModelListeners().remove(listener);
    }
}

