/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.persistence.impl;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.sap.sailing.domain.tractracadapter.TracTracConfiguration;
import com.sap.sailing.domain.tractracadapter.persistence.MongoObjectFactory;
import com.sap.sailing.domain.tractracadapter.persistence.impl.CollectionNames;
import com.sap.sailing.domain.tractracadapter.persistence.impl.FieldNames;
import java.util.ArrayList;
import java.util.Arrays;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoObjectFactoryImpl
implements MongoObjectFactory {
    private final MongoDatabase database;

    public MongoObjectFactoryImpl(MongoDatabase database) {
        this.database = database;
    }

    @Override
    public void clear() {
        this.database.getCollection(CollectionNames.TRACTRAC_CONFIGURATIONS.name()).withWriteConcern(WriteConcern.ACKNOWLEDGED).drop();
    }

    @Override
    public void createTracTracConfiguration(TracTracConfiguration tracTracConfiguration) {
        MongoCollection ttConfigCollection = this.database.getCollection(CollectionNames.TRACTRAC_CONFIGURATIONS.name());
        Bson result = this.getUpdateForTracTracConfiguration(tracTracConfiguration);
        ttConfigCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).updateOne((Bson)this.getMongoQueryForConfiguration(tracTracConfiguration), result, new UpdateOptions().upsert(true));
    }

    @Override
    public void updateTracTracConfiguration(TracTracConfiguration tracTracConfiguration) {
        MongoCollection ttConfigCollection = this.database.getCollection(CollectionNames.TRACTRAC_CONFIGURATIONS.name());
        Bson result = this.getUpdateForTracTracConfiguration(tracTracConfiguration);
        Document updateQuery = this.getMongoQueryForConfiguration(tracTracConfiguration);
        updateQuery.put(FieldNames.TT_CONFIG_CREATOR_NAME.name(), (Object)tracTracConfiguration.getCreatorName());
        ttConfigCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).updateOne((Bson)updateQuery, result, new UpdateOptions().upsert(true));
    }

    private Document getMongoQueryForConfiguration(TracTracConfiguration tracTracConfiguration) {
        String jsonUrl = tracTracConfiguration.getJSONURL();
        return MongoObjectFactoryImpl.getMongoQueryForJsonUrl(jsonUrl);
    }

    static Document getMongoQueryForJsonUrl(String jsonUrl) {
        Document updateQuery = new Document(FieldNames.TT_CONFIG_JSON_URL.name(), (Object)jsonUrl);
        return updateQuery;
    }

    private Bson getUpdateForTracTracConfiguration(TracTracConfiguration tracTracConfiguration) {
        ArrayList<Bson> updates = new ArrayList<Bson>();
        updates.addAll(Arrays.asList(Updates.set((String)FieldNames.TT_CONFIG_CREATOR_NAME.name(), (Object)tracTracConfiguration.getCreatorName()), Updates.set((String)FieldNames.TT_CONFIG_NAME.name(), (Object)tracTracConfiguration.getName()), Updates.set((String)FieldNames.TT_CONFIG_JSON_URL.name(), (Object)tracTracConfiguration.getJSONURL()), Updates.set((String)FieldNames.TT_CONFIG_LIVE_DATA_URI.name(), (Object)tracTracConfiguration.getLiveDataURI()), Updates.set((String)FieldNames.TT_CONFIG_STORED_DATA_URI.name(), (Object)tracTracConfiguration.getStoredDataURI()), Updates.set((String)FieldNames.TT_CONFIG_COURSE_DESIGN_UPDATE_URI.name(), (Object)tracTracConfiguration.getUpdateURI()), Updates.set((String)FieldNames.TT_CONFIG_TRACTRAC_USERNAME.name(), (Object)tracTracConfiguration.getTracTracUsername())));
        if (tracTracConfiguration.getTracTracPassword() != null) {
            updates.add(Updates.set((String)FieldNames.TT_CONFIG_TRACTRAC_PASSWORD.name(), (Object)tracTracConfiguration.getTracTracPassword()));
        }
        return Updates.combine((Bson[])updates.toArray(new Bson[updates.size()]));
    }

    @Override
    public void deleteTracTracConfiguration(String creatorName, String jsonUrl) {
        MongoCollection ttConfigCollection = this.database.getCollection(CollectionNames.TRACTRAC_CONFIGURATIONS.name());
        Document deleteQuery = MongoObjectFactoryImpl.getMongoQueryForJsonUrl(jsonUrl);
        deleteQuery.put(FieldNames.TT_CONFIG_CREATOR_NAME.name(), (Object)creatorName);
        ttConfigCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).deleteOne((Bson)deleteQuery);
    }
}

