/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasWindFixContext;
import com.sap.sailing.datamining.data.HasWindTrackContext;
import com.sap.sailing.datamining.impl.data.WindFixWithContext;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public class WindFixRetrievalProcessor
extends AbstractRetrievalProcessor<HasWindTrackContext, HasWindFixContext> {
    public WindFixRetrievalProcessor(ExecutorService executor, Collection<Processor<HasWindFixContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasWindTrackContext.class, HasWindFixContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasWindFixContext> retrieveData(HasWindTrackContext element) {
        ArrayList<HasWindFixContext> windFixesWithContext = new ArrayList<HasWindFixContext>();
        WindTrack windTrack = element.getWindTrack();
        windTrack.lockForRead();
        try {
            for (Wind wind : windTrack.getFixes()) {
                if (this.isAborted()) {
                    break;
                }
                windFixesWithContext.add(new WindFixWithContext(element, wind, element.getWindSourceType()));
            }
        }
        finally {
            windTrack.unlockAfterRead();
        }
        return windFixesWithContext;
    }
}

