/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasCompleteManeuverCurveWithEstimationDataContext;
import com.sap.sailing.datamining.data.HasRaceOfCompetitorContext;
import com.sap.sailing.datamining.impl.data.CompleteManeuverCurveWithEstimationDataWithContext;
import com.sap.sailing.datamining.shared.ManeuverSettings;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.maneuverdetection.CompleteManeuverCurveWithEstimationData;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverDetectorImpl;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverDetectorWithEstimationDataSupportDecoratorImpl;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Duration;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class CompleteManeuverCurveWithEstimationDataRetrievalProcessor
extends AbstractRetrievalProcessor<HasRaceOfCompetitorContext, HasCompleteManeuverCurveWithEstimationDataContext> {
    private final ManeuverSettings settings;

    public CompleteManeuverCurveWithEstimationDataRetrievalProcessor(ExecutorService executor, Collection<Processor<HasCompleteManeuverCurveWithEstimationDataContext, ?>> resultReceivers, ManeuverSettings settings, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasRaceOfCompetitorContext.class, HasCompleteManeuverCurveWithEstimationDataContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
        this.settings = settings;
    }

    protected Iterable<HasCompleteManeuverCurveWithEstimationDataContext> retrieveData(HasRaceOfCompetitorContext element) {
        ArrayList<HasCompleteManeuverCurveWithEstimationDataContext> result = new ArrayList<HasCompleteManeuverCurveWithEstimationDataContext>();
        TrackedRace trackedRace = element.getTrackedRaceContext().getTrackedRace();
        Competitor competitor = element.getCompetitor();
        ManeuverDetectorWithEstimationDataSupportDecoratorImpl maneuverDetector = new ManeuverDetectorWithEstimationDataSupportDecoratorImpl(new ManeuverDetectorImpl(trackedRace, competitor), element.getTrackedRaceContext().getLeaderboardContext().getLeaderboardGroupContext().getPolarDataService());
        Iterable maneuvers = trackedRace.getManeuvers(competitor, false);
        if (this.isAborted()) {
            return result;
        }
        List maneuverCurves = maneuverDetector.getCompleteManeuverCurves(maneuvers);
        if (this.isAborted()) {
            return result;
        }
        List maneuversWithEstimationData = maneuverDetector.getCompleteManeuverCurvesWithEstimationData((Iterable)maneuverCurves);
        CompleteManeuverCurveWithEstimationData previousManeuver = null;
        CompleteManeuverCurveWithEstimationData currentManeuver = null;
        for (CompleteManeuverCurveWithEstimationData nextManeuver : maneuversWithEstimationData) {
            if (this.isAborted()) break;
            if (currentManeuver != null) {
                CompleteManeuverCurveWithEstimationDataWithContext maneuverWithContext = new CompleteManeuverCurveWithEstimationDataWithContext(element, currentManeuver, this.settings, previousManeuver, nextManeuver);
                if (currentManeuver.getWind() != null && this.isManeuverCompliantWithSettings(previousManeuver, maneuverWithContext, nextManeuver)) {
                    result.add(maneuverWithContext);
                }
            }
            previousManeuver = currentManeuver;
            currentManeuver = nextManeuver;
        }
        if (currentManeuver != null) {
            CompleteManeuverCurveWithEstimationDataWithContext maneuverWithContext = new CompleteManeuverCurveWithEstimationDataWithContext(element, currentManeuver, this.settings, previousManeuver, null);
            if (currentManeuver.getWind() != null && this.isManeuverCompliantWithSettings(previousManeuver, maneuverWithContext, null)) {
                result.add(maneuverWithContext);
            }
        }
        return result;
    }

    private boolean isManeuverCompliantWithSettings(CompleteManeuverCurveWithEstimationData previousManeuver, CompleteManeuverCurveWithEstimationDataWithContext currentManeuverWithContext, CompleteManeuverCurveWithEstimationData nextManeuver) {
        Duration durationToNextManeuver;
        boolean mainCurveAnalysis = this.settings.isMainCurveAnalysis();
        Duration maneuverDuration = this.settings.getMinManeuverDuration() != null || this.settings.getMaxManeuverDuration() != null ? currentManeuverWithContext.getTimePointBeforeForAnalysis().until(currentManeuverWithContext.getTimePointAfterForAnalysis()) : null;
        double maneuverEnteringSpeed = this.settings.getMinManeuverEnteringSpeedInKnots() != null || this.settings.getMaxManeuverEnteringSpeedInKnots() != null ? currentManeuverWithContext.getManeuverEnteringSpeed() : 0.0;
        double maneuverExitingSpeed = this.settings.getMinManeuverExitingSpeedInKnots() != null || this.settings.getMaxManeuverExitingSpeedInKnots() != null ? currentManeuverWithContext.getManeuverExitingSpeed() : 0.0;
        double maneuverEnteringAbsTWA = this.settings.getMinManeuverEnteringAbsTWA() != null ? currentManeuverWithContext.getEnteringAbsTWA() : 0.0;
        double maneuverExitingAbsTWA = this.settings.getMinManeuverExitingAbsTWA() != null ? currentManeuverWithContext.getExitingAbsTWA() : 0.0;
        Duration durationToPreviousManeuver = previousManeuver != null ? this.getManeuverBoundariesForAnalysis(previousManeuver, mainCurveAnalysis).getTimePointAfter().until(currentManeuverWithContext.getTimePointBeforeForAnalysis()) : null;
        Duration duration = durationToNextManeuver = nextManeuver != null ? currentManeuverWithContext.getTimePointAfterForAnalysis().until(this.getManeuverBoundariesForAnalysis(nextManeuver, mainCurveAnalysis).getTimePointBefore()) : null;
        return !(this.settings.getMinManeuverDuration() != null && maneuverDuration.compareTo((Object)this.settings.getMinManeuverDuration()) < 0 || this.settings.getMaxManeuverDuration() != null && maneuverDuration.compareTo((Object)this.settings.getMaxManeuverDuration()) > 0 || this.settings.getMinManeuverEnteringSpeedInKnots() != null && maneuverEnteringSpeed < this.settings.getMinManeuverEnteringSpeedInKnots() || this.settings.getMaxManeuverEnteringSpeedInKnots() != null && maneuverEnteringSpeed > this.settings.getMaxManeuverEnteringSpeedInKnots() || this.settings.getMinManeuverExitingSpeedInKnots() != null && maneuverExitingSpeed < this.settings.getMinManeuverExitingSpeedInKnots() || this.settings.getMaxManeuverExitingSpeedInKnots() != null && maneuverExitingSpeed > this.settings.getMaxManeuverExitingSpeedInKnots() || this.settings.getMinManeuverEnteringAbsTWA() != null && maneuverEnteringAbsTWA < this.settings.getMinManeuverEnteringAbsTWA() || this.settings.getMaxManeuverEnteringAbsTWA() != null && maneuverEnteringAbsTWA > this.settings.getMaxManeuverEnteringAbsTWA() || this.settings.getMinManeuverExitingAbsTWA() != null && maneuverExitingAbsTWA < this.settings.getMinManeuverExitingAbsTWA() || this.settings.getMaxManeuverExitingAbsTWA() != null && maneuverExitingAbsTWA > this.settings.getMaxManeuverExitingAbsTWA() || this.settings.getMinAbsCourseChangeInDegrees() != null && currentManeuverWithContext.getAbsoluteDirectionChangeInDegrees() < this.settings.getMinAbsCourseChangeInDegrees() || this.settings.getMaxAbsCourseChangeInDegrees() != null && currentManeuverWithContext.getAbsoluteDirectionChangeInDegrees() > this.settings.getMaxAbsCourseChangeInDegrees() || this.settings.getMinDurationFromPrecedingManeuver() != null && (previousManeuver == null || durationToPreviousManeuver.compareTo((Object)this.settings.getMinDurationFromPrecedingManeuver()) < 0) || this.settings.getMaxDurationFromPrecedingManeuver() != null && (previousManeuver == null || durationToPreviousManeuver.compareTo((Object)this.settings.getMaxDurationFromPrecedingManeuver()) > 0) || this.settings.getMinDurationToFollowingManeuver() != null && (nextManeuver == null || durationToNextManeuver.compareTo((Object)this.settings.getMinDurationToFollowingManeuver()) < 0) || this.settings.getMaxDurationToFollowingManeuver() != null && (nextManeuver == null || durationToNextManeuver.compareTo((Object)this.settings.getMaxDurationToFollowingManeuver()) > 0));
    }

    private ManeuverCurveBoundaries getManeuverBoundariesForAnalysis(CompleteManeuverCurveWithEstimationData maneuver, boolean mainCurveAnalysis) {
        return mainCurveAnalysis ? maneuver.getMainCurve() : maneuver.getCurveWithUnstableCourseAndSpeed();
    }
}

