/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.impl;

import com.jcraft.jsch.JSchException;
import com.sap.sailing.landscape.SailingAnalyticsHost;
import com.sap.sailing.landscape.SailingAnalyticsMetrics;
import com.sap.sailing.landscape.SailingAnalyticsProcess;
import com.sap.sailing.landscape.SailingReleaseRepository;
import com.sap.sailing.landscape.procedures.SailingProcessConfigurationVariables;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.ReleaseRepository;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.MongoUriParser;
import com.sap.sse.landscape.aws.impl.AwsApplicationProcessImpl;
import com.sap.sse.landscape.impl.ReleaseImpl;
import com.sap.sse.landscape.mongodb.Database;
import com.sap.sse.shared.util.Wait;
import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sap.sse.util.LaxRedirectStrategyForAllRedirectResponseCodes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SailingAnalyticsProcessImpl<ShardingKey>
extends AwsApplicationProcessImpl<ShardingKey, SailingAnalyticsMetrics, SailingAnalyticsProcess<ShardingKey>>
implements SailingAnalyticsProcess<ShardingKey> {
    private static final Logger logger = Logger.getLogger(SailingAnalyticsProcessImpl.class.getName());
    private static final String STATUS_SERVERNAME_PROPERTY_NAME = "servername";
    private static final String STATUS_SERVERDIRECTORY_PROPERTY_NAME = "serverdirectory";
    private static final String STATUS_RELEASE_PROPERTY_NAME = "release";
    private static final String MONGODB_CONFIGURATION_PROPERTY_NAME = "mongoDbConfiguration";
    private Integer expeditionUdpPort;
    private Integer igtimiRiotPort;
    private Release release;
    private TimePoint startTimePoint;

    public SailingAnalyticsProcessImpl(int port, SailingAnalyticsHost<ShardingKey> host, String serverDirectory, Integer expeditionUdpPort, Integer igtimiRiotPort, AwsLandscape<ShardingKey> landscape) {
        super(port, host, serverDirectory, landscape);
        this.expeditionUdpPort = expeditionUdpPort;
        this.igtimiRiotPort = igtimiRiotPort;
    }

    public SailingAnalyticsProcessImpl(int port, SailingAnalyticsHost<ShardingKey> host, String serverDirectory, Integer telnetPort, String serverName, Integer expeditionUdpPort, Integer igtimiRiotPort, AwsLandscape<ShardingKey> landscape) {
        super(port, host, serverDirectory, telnetPort, serverName, landscape);
        this.expeditionUdpPort = expeditionUdpPort;
        this.igtimiRiotPort = igtimiRiotPort;
    }

    public String getHealthCheckPath() {
        return "/gwt/status";
    }

    protected String getDefaultApplicationUsername() {
        return "sailing";
    }

    private JSONObject getStatus(Optional<Duration> optionalTimeout) throws TimeoutException, Exception {
        HttpGet getStatusRequest = new HttpGet(this.getHealthCheckUrl(optionalTimeout).toString());
        JSONObject status = (JSONObject)Wait.wait(() -> {
            CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategyForAllRedirectResponseCodes()).build();
            HttpResponse result = client.execute((HttpUriRequest)getStatusRequest);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            result.getEntity().writeTo((OutputStream)bos);
            return (JSONObject)new JSONParser().parse((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()), HttpUrlConnectionHelper.getCharsetFromHttpEntity((HttpEntity)result.getEntity(), (String)"UTF-8")));
        }, json -> json != null, (boolean)true, optionalTimeout, (Duration)Duration.ONE_SECOND.times(5L), (Level)Level.INFO, (String)("getStatus() on " + this.getHost() + ":" + this.getPort()));
        this.updateStartTimePointFromStatus(status);
        this.updateReleaseFromStatus(status);
        this.updateServerNameFromStatus(status);
        this.updateServerDirectoryFromStatus(status);
        return status;
    }

    private boolean updateReleaseFromStatus(JSONObject status) {
        boolean success;
        if (status.containsKey((Object)STATUS_RELEASE_PROPERTY_NAME)) {
            this.release = new ReleaseImpl((String)status.get((Object)STATUS_RELEASE_PROPERTY_NAME), SailingReleaseRepository.INSTANCE);
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    public Release getRelease(ReleaseRepository releaseRepository, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        JSONObject status;
        if (this.release == null && !this.updateReleaseFromStatus(status = this.getStatus(optionalTimeout))) {
            this.release = super.getRelease(releaseRepository, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        }
        return this.release;
    }

    public Database getDatabaseConfiguration(Region region, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        JSONObject mongoDBConfiguration = (JSONObject)this.getStatus(optionalTimeout).get((Object)MONGODB_CONFIGURATION_PROPERTY_NAME);
        return new MongoUriParser(this.getLandscape(), region).parseMongoDBConfigurationFromStatus(mongoDBConfiguration);
    }

    private void updateServerNameFromStatus(JSONObject status) {
        this.serverName = status.get((Object)STATUS_SERVERNAME_PROPERTY_NAME).toString();
    }

    private void updateServerDirectoryFromStatus(JSONObject status) {
        if (this.serverDirectory == null) {
            this.serverDirectory = status.containsKey((Object)STATUS_SERVERDIRECTORY_PROPERTY_NAME) ? status.get((Object)STATUS_SERVERDIRECTORY_PROPERTY_NAME).toString() : "/home/sailing/servers/" + status.get((Object)STATUS_SERVERNAME_PROPERTY_NAME).toString();
        }
    }

    public String getServerName(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws TimeoutException, Exception {
        if (this.serverName == null) {
            this.getStatus(optionalTimeout);
        }
        return this.serverName;
    }

    public String getServerDirectory(Optional<Duration> optionalTimeout) throws TimeoutException, Exception {
        if (this.serverDirectory == null) {
            this.getStatus(optionalTimeout);
        }
        return this.serverDirectory;
    }

    public Release getVersion(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return this.getRelease(SailingReleaseRepository.INSTANCE, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    public TimePoint getStartTimePoint(Optional<Duration> optionalTimeout) throws Exception {
        if (this.startTimePoint == null) {
            this.getStatus(optionalTimeout);
        }
        return this.startTimePoint;
    }

    private void updateStartTimePointFromStatus(JSONObject status) throws ParseException {
        Object startTimeMillis = status.get((Object)"start_time_millis");
        if (startTimeMillis == null) {
            String buildversion = (String)status.get((Object)"buildversion");
            Pattern buildversionPattern = Pattern.compile("^.* Started: ([0-9]+)$");
            Matcher matcher = buildversionPattern.matcher(buildversion);
            if (buildversion != null && matcher.matches()) {
                String timestamp = matcher.group(1);
                this.startTimePoint = TimePoint.of((Date)new SimpleDateFormat("yyyyMMddhhmmX").parse(String.valueOf(timestamp) + "Z"));
            } else {
                this.startTimePoint = null;
            }
        } else {
            this.startTimePoint = TimePoint.of((Long)Long.valueOf(startTimeMillis.toString()));
        }
    }

    @Override
    public int getExpeditionUdpPort(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        if (this.expeditionUdpPort == null) {
            this.expeditionUdpPort = Integer.parseInt(this.getEnvShValueFor(SailingProcessConfigurationVariables.EXPEDITION_PORT.name(), optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase));
        }
        return this.expeditionUdpPort;
    }

    @Override
    public Integer getIgtimiRiotPort(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        if (this.igtimiRiotPort == null) {
            String igtimiRiotPortEnvVar = this.getEnvShValueFor(SailingProcessConfigurationVariables.IGTIMI_RIOT_PORT.name(), optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
            this.igtimiRiotPort = Util.hasLength((String)igtimiRiotPortEnvVar) ? Integer.valueOf(Integer.parseInt(igtimiRiotPortEnvVar)) : null;
        }
        return this.igtimiRiotPort;
    }

    public int[] getAllTCPPorts(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        int[] result;
        Integer igtimiRiotPort = this.getIgtimiRiotPort(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        if (igtimiRiotPort == null) {
            result = super.getAllTCPPorts(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        } else {
            int[] superTCPPorts = super.getAllTCPPorts(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
            result = new int[superTCPPorts.length + 1];
            System.arraycopy(superTCPPorts, 0, result, 0, superTCPPorts.length);
            result[result.length - 1] = igtimiRiotPort;
        }
        return result;
    }

    public int[] getAllUDPPorts(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        int[] superUDPPorts = super.getAllUDPPorts(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        int[] result = new int[superUDPPorts.length + 1];
        System.arraycopy(superUDPPorts, 0, result, 0, superUDPPorts.length);
        result[result.length - 1] = this.getExpeditionUdpPort(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        return result;
    }

    public void stopAndTerminateIfLast(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) {
        try {
            this.tryShutdown(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
            logger.info("Removing server directory " + this.getServerDirectory(Landscape.WAIT_FOR_PROCESS_TIMEOUT) + " of " + this);
            this.getHost().createRootSshChannel(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase).runCommandAndReturnStdoutAndLogStderr("rm -rf \"" + this.getServerDirectory(Landscape.WAIT_FOR_PROCESS_TIMEOUT) + "\"", "Removing server directory " + this.getServerDirectory(Landscape.WAIT_FOR_PROCESS_TIMEOUT), Level.INFO);
            Iterable applicationProcesses = this.getHost().getApplicationProcesses(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase, true);
            if (Util.isEmpty((Iterable)applicationProcesses)) {
                logger.info("No more application processes running on " + this.getHost() + "; terminating");
                this.getHost().terminate();
            } else {
                logger.info("There are other application processes deployed on " + this.getHost() + ": " + Util.joinStrings((String)", ", (Iterable)applicationProcesses) + ". Leaving " + this.getHost() + " running.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SailingAnalyticsHost<ShardingKey> getHost() {
        SailingAnalyticsHost result = (SailingAnalyticsHost)super.getHost();
        return result;
    }

    @Override
    public void refreshToRelease(Release release, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws IOException, InterruptedException, JSchException, Exception {
        logger.info("Upgrading process " + this + " to release " + release.getName());
        this.getHost().createRootSshChannel(Landscape.WAIT_FOR_PROCESS_TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase).runCommandAndReturnStdoutAndLogStderr("su -l sailing -c \"cd " + this.getServerDirectory(Landscape.WAIT_FOR_PROCESS_TIMEOUT).replaceAll("\"", "\\\\\"") + "; " + "./refreshInstance.sh install-release " + release.getName() + " && ./stop && ./start" + "\"", "Refreshing process to release " + release.getName(), Level.INFO);
        this.release = release;
    }
}

