/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.impl;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sailing.landscape.ALBToReverseProxyArchiveRedirectMapper;
import com.sap.sailing.landscape.AwsSessionCredentialsWithExpiry;
import com.sap.sailing.landscape.LandscapeService;
import com.sap.sailing.landscape.SailingAnalyticsHost;
import com.sap.sailing.landscape.SailingAnalyticsMetrics;
import com.sap.sailing.landscape.SailingAnalyticsProcess;
import com.sap.sailing.landscape.SailingReleaseRepository;
import com.sap.sailing.landscape.impl.AwsSessionCredentialsFromUserPreference;
import com.sap.sailing.landscape.impl.AwsSessionCredentialsWithExpiryImpl;
import com.sap.sailing.landscape.impl.BearerTokenReplicationCredentials;
import com.sap.sailing.landscape.impl.EligibleInstanceForReplicaSetFindingStrategyImpl;
import com.sap.sailing.landscape.impl.SailingAnalyticsProcessImpl;
import com.sap.sailing.landscape.procedures.CreateLaunchTemplateAndAutoScalingGroup;
import com.sap.sailing.landscape.procedures.DeployProcessOnMultiServer;
import com.sap.sailing.landscape.procedures.SailingAnalyticsHostSupplier;
import com.sap.sailing.landscape.procedures.SailingAnalyticsMasterConfiguration;
import com.sap.sailing.landscape.procedures.SailingAnalyticsProcessFactory;
import com.sap.sailing.landscape.procedures.SailingAnalyticsReplicaConfiguration;
import com.sap.sailing.landscape.procedures.SailingProcessConfigurationVariables;
import com.sap.sailing.landscape.procedures.StartMultiServer;
import com.sap.sailing.landscape.procedures.StartSailingAnalyticsMasterHost;
import com.sap.sailing.landscape.procedures.StartSailingAnalyticsReplicaHost;
import com.sap.sailing.server.gateway.interfaces.CompareServersResult;
import com.sap.sailing.server.gateway.interfaces.MasterDataImportResult;
import com.sap.sailing.server.gateway.interfaces.SailingServer;
import com.sap.sailing.server.gateway.interfaces.SailingServerFactory;
import com.sap.sse.ServerInfo;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.mail.MailException;
import com.sap.sse.i18n.impl.ResourceBundleStringMessagesImpl;
import com.sap.sse.landscape.DefaultProcessConfigurationVariables;
import com.sap.sse.landscape.InboundReplicationConfiguration;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.ReplicationCredentials;
import com.sap.sse.landscape.application.ProcessFactory;
import com.sap.sse.landscape.aws.AmazonMachineImage;
import com.sap.sse.landscape.aws.AwsApplicationProcess;
import com.sap.sse.landscape.aws.AwsApplicationReplicaSet;
import com.sap.sse.landscape.aws.AwsAutoScalingGroup;
import com.sap.sse.landscape.aws.AwsAvailabilityZone;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.AwsShard;
import com.sap.sse.landscape.aws.ReverseProxyCluster;
import com.sap.sse.landscape.aws.Tags;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.common.shared.RedirectDTO;
import com.sap.sse.landscape.aws.impl.AwsApplicationReplicaSetImpl;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import com.sap.sse.landscape.aws.impl.DNSCache;
import com.sap.sse.landscape.aws.orchestration.AddShardingKeyToShard;
import com.sap.sse.landscape.aws.orchestration.AwsApplicationConfiguration;
import com.sap.sse.landscape.aws.orchestration.CopyAndCompareMongoDatabase;
import com.sap.sse.landscape.aws.orchestration.CreateDNSBasedLoadBalancerMapping;
import com.sap.sse.landscape.aws.orchestration.CreateDynamicLoadBalancerMapping;
import com.sap.sse.landscape.aws.orchestration.CreateLoadBalancerMapping;
import com.sap.sse.landscape.aws.orchestration.CreateShard;
import com.sap.sse.landscape.aws.orchestration.RemoveShardingKeyFromShard;
import com.sap.sse.landscape.aws.orchestration.ShardProcedure;
import com.sap.sse.landscape.aws.orchestration.StartAwsHost;
import com.sap.sse.landscape.mongodb.Database;
import com.sap.sse.landscape.mongodb.MongoEndpoint;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.SessionUtils;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.ServerAdminRole;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.util.RemoteServerUtil;
import com.sap.sse.shared.util.Wait;
import com.sap.sse.util.JvmUtils;
import com.sap.sse.util.ServiceTrackerFactory;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.ClientProtocolException;
import org.apache.shiro.authz.AuthorizationException;
import org.json.simple.parser.ParseException;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.sts.model.Credentials;

public class LandscapeServiceImpl
implements LandscapeService {
    private static final Logger logger = Logger.getLogger(LandscapeServiceImpl.class.getName());
    private static final String STRING_MESSAGES_BASE_NAME = "stringmessages/SailingLandscape_StringMessages";
    private static final String TEMPORARY_UPGRADE_REPLICA_NAME_SUFFIX = " (Upgrade Replica)";
    private static final String UPGRADE_REPLICA_TAG_KEY = "upgradeReplica";
    private final FullyInitializedReplicableTracker<SecurityService> securityServiceTracker;
    private final ProcessFactory<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>, SailingAnalyticsHost<String>> processFactoryFromHostAndServerDirectory;
    private final ServiceTracker<SailingServerFactory, SailingServerFactory> sailingServerFactoryTracker;

    public LandscapeServiceImpl(BundleContext context) {
        this.securityServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
        this.sailingServerFactoryTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, SailingServerFactory.class);
        this.processFactoryFromHostAndServerDirectory = (host, port, serverDirectory, telnetPort, serverName, additionalProperties) -> {
            try {
                Number expeditionUdpPort = (Number)additionalProperties.get(SailingProcessConfigurationVariables.EXPEDITION_PORT.name());
                Number igtimiRiotPort = (Number)additionalProperties.get(SailingProcessConfigurationVariables.IGTIMI_RIOT_PORT.name());
                return new SailingAnalyticsProcessImpl<String>(port, (SailingAnalyticsHost<String>)host, serverDirectory, telnetPort, serverName, expeditionUdpPort == null ? null : Integer.valueOf(expeditionUdpPort.intValue()), igtimiRiotPort == null ? null : Integer.valueOf(igtimiRiotPort.intValue()), this.getLandscape());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> createApplicationReplicaSet(String regionId, String name, boolean newSharedMasterInstance, String sharedInstanceType, String dedicatedInstanceType, boolean dynamicLoadBalancerMapping, String releaseNameOrNullForLatestMaster, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String masterReplicationBearerToken, String replicaReplicationBearerToken, String optionalDomainName, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull, Integer optionalIgtimiRiotPort, Optional<Integer> minimumAutoScalingGroupSize, Optional<Integer> maximumAutoScalingGroupSize) throws Exception {
        String hostname;
        AwsLandscape<String> landscape = this.getLandscape();
        Iterable existingDNSRulesForHostname = landscape.getResourceRecordSets(hostname = this.getHostname(name, optionalDomainName));
        if (existingDNSRulesForHostname != null && !Util.isEmpty((Iterable)existingDNSRulesForHostname)) {
            throw new IllegalArgumentException("DNS record for " + hostname + " already exists");
        }
        AwsRegion region = new AwsRegion(regionId, landscape);
        Release release = this.getRelease(releaseNameOrNullForLatestMaster);
        Object masterConfigurationBuilder = this.createMasterConfigurationBuilder(name, masterReplicationBearerToken, optionalMemoryInMegabytesOrNull, newSharedMasterInstance ? optionalMemoryTotalSizeFactorOrNull : null, optionalIgtimiRiotPort, region, release);
        String bearerTokenUsedByReplicas = this.getEffectiveBearerToken(replicaReplicationBearerToken);
        InboundReplicationConfiguration inboundMasterReplicationConfiguration = (InboundReplicationConfiguration)masterConfigurationBuilder.getInboundReplicationConfiguration().get();
        this.establishServerGroupAndTryToMakeCurrentUserItsOwnerAndMember(name, bearerTokenUsedByReplicas, inboundMasterReplicationConfiguration.getMasterHostname(), inboundMasterReplicationConfiguration.getMasterHttpPort());
        Object masterHostBuilder = StartSailingAnalyticsMasterHost.masterHostBuilder(masterConfigurationBuilder);
        ((StartSailingAnalyticsMasterHost.Builder)((StartSailingAnalyticsMasterHost.Builder)((StartSailingAnalyticsMasterHost.Builder)((StartSailingAnalyticsMasterHost.Builder)masterHostBuilder.setInstanceType(InstanceType.valueOf((String)(newSharedMasterInstance ? sharedInstanceType : dedicatedInstanceType)))).setOptionalTimeout(Landscape.WAIT_FOR_HOST_TIMEOUT)).setLandscape((Landscape)landscape)).setRegion(region)).setPrivateKeyEncryptionPassphrase(privateKeyEncryptionPassphrase);
        if (optionalKeyName != null) {
            masterHostBuilder.setKeyName(optionalKeyName);
        }
        if (newSharedMasterInstance) {
            ((StartSailingAnalyticsMasterHost.Builder)masterHostBuilder.setInstanceName("SL Multi-Server")).setTags(Tags.with((String)"sailing-analytics-server", (String)"___multi___"));
        }
        StartSailingAnalyticsMasterHost masterHostStartProcedure = (StartSailingAnalyticsMasterHost)masterHostBuilder.build();
        masterHostStartProcedure.run();
        SailingAnalyticsProcess<String> master = masterHostStartProcedure.getSailingAnalyticsProcess();
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> result = this.createLoadBalancingAndAutoScalingSetup(landscape, region, name, master, release, dedicatedInstanceType, dynamicLoadBalancerMapping, optionalKeyName, privateKeyEncryptionPassphrase, optionalDomainName, Optional.of(masterHostBuilder.getMachineImage()), bearerTokenUsedByReplicas, minimumAutoScalingGroupSize, maximumAutoScalingGroupSize, optionalIgtimiRiotPort);
        Optional<SailingAnalyticsProcess> unmanagedReplica = minimumAutoScalingGroupSize.map(minASGSize -> {
            ArrayList<SailingAnalyticsProcess<String>> unmanagedReplicas = new ArrayList<SailingAnalyticsProcess<String>>();
            if (minASGSize == 0) {
                logger.info("No auto-scaling replica forced for replica set " + name + "; starting with an unmanaged replica on a shared instance");
                try {
                    unmanagedReplicas.add(this.launchUnmanagedReplica(result, region, optionalKeyName, privateKeyEncryptionPassphrase, bearerTokenUsedByReplicas, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, optionalIgtimiRiotPort, Optional.of(InstanceType.valueOf((String)sharedInstanceType)), Optional.empty()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return unmanagedReplicas.isEmpty() ? null : (SailingAnalyticsProcess)unmanagedReplicas.get(0);
        });
        return unmanagedReplica.map(ur -> {
            try {
                return this.getLandscape().getApplicationReplicaSet((Region)region, name, (AwsApplicationProcess)master, Collections.singleton(ur), Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }).orElse(result);
    }

    @Override
    public AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> deployApplicationToExistingHost(String replicaSetName, SailingAnalyticsHost<String> hostToDeployTo, String replicaInstanceType, boolean dynamicLoadBalancerMapping, String releaseNameOrNullForLatestMaster, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String masterReplicationBearerToken, String replicaReplicationBearerToken, String optionalDomainName, Optional<Integer> optionalMinimumAutoScalingGroupSize, Optional<Integer> optionalMaximumAutoScalingGroupSize, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull, Integer optionalIgtimiRiotPort, Optional<InstanceType> optionalSharedInstanceTypeForNewReplicaHost, Optional<SailingAnalyticsHost<String>> optionalPreferredInstanceToDeployUnmanagedReplicaTo) throws Exception {
        return this.deployApplicationToExistingHostInternal(hostToDeployTo.getRegion(), replicaSetName, hostToDeployTo, replicaInstanceType, dynamicLoadBalancerMapping, releaseNameOrNullForLatestMaster, optionalKeyName, privateKeyEncryptionPassphrase, masterReplicationBearerToken, replicaReplicationBearerToken, optionalDomainName, optionalMinimumAutoScalingGroupSize, optionalMaximumAutoScalingGroupSize, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, optionalIgtimiRiotPort, optionalSharedInstanceTypeForNewReplicaHost, optionalPreferredInstanceToDeployUnmanagedReplicaTo);
    }

    @Override
    public <AppConfigBuilderT extends SailingAnalyticsReplicaConfiguration.Builder<AppConfigBuilderT, String>, MultiServerDeployerBuilderT extends DeployProcessOnMultiServer.Builder<MultiServerDeployerBuilderT, String, SailingAnalyticsHost<String>, SailingAnalyticsReplicaConfiguration<String>, AppConfigBuilderT>> SailingAnalyticsProcess<String> deployReplicaToExistingHost(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, SailingAnalyticsHost<String> hostToDeployTo, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String replicaReplicationBearerToken, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull, Integer optionalIgtimiRiotPort) throws Exception {
        logger.info("Deploying replica for application replica set " + replicaSet.getName() + " to host " + hostToDeployTo);
        return this.spinUpReplicaAndRegisterInPublicTargetGroup(hostToDeployTo.getRegion(), replicaSet, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase, replicaReplicationBearerToken, optionalIgtimiRiotPort, replicaConfigurationBuilder -> {
            if (optionalMemoryInMegabytesOrNull != null) {
                replicaConfigurationBuilder.setMemoryInMegabytes(optionalMemoryInMegabytesOrNull);
            } else if (optionalMemoryTotalSizeFactorOrNull != null) {
                replicaConfigurationBuilder.setMemoryTotalSizeFactor(optionalMemoryTotalSizeFactorOrNull);
            }
            try {
                Integer igtimiRiotPort = ((SailingAnalyticsProcess)replicaSet.getMaster()).getIgtimiRiotPort(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
                if (igtimiRiotPort != null) {
                    replicaConfigurationBuilder.setIgtimiRiotPort(igtimiRiotPort);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            DeployProcessOnMultiServer.Builder replicaDeploymentProcessBuilder = DeployProcessOnMultiServer.builder(replicaConfigurationBuilder, hostToDeployTo);
            if (optionalKeyName != null) {
                replicaDeploymentProcessBuilder.setKeyName(optionalKeyName);
            }
            ((DeployProcessOnMultiServer.Builder)replicaDeploymentProcessBuilder.setOptionalTimeout(Landscape.WAIT_FOR_PROCESS_TIMEOUT)).setPrivateKeyEncryptionPassphrase(privateKeyEncryptionPassphrase);
            try {
                DeployProcessOnMultiServer replicaDeploymentProcess = (DeployProcessOnMultiServer)((Object)((Object)replicaDeploymentProcessBuilder.build()));
                replicaDeploymentProcess.run();
                return replicaDeploymentProcess.getProcess();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <AppConfigBuilderT extends SailingAnalyticsMasterConfiguration.Builder<AppConfigBuilderT, String>, MultiServerDeployerBuilderT extends DeployProcessOnMultiServer.Builder<MultiServerDeployerBuilderT, String, SailingAnalyticsHost<String>, SailingAnalyticsMasterConfiguration<String>, AppConfigBuilderT>> AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> deployApplicationToExistingHostInternal(AwsRegion region, String replicaSetName, SailingAnalyticsHost<String> hostToDeployTo, String replicaInstanceType, boolean dynamicLoadBalancerMapping, String releaseNameOrNullForLatestMaster, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String masterReplicationBearerToken, String replicaReplicationBearerToken, String optionalDomainName, Optional<Integer> optionalMinimumAutoScalingGroupSize, Optional<Integer> optionalMaximumAutoScalingGroupSize, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull, Integer optionalIgtimiRiotPort, Optional<InstanceType> optionalInstanceType, Optional<SailingAnalyticsHost<String>> optionalPreferredInstanceToDeployTo) throws Exception {
        String hostname;
        AwsLandscape<String> landscape = this.getLandscape();
        Iterable existingDNSRulesForHostname = landscape.getResourceRecordSets(hostname = this.getHostname(replicaSetName, optionalDomainName));
        if (existingDNSRulesForHostname != null && !Util.isEmpty((Iterable)existingDNSRulesForHostname)) {
            throw new IllegalArgumentException("DNS record for " + hostname + " already exists");
        }
        Release release = this.getRelease(releaseNameOrNullForLatestMaster);
        AppConfigBuilderT masterConfigurationBuilder = this.createMasterConfigurationBuilder(replicaSetName, masterReplicationBearerToken, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, optionalIgtimiRiotPort, region, release);
        InboundReplicationConfiguration inboundMasterReplicationConfiguration = (InboundReplicationConfiguration)masterConfigurationBuilder.getInboundReplicationConfiguration().get();
        String bearerTokenUsedByReplicas = this.getEffectiveBearerToken(replicaReplicationBearerToken);
        this.establishServerGroupAndTryToMakeCurrentUserItsOwnerAndMember(replicaSetName, bearerTokenUsedByReplicas, inboundMasterReplicationConfiguration.getMasterHostname(), inboundMasterReplicationConfiguration.getMasterHttpPort());
        SailingAnalyticsProcess<String> master = this.deployProcessToSharedInstance(hostToDeployTo, masterConfigurationBuilder, optionalKeyName, privateKeyEncryptionPassphrase);
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet = this.createLoadBalancingAndAutoScalingSetup(landscape, region, replicaSetName, master, release, replicaInstanceType, dynamicLoadBalancerMapping, optionalKeyName, privateKeyEncryptionPassphrase, optionalDomainName, Optional.empty(), bearerTokenUsedByReplicas, optionalMinimumAutoScalingGroupSize, optionalMaximumAutoScalingGroupSize, optionalIgtimiRiotPort);
        Set<Object> replicas = optionalMinimumAutoScalingGroupSize.isPresent() && optionalMinimumAutoScalingGroupSize.get() == 0 ? Collections.singleton(this.launchUnmanagedReplica(replicaSet, region, optionalKeyName, privateKeyEncryptionPassphrase, bearerTokenUsedByReplicas, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, optionalIgtimiRiotPort, optionalInstanceType, optionalPreferredInstanceToDeployTo)) : Collections.emptySet();
        AwsApplicationReplicaSet replicaSetWithReplica = landscape.getApplicationReplicaSet((Region)region, replicaSet.getServerName(), master, replicas, Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        return replicaSetWithReplica;
    }

    private <AppConfigBuilderT extends SailingAnalyticsMasterConfiguration.Builder<AppConfigBuilderT, String>, MultiServerDeployerBuilderT extends DeployProcessOnMultiServer.Builder<MultiServerDeployerBuilderT, String, SailingAnalyticsHost<String>, SailingAnalyticsMasterConfiguration<String>, AppConfigBuilderT>> SailingAnalyticsProcess<String> deployProcessToSharedInstance(SailingAnalyticsHost<String> hostToDeployTo, AppConfigBuilderT applicationConfigurationBuilder, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        DeployProcessOnMultiServer.Builder multiServerAppDeployerBuilder = DeployProcessOnMultiServer.builder(applicationConfigurationBuilder, hostToDeployTo);
        if (optionalKeyName != null) {
            multiServerAppDeployerBuilder.setKeyName(optionalKeyName);
        }
        multiServerAppDeployerBuilder.setPrivateKeyEncryptionPassphrase(privateKeyEncryptionPassphrase).setOptionalTimeout(Landscape.WAIT_FOR_HOST_TIMEOUT);
        DeployProcessOnMultiServer deployer = (DeployProcessOnMultiServer)((Object)multiServerAppDeployerBuilder.build());
        deployer.run();
        SailingAnalyticsProcess<String> master = deployer.getProcess();
        return master;
    }

    private SailingAnalyticsProcess<String> launchUnmanagedReplica(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, AwsRegion region, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String replicaReplicationBearerToken, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull, Integer optionalIgtimiRiotPort, Optional<InstanceType> optionalInstanceType, Optional<SailingAnalyticsHost<String>> optionalPreferredInstanceToDeployTo) throws Exception {
        EligibleInstanceForReplicaSetFindingStrategyImpl strategyForFindingOrLaunchingInstanceForUnmangedReplica = new EligibleInstanceForReplicaSetFindingStrategyImpl(this, region, optionalKeyName, privateKeyEncryptionPassphrase, false, true, optionalInstanceType, optionalPreferredInstanceToDeployTo);
        SailingAnalyticsProcess<String> replica = this.deployReplicaToExistingHost(replicaSet, strategyForFindingOrLaunchingInstanceForUnmangedReplica.getInstanceToDeployTo(replicaSet), optionalKeyName, privateKeyEncryptionPassphrase, replicaReplicationBearerToken, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, optionalIgtimiRiotPort);
        return replica;
    }

    @Override
    public Util.Triple<DataImportProgress, CompareServersResult, String> archiveReplicaSet(String regionId, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> applicationReplicaSetToArchive, String bearerTokenOrNullForApplicationReplicaSetToArchive, String bearerTokenOrNullForArchive, Duration durationToWaitBeforeCompareServers, int maxNumberOfCompareServerAttempts, boolean removeApplicationReplicaSet, MongoEndpoint moveDatabaseHere, String optionalKeyName, byte[] passphraseForPrivateKeyDecryption) throws Exception {
        String mongoDbArchivingErrorMessage;
        CompareServersResult compareServersResult;
        if (removeApplicationReplicaSet && applicationReplicaSetToArchive.isLocalReplicaSet()) {
            throw new IllegalArgumentException("A replica set cannot archive itself if it is going to be removed. Current replica set: " + ServerInfo.getName());
        }
        AwsRegion region = new AwsRegion(regionId, this.getLandscape());
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> archiveReplicaSet = this.getApplicationReplicaSet(region, "ARCHIVE", ((Duration)Landscape.WAIT_FOR_PROCESS_TIMEOUT.get()).asMillis(), optionalKeyName, passphraseForPrivateKeyDecryption);
        if (archiveReplicaSet == null) {
            String msg = "Couldn't find archive replica set tagged as ARCHIVE";
            logger.severe("Couldn't find archive replica set tagged as ARCHIVE");
            throw new IllegalArgumentException("Couldn't find archive replica set tagged as ARCHIVE");
        }
        logger.info("Found ARCHIVE replica set " + archiveReplicaSet + " with master " + archiveReplicaSet.getMaster());
        UUID idForProgressTracking = UUID.randomUUID();
        RedirectDTO defaultRedirect = RedirectDTO.from((String)this.getDefaultRedirectPath(applicationReplicaSetToArchive.getDefaultRedirectRule()));
        String hostnameFromWhichToArchive = applicationReplicaSetToArchive.getHostname();
        String hostnameOfArchive = archiveReplicaSet.getHostname();
        SailingServerFactory sailingServerFactory = (SailingServerFactory)this.sailingServerFactoryTracker.getService();
        if (sailingServerFactory == null) {
            throw new IllegalStateException("Couldn't find SailingServerFactory");
        }
        SailingServer from = sailingServerFactory.getSailingServer(new URL("https", hostnameFromWhichToArchive, "/"), bearerTokenOrNullForApplicationReplicaSetToArchive);
        SailingServer archive = sailingServerFactory.getSailingServer(new URL("https", hostnameOfArchive, "/"), bearerTokenOrNullForArchive);
        SailingServer failoverArchive = sailingServerFactory.getSailingServer(new URL("https", "archive-failover.sapsailing.com", "/"), bearerTokenOrNullForArchive);
        logger.info("Importing master data from " + from + " to " + archive);
        this.sendMailToReplicaSetOwner(archiveReplicaSet, "StartingToArchiveReplicaSetIntoSubject", "StartingToArchiveReplicaSetIntoBody", Optional.of(SecuredSecurityTypes.ServerActions.CAN_IMPORT_MASTERDATA));
        this.sendMailToReplicaSetOwner(applicationReplicaSetToArchive, "StartingToArchiveReplicaSetSubject", "StartingToArchiveReplicaSetBody", Optional.of(SecuredSecurityTypes.ServerActions.CAN_EXPORT_MASTERDATA));
        MasterDataImportResult mdiResult = archive.importMasterData(from, from.getLeaderboardGroupIds(), true, true, true, false, true, Optional.of(idForProgressTracking));
        if (mdiResult == null) {
            logger.severe("Couldn't find any result for the master data import. Aborting.");
            throw new IllegalStateException("Couldn't find any result for the master data import. Aborting archiving of replica set " + from);
        }
        DataImportProgress mdiProgress = this.waitForMDICompletionOrError(archive, idForProgressTracking, "MDI from " + hostnameFromWhichToArchive + " into " + hostnameOfArchive);
        if (mdiProgress != null && !mdiProgress.failed() && mdiProgress.getResult() != null) {
            logger.info("MDI from " + hostnameFromWhichToArchive + " info " + hostnameOfArchive + " succeeded. Waiting " + durationToWaitBeforeCompareServers + " before starting to compare content...");
            if (Util.isEmpty((Iterable)from.getLeaderboardGroupIds())) {
                logger.info("Empty set of leaderboard groups imported. Not making any comparison.");
                compareServersResult = null;
            } else {
                Thread.sleep(durationToWaitBeforeCompareServers.asMillis());
                logger.info("Comparing contents now...");
                compareServersResult = (CompareServersResult)Wait.wait(() -> from.compareServers(Optional.empty(), archive, Optional.of(from.getLeaderboardGroupIds())), csr -> !csr.hasDiffs(), (boolean)true, Optional.of(durationToWaitBeforeCompareServers.times((long)maxNumberOfCompareServerAttempts)), (Duration)durationToWaitBeforeCompareServers, (Level)Level.INFO, (String)("Comparing leaderboard groups with IDs " + Util.joinStrings((String)", ", (Iterable)from.getLeaderboardGroupIds()) + " between importing server " + hostnameOfArchive + " and exporting server " + hostnameFromWhichToArchive));
            }
            if (Util.isEmpty((Iterable)from.getLeaderboardGroupIds()) || compareServersResult != null) {
                if (Util.isEmpty((Iterable)from.getLeaderboardGroupIds()) || !compareServersResult.hasDiffs()) {
                    logger.info("No differences found during comparing server contents. Moving on...");
                    HashSet eventIDs = new HashSet();
                    for (Iterable eids : Util.map((Iterable)mdiResult.getLeaderboardGroupsImported(), lgWithEventIds -> lgWithEventIds.getEventIds())) {
                        Util.addAll((Iterable)eids, eventIDs);
                    }
                    ReverseProxyCluster reverseProxyCluster = this.getLandscape().getCentralReverseProxy((Region)region);
                    logger.info("Adding reverse proxy rules for migrated content pointing to ARCHIVE");
                    defaultRedirect.accept(new ALBToReverseProxyArchiveRedirectMapper(reverseProxyCluster, hostnameFromWhichToArchive, Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption));
                    if (removeApplicationReplicaSet) {
                        logger.info("Removing remote sailing server references to " + from + " from archive server " + archive);
                        try {
                            archive.removeRemoteServerReference(from);
                            failoverArchive.removeRemoteServerReference(from);
                        }
                        catch (Exception e) {
                            logger.log(Level.INFO, "Exception trying to remove remote server reference to " + from + "; probably such a reference didn't exist");
                        }
                        logger.info("Removing the application replica set archived (" + from + ") was requested");
                        mongoDbArchivingErrorMessage = this.removeApplicationReplicaSet(regionId, applicationReplicaSetToArchive, moveDatabaseHere, optionalKeyName, passphraseForPrivateKeyDecryption);
                    } else {
                        mongoDbArchivingErrorMessage = null;
                        logger.info("Removing remote sailing server references to events on " + from + " with IDs " + eventIDs + " from archive server " + archive);
                        archive.removeRemoteServerEventReferences(from, eventIDs);
                    }
                } else {
                    mongoDbArchivingErrorMessage = null;
                    logger.severe("Even after " + maxNumberOfCompareServerAttempts + " attempts and waiting a total of " + durationToWaitBeforeCompareServers.times((long)maxNumberOfCompareServerAttempts) + " there were the following differences between exporting server " + hostnameFromWhichToArchive + " and importing server " + hostnameOfArchive + ":\nDifferences on importing side: " + compareServersResult.getADiffs() + "\nDifferences on exporting side: " + compareServersResult.getBDiffs() + "\nNot proceeding further. You need to resolve the issues manually.");
                }
            } else {
                mongoDbArchivingErrorMessage = null;
                logger.severe("Even after " + maxNumberOfCompareServerAttempts + " attempts and waiting a total of " + durationToWaitBeforeCompareServers.times((long)maxNumberOfCompareServerAttempts) + " the comparison of servers " + hostnameOfArchive + " and " + hostnameFromWhichToArchive + " did not produce a result. Not proceeding. You have to resolve the issue manually.");
            }
        } else {
            logger.severe("The Master Data Import (MDI) from " + hostnameFromWhichToArchive + " into " + hostnameOfArchive + " did not work" + (mdiProgress != null ? mdiProgress.getErrorMessage() : " (no result at all)"));
            compareServersResult = null;
            mongoDbArchivingErrorMessage = null;
        }
        this.sendMailToReplicaSetOwner(archiveReplicaSet, "FinishedToArchiveReplicaSetIntoSubject", "FinishedToArchiveReplicaSetIntoBody", Optional.of(SecuredSecurityTypes.ServerActions.CAN_IMPORT_MASTERDATA));
        this.sendMailToReplicaSetOwner(applicationReplicaSetToArchive, "FinishedToArchiveReplicaSetSubject", "FinishedToArchiveReplicaSetBody", Optional.of(SecuredSecurityTypes.ServerActions.CAN_EXPORT_MASTERDATA));
        return new Util.Triple((Object)mdiProgress, compareServersResult, mongoDbArchivingErrorMessage);
    }

    private void terminateReplicasNotManagedByAutoScalingGroup(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> applicationReplicaSet, String optionalKeyName, byte[] passphraseForPrivateKeyDecryption) throws InterruptedException, ExecutionException {
        AwsAutoScalingGroup autoScalingGroup = applicationReplicaSet.getAutoScalingGroup();
        for (SailingAnalyticsProcess replica : applicationReplicaSet.getReplicas()) {
            if (autoScalingGroup != null && replica.getHost().isManagedByAutoScalingGroup(Collections.singleton(autoScalingGroup))) continue;
            logger.info("Found replica " + replica + " running on an instance not managed by auto-scaling group " + (autoScalingGroup != null ? autoScalingGroup.getName() : "") + ". Stopping...");
            replica.stopAndTerminateIfLast(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption);
        }
    }

    @Override
    public String removeApplicationReplicaSet(String regionId, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> applicationReplicaSet, MongoEndpoint moveDatabaseHere, String optionalKeyName, byte[] passphraseForPrivateKeyDecryption) throws Exception {
        String mongoDBArchivingErrorMessage;
        CompletableFuture autoScalingGroupRemoval;
        if (applicationReplicaSet.isLocalReplicaSet()) {
            throw new IllegalArgumentException("A replica set cannot remove itself. Current replica set: " + ServerInfo.getName());
        }
        AwsRegion region = new AwsRegion(regionId, this.getLandscape());
        AwsAutoScalingGroup autoScalingGroup = applicationReplicaSet.getAutoScalingGroup();
        for (AwsShard shard : applicationReplicaSet.getShards().keySet()) {
            applicationReplicaSet.removeShard(shard, this.getLandscape());
        }
        logger.info("Adding the master " + ((SailingAnalyticsProcess)applicationReplicaSet.getMaster()).getHost().getId() + " to public target group " + applicationReplicaSet.getMasterTargetGroup().getName() + " if it isn't already contained");
        this.getLandscape().addTargetsToTargetGroup(applicationReplicaSet.getPublicTargetGroup(), Collections.singleton(((SailingAnalyticsProcess)applicationReplicaSet.getMaster()).getHost()));
        this.terminateReplicasNotManagedByAutoScalingGroup(applicationReplicaSet, optionalKeyName, passphraseForPrivateKeyDecryption);
        if (autoScalingGroup != null) {
            autoScalingGroupRemoval = this.getLandscape().removeAutoScalingGroupAndLaunchTemplate(autoScalingGroup);
            Wait.wait(() -> this.isAllAutoScalingReplicasShutDown(applicationReplicaSet, autoScalingGroup), (Optional)Landscape.WAIT_FOR_HOST_TIMEOUT, (Duration)Duration.ONE_SECOND.times(10L), (Level)Level.INFO, (String)"Waiting for auto-scaling replicas to shut down");
        } else {
            autoScalingGroupRemoval = new CompletableFuture();
            autoScalingGroupRemoval.complete(null);
        }
        Database fromDatabase = ((SailingAnalyticsProcess)applicationReplicaSet.getMaster()).getDatabaseConfiguration((Region)region, Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption);
        autoScalingGroupRemoval.thenAccept(v -> {
            try {
                this.getLandscape().deleteLoadBalancerListenerRules((Region)region, (Rule[])Util.toArray((Iterable)applicationReplicaSet.getLoadBalancerRules(), (Object[])new Rule[0]));
                ((SailingAnalyticsProcess)applicationReplicaSet.getMaster()).stopAndTerminateIfLast(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        this.getLandscape().deleteTargetGroup(applicationReplicaSet.getMasterTargetGroup());
        this.getLandscape().deleteTargetGroup(applicationReplicaSet.getPublicTargetGroup());
        String loadBalancerDNSName = applicationReplicaSet.getLoadBalancer().getDNSName();
        Iterable currentLoadBalancerRuleSet = applicationReplicaSet.getLoadBalancer().getRules();
        if (applicationReplicaSet.getResourceRecordSet() != null) {
            if (applicationReplicaSet.getResourceRecordSet().resourceRecords().stream().filter(rr -> AwsLandscape.removeTrailingDotFromHostname((String)rr.value()).equals(loadBalancerDNSName)).findAny().isPresent() && (Util.isEmpty((Iterable)currentLoadBalancerRuleSet) || Util.size((Iterable)currentLoadBalancerRuleSet) == 1 && ((Rule)currentLoadBalancerRuleSet.iterator().next()).isDefault().booleanValue())) {
                logger.info("No more rules " + (!Util.isEmpty((Iterable)currentLoadBalancerRuleSet) ? "except default rule " : "") + "left in load balancer " + applicationReplicaSet.getLoadBalancer().getName() + " which was DNS-mapped; deleting.");
                applicationReplicaSet.getLoadBalancer().delete();
            } else {
                logger.info("Keeping load balancer " + loadBalancerDNSName + " because it is not DNS-mapped or still has rules.");
            }
            logger.info("Removing DNS CNAME record " + applicationReplicaSet.getResourceRecordSet());
            this.getLandscape().removeDNSRecord(applicationReplicaSet.getHostedZoneId(), applicationReplicaSet.getHostname(), RRType.CNAME, loadBalancerDNSName);
        } else {
            logger.info("Keeping load balancer " + loadBalancerDNSName + " because it is not DNS-mapped.");
        }
        if (moveDatabaseHere != null) {
            if (moveDatabaseHere.equals((Object)fromDatabase.getEndpoint())) {
                mongoDBArchivingErrorMessage = "Requested to move database " + fromDatabase + " to its own endpoint " + moveDatabaseHere + ". Not executing because this would kill the database.";
                logger.warning(mongoDBArchivingErrorMessage);
            } else {
                Database toDatabase = moveDatabaseHere.getDatabase(fromDatabase.getName());
                logger.info("Archiving the database content of " + fromDatabase.getConnectionURI() + " to " + toDatabase.getConnectionURI());
                CopyAndCompareMongoDatabase<String> copyAndCompareMongoDatabaseProcedure = this.getCopyAndCompareMongoDatabaseProcedure(fromDatabase, toDatabase);
                copyAndCompareMongoDatabaseProcedure.run();
                mongoDBArchivingErrorMessage = copyAndCompareMongoDatabaseProcedure.getMongoDbArchivingErrorMessage();
            }
        } else {
            mongoDBArchivingErrorMessage = null;
            logger.info("No archiving of database content was requested. Leaving " + fromDatabase.getConnectionURI() + " untouched.");
        }
        this.getSecurityService().deleteAllDataForRemovedObject(SecuredSecurityTypes.SERVER.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{applicationReplicaSet.getServerName()})));
        return mongoDBArchivingErrorMessage;
    }

    private boolean isAllAutoScalingReplicasShutDown(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> applicationReplicaSet, AwsAutoScalingGroup autoScalingGroup) throws Exception {
        Iterable replicas = ((SailingAnalyticsProcess)applicationReplicaSet.getMaster()).getReplicas(Landscape.WAIT_FOR_PROCESS_TIMEOUT, new SailingAnalyticsHostSupplier(), this.processFactoryFromHostAndServerDirectory);
        for (SailingAnalyticsProcess replica : replicas) {
            if (!replica.getHost().isManagedByAutoScalingGroup(Collections.singleton(autoScalingGroup)) || !replica.isAlive(Landscape.WAIT_FOR_PROCESS_TIMEOUT)) continue;
            logger.info("Replica " + replica + " is managed by auto-scaling group " + autoScalingGroup.getName() + " and is still alive.");
            return false;
        }
        return true;
    }

    private <BuilderT extends CopyAndCompareMongoDatabase.Builder<BuilderT, String>> CopyAndCompareMongoDatabase<String> getCopyAndCompareMongoDatabaseProcedure(Database fromDatabase, Database toDatabase) throws Exception {
        CopyAndCompareMongoDatabase.Builder builder = (CopyAndCompareMongoDatabase.Builder)((CopyAndCompareMongoDatabase.Builder)((CopyAndCompareMongoDatabase.Builder)((CopyAndCompareMongoDatabase.Builder)((CopyAndCompareMongoDatabase.Builder)CopyAndCompareMongoDatabase.builder().dropTargetFirst(true)).dropSourceAfterSuccessfulCopy(true)).setSourceDatabase(fromDatabase)).setTargetDatabase(toDatabase)).setAdditionalDatabasesToDelete(Collections.singleton(fromDatabase.getWithDifferentName(String.valueOf(fromDatabase.getName()) + "-replica")));
        builder.setLandscape(this.getLandscape());
        return (CopyAndCompareMongoDatabase)builder.build();
    }

    private DataImportProgress waitForMDICompletionOrError(SailingServer archive, UUID idForProgressTracking, String logMessage) throws Exception {
        return (DataImportProgress)Wait.wait(() -> archive.getMasterDataImportProgress(idForProgressTracking), progress -> progress.failed() || progress.getResult() != null, (boolean)false, LandscapeService.MDI_TIMEOUT, (Duration)LandscapeService.TIME_TO_WAIT_BETWEEN_MDI_COMPLETION_CHECKS, (Level)Level.INFO, (String)logMessage);
    }

    private SecurityService getSecurityService() {
        try {
            return (SecurityService)this.securityServiceTracker.getInitializedService(0L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDefaultRedirectPath(Rule defaultRedirectRule) {
        String result = defaultRedirectRule == null ? null : (String)defaultRedirectRule.actions().stream().map(action -> RedirectDTO.toString((String)action.redirectConfig().path(), Optional.ofNullable(action.redirectConfig().query()))).findAny().orElse(null);
        return result;
    }

    @Override
    public AwsLandscape<String> getLandscape() {
        AwsLandscape result;
        AwsSessionCredentialsWithExpiry sessionCredentials = this.getSessionCredentials();
        if (sessionCredentials != null) {
            String keyId = sessionCredentials.getAccessKeyId();
            String secret = sessionCredentials.getSecretAccessKey();
            String sessionToken = sessionCredentials.getSessionToken();
            result = AwsLandscape.obtain((String)keyId, (String)secret, (String)sessionToken, (String)"/gwt/service/sailing");
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public AwsSessionCredentialsWithExpiry getSessionCredentials() {
        AwsSessionCredentialsWithExpiry credentials;
        AwsSessionCredentialsFromUserPreference credentialsPreferences = (AwsSessionCredentialsFromUserPreference)((Object)this.getSecurityService().getPreferenceObject(this.getSecurityService().getCurrentUser().getName(), "___aws.session.token___"));
        AwsSessionCredentialsWithExpiry result = credentialsPreferences != null ? ((credentials = credentialsPreferences.getAwsSessionCredentialsWithExpiry()).getExpiration().before(TimePoint.now()) ? null : credentials) : null;
        return result;
    }

    @Override
    public void createMfaSessionCredentials(String awsAccessKey, String awsSecret, String mfaTokenCode) {
        Credentials credentials = AwsLandscape.obtain((String)awsAccessKey, (String)awsSecret, (String)"/gwt/service/sailing").getMfaSessionCredentials(mfaTokenCode);
        AwsSessionCredentialsWithExpiryImpl result = new AwsSessionCredentialsWithExpiryImpl(credentials.accessKeyId(), credentials.secretAccessKey(), credentials.sessionToken(), TimePoint.of((long)credentials.expiration().toEpochMilli()));
        AwsSessionCredentialsFromUserPreference credentialsPreferences = new AwsSessionCredentialsFromUserPreference(result);
        this.getSecurityService().setPreferenceObject(this.getSecurityService().getCurrentUser().getName(), "___aws.session.token___", (Object)credentialsPreferences);
    }

    @Override
    public void createSessionCredentials(String awsKeyId, String awsKeySecret, String sessionToken) {
        AwsSessionCredentialsWithExpiryImpl result = new AwsSessionCredentialsWithExpiryImpl(awsKeyId, awsKeySecret, sessionToken, TimePoint.now().plus(Duration.ONE_HOUR.times(12L).minus(Duration.ONE_MINUTE.times(5L))));
        AwsSessionCredentialsFromUserPreference credentialsPreferences = new AwsSessionCredentialsFromUserPreference(result);
        this.getSecurityService().setPreferenceObject(this.getSecurityService().getCurrentUser().getName(), "___aws.session.token___", (Object)credentialsPreferences);
    }

    @Override
    public boolean hasValidSessionCredentials() {
        return this.getSessionCredentials() != null;
    }

    @Override
    public void clearSessionCredentials() {
        this.getSecurityService().unsetPreference(this.getSecurityService().getCurrentUser().getName(), "___aws.session.token___");
    }

    @Override
    public String getFullyQualifiedHostname(String unqualifiedHostname, Optional<String> optionalDomainName) {
        String domainName = optionalDomainName.orElse("sapsailing.com");
        String fullyQualifiedHostname = String.valueOf(unqualifiedHostname) + "." + domainName;
        return fullyQualifiedHostname;
    }

    @Override
    public Release getRelease(String releaseNameOrNullForLatestMaster) {
        return releaseNameOrNullForLatestMaster == null ? SailingReleaseRepository.INSTANCE.getLatestMasterRelease() : SailingReleaseRepository.INSTANCE.getRelease(releaseNameOrNullForLatestMaster);
    }

    private void establishServerGroupAndTryToMakeCurrentUserItsOwnerAndMember(String serverName, String bearerTokenUsedByReplicas, String securityServiceHostname, Integer securityServicePort) throws MalformedURLException, ClientProtocolException, IOException, ParseException, IllegalAccessException {
        UUID groupId;
        String serverGroupName = String.valueOf(serverName) + "-server";
        SailingServerFactory sailingServerFactory = (SailingServerFactory)this.sailingServerFactoryTracker.getService();
        SailingServer securityServiceServer = sailingServerFactory.getSailingServer(RemoteServerUtil.getBaseServerUrl((String)securityServiceHostname, (int)(securityServicePort == null ? 443 : securityServicePort)), bearerTokenUsedByReplicas);
        UUID userGroupId = securityServiceServer.getUserGroupIdByName(serverGroupName);
        if (userGroupId != null) {
            groupId = userGroupId;
            TypeRelativeObjectIdentifier serverGroupTypeRelativeObjectId = new TypeRelativeObjectIdentifier(new String[]{userGroupId.toString()});
            Iterable permissions = securityServiceServer.hasPermissions(Arrays.asList(SecuredSecurityTypes.USER_GROUP.getPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.CREATE, serverGroupTypeRelativeObjectId), SecuredSecurityTypes.USER_GROUP.getPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.READ, serverGroupTypeRelativeObjectId), SecuredSecurityTypes.USER_GROUP.getPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, serverGroupTypeRelativeObjectId), SecuredSecurityTypes.USER_GROUP.getPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.DELETE, serverGroupTypeRelativeObjectId), SecuredSecurityTypes.SERVER.getPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.CREATE, serverGroupTypeRelativeObjectId), SecuredSecurityTypes.SERVER.getPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.READ, serverGroupTypeRelativeObjectId), SecuredSecurityTypes.SERVER.getPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, serverGroupTypeRelativeObjectId), SecuredSecurityTypes.SERVER.getPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.DELETE, serverGroupTypeRelativeObjectId)));
            for (Util.Pair permission : permissions) {
                if (((Boolean)permission.getB()).booleanValue()) continue;
                String msg = "Subject " + securityServiceServer.getUsername() + " on server " + securityServiceHostname + " is not allowed " + permission.getA() + ". Not allowing to create application replica set for " + serverName;
                logger.warning(msg);
                throw new AuthorizationException(msg);
            }
            securityServiceServer.addCurrentUserToGroup(userGroupId);
        } else {
            groupId = securityServiceServer.createUserGroupAndAddCurrentUser(serverGroupName);
            try {
                securityServiceServer.addRoleToUser(ServerAdminRole.getInstance().getId(), securityServiceServer.getUsername(), groupId, null, true);
            }
            catch (Exception e) {
                logger.warning("Couldn't grant role " + ServerAdminRole.getInstance().getName() + " to user " + securityServiceServer.getUsername() + ": " + e.getMessage());
            }
            try {
                securityServiceServer.setGroupAndUserOwner(SecuredSecurityTypes.USER_GROUP, new TypeRelativeObjectIdentifier(new String[]{groupId.toString()}), Optional.empty(), Optional.of(groupId), Optional.empty());
            }
            catch (Exception e) {
                logger.warning("Couldn't update user group ownership of user group " + serverGroupName + ": " + e.getMessage());
            }
        }
        this.ensureGroupMembersCanReadGroup(securityServiceServer, groupId);
    }

    private void ensureGroupMembersCanReadGroup(SailingServer securityServiceServer, UUID groupId) throws ClientProtocolException, IOException, ParseException {
        HashMap<UUID, Set> acls = new HashMap<UUID, Set>(securityServiceServer.getAccessControlLists(SecuredSecurityTypes.USER_GROUP, new TypeRelativeObjectIdentifier(new String[]{groupId.toString()})));
        Set actionsForGroup = acls.computeIfAbsent(groupId, gid -> new HashSet());
        if (!actionsForGroup.contains(HasPermissions.DefaultActions.READ.name()) && !actionsForGroup.contains("!" + HasPermissions.DefaultActions.READ.name())) {
            actionsForGroup.add(HasPermissions.DefaultActions.READ.name());
            securityServiceServer.setAccessControlLists(SecuredSecurityTypes.USER_GROUP, new TypeRelativeObjectIdentifier(new String[]{groupId.toString()}), acls);
        }
    }

    private <AppConfigBuilderT extends SailingAnalyticsMasterConfiguration.Builder<AppConfigBuilderT, String>> AppConfigBuilderT createMasterConfigurationBuilder(String replicaSetName, String optionalMasterReplicationBearerTokenOrNull, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull, Integer optionalIgtimiRiotPort, AwsRegion region, Release release) {
        Object masterConfigurationBuilder = SailingAnalyticsMasterConfiguration.masterBuilder();
        String bearerTokenUsedByMaster = this.getEffectiveBearerToken(optionalMasterReplicationBearerTokenOrNull);
        User currentUser = this.getSecurityService().getCurrentUser();
        if (currentUser != null && currentUser.isEmailValidated() && currentUser.getEmail() != null) {
            masterConfigurationBuilder.setCommaSeparatedEmailAddressesToNotifyOfStartup(currentUser.getEmail());
        }
        ((SailingAnalyticsMasterConfiguration.Builder)((SailingAnalyticsMasterConfiguration.Builder)((SailingAnalyticsMasterConfiguration.Builder)((SailingAnalyticsMasterConfiguration.Builder)masterConfigurationBuilder.setLandscape(this.getLandscape())).setServerName(replicaSetName)).setRelease(release)).setRegion(region)).setInboundReplicationConfiguration(InboundReplicationConfiguration.builder().setCredentials((ReplicationCredentials)new BearerTokenReplicationCredentials(bearerTokenUsedByMaster)).build());
        if (optionalIgtimiRiotPort != null) {
            masterConfigurationBuilder.setIgtimiRiotPort(optionalIgtimiRiotPort);
        }
        this.applyMemoryConfigurationToApplicationConfigurationBuilder((AwsApplicationConfiguration.Builder<?, ?, ?, ?, ?>)masterConfigurationBuilder, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull);
        return (AppConfigBuilderT)masterConfigurationBuilder;
    }

    private <AppConfigBuilderT extends SailingAnalyticsReplicaConfiguration.Builder<AppConfigBuilderT, String>> AppConfigBuilderT createReplicaConfigurationBuilder(AwsRegion region, String replicaSetName, int masterPort, Integer optionalIgtimiRiotPort, Release release, String bearerTokenUsedByReplicas, String masterHostname) {
        Object replicaConfigurationBuilder = SailingAnalyticsReplicaConfiguration.replicaBuilder();
        User currentUser = this.getSecurityService().getCurrentUser();
        if (currentUser != null && currentUser.isEmailValidated() && currentUser.getEmail() != null) {
            replicaConfigurationBuilder.setCommaSeparatedEmailAddressesToNotifyOfStartup(currentUser.getEmail());
        }
        ((SailingAnalyticsReplicaConfiguration.Builder)((SailingAnalyticsReplicaConfiguration.Builder)((SailingAnalyticsReplicaConfiguration.Builder)((SailingAnalyticsReplicaConfiguration.Builder)((SailingAnalyticsReplicaConfiguration.Builder)replicaConfigurationBuilder.setLandscape(this.getLandscape())).setRegion(region)).setServerName(replicaSetName)).setRelease(release)).setPort(masterPort)).setInboundReplicationConfiguration(InboundReplicationConfiguration.builder().setMasterHostname(masterHostname).setCredentials((ReplicationCredentials)new BearerTokenReplicationCredentials(bearerTokenUsedByReplicas)).build());
        if (optionalIgtimiRiotPort != null) {
            replicaConfigurationBuilder.setIgtimiRiotPort(optionalIgtimiRiotPort);
        }
        return (AppConfigBuilderT)replicaConfigurationBuilder;
    }

    private void applyMemoryConfigurationToApplicationConfigurationBuilder(AwsApplicationConfiguration.Builder<?, ?, ?, ?, ?> applicationConfigurationBuilder, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull) {
        if (optionalMemoryInMegabytesOrNull != null) {
            applicationConfigurationBuilder.setMemoryInMegabytes(optionalMemoryInMegabytesOrNull.intValue());
        } else if (optionalMemoryTotalSizeFactorOrNull != null) {
            applicationConfigurationBuilder.setMemoryTotalSizeFactor(optionalMemoryTotalSizeFactorOrNull.intValue());
        }
    }

    private AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> createLoadBalancingAndAutoScalingSetup(AwsLandscape<String> landscape, AwsRegion region, String replicaSetName, SailingAnalyticsProcess<String> master, Release release, String replicaInstanceType, boolean dynamicLoadBalancerMapping, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String optionalDomainName, Optional<AmazonMachineImage<String>> replicaMachineImage, String bearerTokenUsedByReplicas, Optional<Integer> minimumNumberOfReplicas, Optional<Integer> maximumNumberOfReplicas, Integer optionalIgtimiRiotPort) throws Exception, JSchException, IOException, InterruptedException, SftpException, TimeoutException {
        logger.info("Creating load balancing and auto-scaling set-up for replica set " + replicaSetName);
        if (dynamicLoadBalancerMapping && !region.getId().equals("eu-west-1")) {
            throw new IllegalArgumentException("You must not request dynamic load balancer mapping in regions other than eu-west-1; you tried it for region " + region.getId());
        }
        CreateDynamicLoadBalancerMapping.Builder createLoadBalancerMappingBuilder = dynamicLoadBalancerMapping ? CreateDynamicLoadBalancerMapping.builder() : CreateDNSBasedLoadBalancerMapping.builder();
        String masterHostname = this.getHostname(replicaSetName, optionalDomainName);
        CreateLoadBalancerMapping createLoadBalancerMapping = (CreateLoadBalancerMapping)((CreateLoadBalancerMapping.Builder)((CreateLoadBalancerMapping.Builder)createLoadBalancerMappingBuilder.setProcess(master).setHostname(masterHostname).setTargetGroupNamePrefix("S-")).setSecurityGroupForVpc(landscape.getDefaultSecurityGroupForApplicationHosts((Region)region)).setLandscape(landscape)).build();
        createLoadBalancerMapping.run();
        Object replicaConfigurationBuilder = this.createReplicaConfigurationBuilder(region, replicaSetName, master.getPort(), optionalIgtimiRiotPort, release, bearerTokenUsedByReplicas, masterHostname);
        master.waitUntilReady(Landscape.WAIT_FOR_HOST_TIMEOUT);
        CreateLaunchTemplateAndAutoScalingGroup.Builder createLaunchTemplateAndAutoScalingGroupBuilder = CreateLaunchTemplateAndAutoScalingGroup.builder(landscape, (Region)region, replicaSetName, createLoadBalancerMapping.getPublicTargetGroup());
        ((CreateLaunchTemplateAndAutoScalingGroup.Builder)createLaunchTemplateAndAutoScalingGroupBuilder.setInstanceType(InstanceType.valueOf((String)replicaInstanceType)).setTags(Tags.with((String)"Name", (String)("SL " + replicaSetName + " (Auto-Replica)")).and("sailing-analytics-server", replicaSetName)).setOptionalTimeout(Landscape.WAIT_FOR_HOST_TIMEOUT)).setReplicaConfiguration((AwsApplicationConfiguration)replicaConfigurationBuilder.build());
        minimumNumberOfReplicas.ifPresent(minNumberOfReplicas -> {
            Object BuilderT = createLaunchTemplateAndAutoScalingGroupBuilder.setMinReplicas((int)minNumberOfReplicas);
        });
        maximumNumberOfReplicas.ifPresent(maxNumberOfReplicas -> {
            Object BuilderT = createLaunchTemplateAndAutoScalingGroupBuilder.setMaxReplicas((int)maxNumberOfReplicas);
        });
        if (replicaMachineImage.isPresent()) {
            createLaunchTemplateAndAutoScalingGroupBuilder.setImage(replicaMachineImage.get());
        } else {
            createLaunchTemplateAndAutoScalingGroupBuilder.setImage((AmazonMachineImage<String>)((StartSailingAnalyticsReplicaHost.Builder)((StartSailingAnalyticsReplicaHost.Builder)StartSailingAnalyticsReplicaHost.replicaHostBuilder(replicaConfigurationBuilder).setLandscape(this.getLandscape())).setRegion(region)).getMachineImage());
        }
        if (optionalKeyName != null) {
            createLaunchTemplateAndAutoScalingGroupBuilder.setKeyName(optionalKeyName);
        }
        ((CreateLaunchTemplateAndAutoScalingGroup)((Object)createLaunchTemplateAndAutoScalingGroupBuilder.build())).run();
        CompletableFuture allLoadBalancersInRegion = landscape.getLoadBalancersAsync((Region)region);
        CompletableFuture allTargetGroupsInRegion = landscape.getTargetGroupsAsync((Region)region);
        CompletableFuture allLoadBalancerRulesInRegion = landscape.getLoadBalancerListenerRulesAsync((Region)region, allLoadBalancersInRegion);
        CompletableFuture autoScalingGroups = landscape.getAutoScalingGroupsAsync((Region)region);
        CompletableFuture launchTemplates = landscape.getLaunchTemplatesAsync((Region)region);
        CompletableFuture launchTemplateDefaultVersions = landscape.getLaunchTemplateDefaultVersionsAsync((Region)region);
        DNSCache dnsCache = landscape.getNewDNSCache();
        AwsApplicationReplicaSetImpl applicationReplicaSet = new AwsApplicationReplicaSetImpl(replicaSetName, masterHostname, master, Optional.empty(), allLoadBalancersInRegion, allTargetGroupsInRegion, allLoadBalancerRulesInRegion, autoScalingGroups, launchTemplates, launchTemplateDefaultVersions, dnsCache, "/gwt/service/sailing", Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        return applicationReplicaSet;
    }

    @Override
    public String getHostname(String replicaSetName, String optionalDomainName) {
        String domainName = Optional.ofNullable(optionalDomainName).orElse("sapsailing.com");
        String masterHostname = String.valueOf(replicaSetName) + "." + domainName;
        return masterHostname;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> upgradeApplicationReplicaSet(AwsRegion region, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, String releaseOrNullForLatestMaster, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String replicaReplicationBearerToken) throws MalformedURLException, IOException, TimeoutException, Exception {
        void var20_27;
        int autoScalingReplicaCount;
        int oldAutoScalingGroupMinSize;
        if (replicaSet.isLocalReplicaSet()) {
            throw new IllegalArgumentException("A replica set cannot upgrade itself. Current replica set: " + ServerInfo.getName());
        }
        if (!replicaSet.getShards().isEmpty() && replicaSet.getAutoScalingGroup() == null) {
            throw new IllegalStateException("A replica set is expected to have an auto scaling group if it has shards");
        }
        Release release = this.getRelease(releaseOrNullForLatestMaster);
        String effectiveReplicaReplicationBearerToken = this.getEffectiveBearerToken(replicaReplicationBearerToken);
        AwsAutoScalingGroup autoScalingGroup = replicaSet.getAutoScalingGroup();
        ArrayList<AwsAutoScalingGroup> affectedAutoScalingGroups = new ArrayList<AwsAutoScalingGroup>();
        replicaSet.getShards().keySet().forEach(t -> {
            boolean bl = affectedAutoScalingGroups.add(t.getAutoScalingGroup());
        });
        if (autoScalingGroup != null) {
            affectedAutoScalingGroups.add(autoScalingGroup);
            oldAutoScalingGroupMinSize = autoScalingGroup.getAutoScalingGroup().minSize();
            int tempAutoScalingReplicaCount = 0;
            for (AwsAutoScalingGroup asg : affectedAutoScalingGroups) {
                tempAutoScalingReplicaCount += asg.getAutoScalingGroup().desiredCapacity().intValue();
            }
            autoScalingReplicaCount = tempAutoScalingReplicaCount;
        } else {
            oldAutoScalingGroupMinSize = -1;
            autoScalingReplicaCount = -1;
        }
        HashSet<SailingAnalyticsProcess<String>> replicasToStopAfterUpgradingMaster = new HashSet<SailingAnalyticsProcess<String>>();
        Util.addAll((Iterable)replicaSet.getReplicas(), replicasToStopAfterUpgradingMaster);
        SailingAnalyticsProcess<String> additionalReplicaStarted = this.ensureAtLeastOneReplicaExistsStopReplicatingAndRemoveMasterFromTargetGroups(replicaSet, optionalKeyName, privateKeyEncryptionPassphrase, effectiveReplicaReplicationBearerToken);
        if (replicaSet.getAutoScalingGroup() != null) {
            this.getLandscape().updateReleaseInAutoScalingGroups((Region)region, replicaSet.getAutoScalingGroup().getLaunchTemplate(), affectedAutoScalingGroups, replicaSet.getName(), release);
        }
        SailingAnalyticsProcess master = (SailingAnalyticsProcess)replicaSet.getMaster();
        master.refreshToRelease(release, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        logger.info("Waiting for master " + master + " to get ready with new release " + release.getName());
        master.waitUntilReady(Optional.of(Duration.ONE_DAY));
        logger.info("Launching upgrade replicas based on current set of replicas for replica set " + replicaSet.getName());
        Iterable<SailingAnalyticsProcess<String>> temporaryUpgradeReplicas = this.launchUpgradeReplicasAndWaitUntilReady(replicaSet, release, effectiveReplicaReplicationBearerToken, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        List temporaryUpgradeReplicasMutable = Util.asList(temporaryUpgradeReplicas);
        logger.info("Adding master " + master + " and dedicated upgraded temporary replicas to target groups " + replicaSet.getPublicTargetGroup() + " and " + replicaSet.getMasterTargetGroup());
        replicaSet.getPublicTargetGroup().addTarget(master.getHost());
        replicaSet.getMasterTargetGroup().addTarget(master.getHost());
        replicaSet.getOtherTargetGroups().forEach(tg -> tg.addTarget(master.getHost()));
        this.sendMailAboutMasterAvailable(replicaSet);
        HashMap<TargetGroup, Iterable> tempUpgradeReplicasByTargetGroup = new HashMap<TargetGroup, Iterable>();
        for (AwsShard shard : replicaSet.getShards().keySet()) {
            TargetGroup targetGroup = shard.getTargetGroup();
            ArrayList hosts = new ArrayList();
            int numberOfTargets = targetGroup.getRegisteredTargets().size();
            int i = 0;
            while (i < numberOfTargets) {
                SailingAnalyticsProcess tempUpgradeReplicaProcess = (SailingAnalyticsProcess)temporaryUpgradeReplicasMutable.remove(0);
                targetGroup.addTarget(tempUpgradeReplicaProcess.getHost());
                hosts.add(tempUpgradeReplicaProcess.getHost());
                ++i;
            }
            tempUpgradeReplicasByTargetGroup.put(targetGroup, hosts);
        }
        replicaSet.getPublicTargetGroup().addTargets(Util.map((Iterable)temporaryUpgradeReplicasMutable, temporaryUpgradeReplica -> temporaryUpgradeReplica.getHost()));
        replicaSet.getOtherTargetGroups().forEach(tg -> tg.addTargets(Util.map((Iterable)temporaryUpgradeReplicasMutable, temporaryUpgradeReplica -> temporaryUpgradeReplica.getHost())));
        tempUpgradeReplicasByTargetGroup.put(replicaSet.getPublicTargetGroup(), Util.map((Iterable)temporaryUpgradeReplicasMutable, temporaryUpgradeReplica -> temporaryUpgradeReplica.getHost()));
        replicaSet.getOtherTargetGroups().forEach(tg -> {
            Iterable iterable = tempUpgradeReplicasByTargetGroup.put((TargetGroup)tg, Util.map((Iterable)temporaryUpgradeReplicasMutable, temporaryUpgradeReplica -> temporaryUpgradeReplica.getHost()));
        });
        if (additionalReplicaStarted != null) {
            replicasToStopAfterUpgradingMaster.add(additionalReplicaStarted);
            if (replicaSet.getAutoScalingGroup() != null) {
                for (AwsAutoScalingGroup asg : affectedAutoScalingGroups) {
                    ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().execute(ThreadPoolUtil.INSTANCE.associateWithSubjectIfAny(() -> this.getLandscape().updateAutoScalingGroupMinSize(asg, oldAutoScalingGroupMinSize)));
                }
            }
        }
        HashSet<SailingAnalyticsProcess> newUpgradedUnmanagedReplicas = new HashSet<SailingAnalyticsProcess>();
        logger.info("Removing old replicas from public target group " + replicaSet.getPublicTargetGroup());
        replicaSet.getPublicTargetGroup().removeTargets(Util.map(replicasToStopAfterUpgradingMaster, replica -> replica.getHost()));
        replicaSet.getOtherTargetGroups().forEach(tg -> tg.removeTargets(Util.map((Iterable)replicasToStopAfterUpgradingMaster, replica -> replica.getHost())));
        for (SailingAnalyticsProcess sailingAnalyticsProcess : replicasToStopAfterUpgradingMaster) {
            boolean managedByAutoScalingGroup = sailingAnalyticsProcess.getHost().isManagedByAutoScalingGroup(affectedAutoScalingGroups);
            if (managedByAutoScalingGroup || additionalReplicaStarted != null && sailingAnalyticsProcess.getHost().getInstanceId().equals(additionalReplicaStarted.getHost().getInstanceId())) {
                logger.info("Stopping (and terminating if last application process on host) replicas on old release: " + replicasToStopAfterUpgradingMaster);
                sailingAnalyticsProcess.stopAndTerminateIfLast(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
                continue;
            }
            logger.info("Refreshing unmanaged replica " + sailingAnalyticsProcess + " in place");
            sailingAnalyticsProcess.refreshToRelease(release, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
            sailingAnalyticsProcess.waitUntilReady(Optional.of(Duration.ONE_DAY));
            replicaSet.getPublicTargetGroup().addTarget(sailingAnalyticsProcess.getHost());
            replicaSet.getOtherTargetGroups().forEach(tg -> tg.addTarget(replica2.getHost()));
            newUpgradedUnmanagedReplicas.add(sailingAnalyticsProcess);
        }
        if (autoScalingGroup != null && autoScalingReplicaCount > 0) {
            logger.info("Now waiting until " + autoScalingReplicaCount + " auto-scaling replicas are ready before taking down dedicated temporary upgrade replicas");
            Iterable iterable = (Iterable)Wait.wait(() -> master.getReplicas(Landscape.WAIT_FOR_PROCESS_TIMEOUT, new SailingAnalyticsHostSupplier(), new SailingAnalyticsProcessFactory(this::getLandscape)), replicas -> {
                int size = Util.size((Iterable)Util.filter((Iterable)replicas, replica -> replica.getHost().isManagedByAutoScalingGroup(affectedAutoScalingGroups)));
                logger.info("Until now there are " + size + " auto-scaling replicas healthy");
                return size >= autoScalingReplicaCount;
            }, (boolean)true, Optional.of(Duration.ONE_DAY), (Duration)Duration.ONE_SECOND.times(30L), (Level)Level.INFO, (String)("Waiting for " + autoScalingReplicaCount + " auto-scaling replicas to become ready"));
        } else {
            logger.info("No auto-scaling group or auto-scaling group did not have managed instances; using only the upgraded unmanaged replicas " + newUpgradedUnmanagedReplicas);
            HashSet<SailingAnalyticsProcess> hashSet = newUpgradedUnmanagedReplicas;
        }
        logger.info("Removing targets for all temporary upgrade replicas " + temporaryUpgradeReplicas);
        for (Map.Entry entry : tempUpgradeReplicasByTargetGroup.entrySet()) {
            ((TargetGroup)entry.getKey()).removeTargets((Iterable)entry.getValue());
        }
        logger.info("Stopping/terminating all temporary upgrade replicas " + temporaryUpgradeReplicas);
        for (SailingAnalyticsProcess sailingAnalyticsProcess : temporaryUpgradeReplicas) {
            sailingAnalyticsProcess.stopAndTerminateIfLast(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        }
        return this.getLandscape().getApplicationReplicaSet((Region)region, replicaSet.getServerName(), (AwsApplicationProcess)master, Util.filter((Iterable)var20_27, newUpgradedReplica -> !Util.contains((Iterable)temporaryUpgradeReplicas, (Object)newUpgradedReplica)), Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
    }

    private <AppConfigBuilderT extends SailingAnalyticsReplicaConfiguration.Builder<AppConfigBuilderT, String>> Iterable<SailingAnalyticsProcess<String>> launchUpgradeReplicasAndWaitUntilReady(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, Release release, String replicationBearerToken, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        HashSet<SailingAnalyticsProcess<String>> result = new HashSet<SailingAnalyticsProcess<String>>();
        SailingAnalyticsProcess master = (SailingAnalyticsProcess)replicaSet.getMaster();
        Integer optionalIgtimiRiotPort = master.getIgtimiRiotPort(Landscape.WAIT_FOR_PROCESS_TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase);
        AwsRegion region = master.getHost().getRegion();
        for (SailingAnalyticsProcess sailingAnalyticsProcess : replicaSet.getReplicas()) {
            InstanceType instanceType = sailingAnalyticsProcess.getHost().getInstance().instanceType();
            String memoryVariable = sailingAnalyticsProcess.getEnvShValueFor((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.MEMORY, Landscape.WAIT_FOR_PROCESS_TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase);
            Optional megabytesFromJvmSize = JvmUtils.getMegabytesFromJvmSize((String)memoryVariable);
            logger.info("Determined replica set " + replicaSet.getName() + "'s replica memory size for replica " + sailingAnalyticsProcess + " as " + memoryVariable + " which equals " + megabytesFromJvmSize + "MB. Using for upgrade replica configuration with instance type " + instanceType + ".");
            AppConfigBuilderT replicaConfigurationBuilder = this.createReplicaConfigurationBuilder(region, replicaSet.getServerName(), master.getPort(), optionalIgtimiRiotPort, release, replicationBearerToken, replicaSet.getHostname());
            replicaConfigurationBuilder.setInboundReplicationConfiguration(InboundReplicationConfiguration.builder().setMasterHostname(master.getHost().getHostname()).setMasterHttpPort(master.getPort()).setCredentials((ReplicationCredentials)new BearerTokenReplicationCredentials(replicationBearerToken)).build());
            megabytesFromJvmSize.ifPresent(memoryInMegabytes -> {
                AwsApplicationConfiguration.Builder builder2 = replicaConfigurationBuilder.setMemoryInMegabytes(memoryInMegabytes);
            });
            Object replicaHostBuilder = StartSailingAnalyticsReplicaHost.replicaHostBuilder(replicaConfigurationBuilder);
            ((StartSailingAnalyticsReplicaHost.Builder)((StartSailingAnalyticsReplicaHost.Builder)((StartSailingAnalyticsReplicaHost.Builder)((StartSailingAnalyticsReplicaHost.Builder)((StartSailingAnalyticsReplicaHost.Builder)replicaHostBuilder.setInstanceName("SL " + replicaSet.getName() + TEMPORARY_UPGRADE_REPLICA_NAME_SUFFIX)).setInstanceType(instanceType)).setOptionalTimeout(Landscape.WAIT_FOR_HOST_TIMEOUT)).setLandscape((Landscape)this.getLandscape())).setRegion(region)).setTags(Tags.with((String)UPGRADE_REPLICA_TAG_KEY, (String)replicaSet.getName()));
            optionalKeyName.ifPresent(arg_0 -> replicaHostBuilder.setKeyName(arg_0));
            StartSailingAnalyticsReplicaHost replicaHostStartProcedure = (StartSailingAnalyticsReplicaHost)replicaHostBuilder.build();
            logger.info("Launching dedicated replica host of type " + instanceType + " for replica " + sailingAnalyticsProcess);
            replicaHostStartProcedure.run();
            Wait.wait(() -> replicaHostStartProcedure.getSailingAnalyticsProcess().getHost().getInstance(), instance -> instance != null, (boolean)true, (Optional)Landscape.WAIT_FOR_HOST_TIMEOUT, (Duration)Duration.ONE_SECOND.times(10L), (Level)Level.WARNING, (String)("Waiting for replica instance with ID " + ((SailingAnalyticsHost)replicaHostStartProcedure.getHost()).getInstanceId()));
            result.add(replicaHostStartProcedure.getSailingAnalyticsProcess());
        }
        for (SailingAnalyticsProcess sailingAnalyticsProcess : result) {
            logger.info("Waiting for replica " + sailingAnalyticsProcess + " to become ready");
            sailingAnalyticsProcess.waitUntilReady(Optional.of(Duration.ONE_DAY));
        }
        return result;
    }

    @Override
    public Iterable<SailingAnalyticsHost<String>> getEligibleSharedHostsForReplicaSet(AwsRegion region, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) {
        return Util.filter((Iterable)this.getLandscape().getRunningHostsWithTagValue((Region)region, "sailing-analytics-server", "___multi___", new SailingAnalyticsHostSupplier()), h -> {
            try {
                return this.isEligibleForDeployment((SailingAnalyticsHost)h, replicaSet.getServerName(), replicaSet.getPort(), ((SailingAnalyticsProcess)replicaSet.getMaster()).getIgtimiRiotPort(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase), Landscape.WAIT_FOR_PROCESS_TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> getApplicationReplicaSet(AwsRegion region, String replicaSetName, Long optionalTimeoutInMilliseconds, String optionalKeyName, byte[] passphraseForPrivateKeyDecryption) throws Exception {
        return (AwsApplicationReplicaSet)Util.first((Iterable)Util.filter((Iterable)this.getLandscape().getApplicationReplicaSetsByTag((Region)region, "sailing-analytics-server", new SailingAnalyticsHostSupplier(), Optional.ofNullable(optionalTimeoutInMilliseconds).map(Duration::ofMillis), Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption), rs -> rs.getName().equals(replicaSetName)));
    }

    @Override
    public SailingAnalyticsProcess<String> ensureAtLeastOneReplicaExistsStopReplicatingAndRemoveMasterFromTargetGroups(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String effectiveReplicaReplicationBearerToken) throws Exception, MalformedURLException, IOException, TimeoutException, InterruptedException, ExecutionException {
        SailingAnalyticsProcess<String> additionalReplicaStarted;
        HashSet<SailingAnalyticsProcess<String>> replicasToStopReplicating = new HashSet<SailingAnalyticsProcess<String>>();
        Util.addAll((Iterable)replicaSet.getReplicas(), replicasToStopReplicating);
        if (Util.isEmpty((Iterable)Util.filter(new HashSet(replicasToStopReplicating), replica -> !replica.getHost().isManagedByAutoScalingGroup(replicaSet.getShards().keySet().stream().map(shard -> shard.getAutoScalingGroup())::iterator)))) {
            logger.info("No replica that doesn't belong to any shard was found for replica set " + replicaSet.getName() + "; spinning one up and waiting for it to become healthy");
            additionalReplicaStarted = this.launchReplicaAndWaitUntilHealthy(replicaSet, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase, effectiveReplicaReplicationBearerToken);
            replicasToStopReplicating.add(additionalReplicaStarted);
        } else {
            additionalReplicaStarted = null;
        }
        logger.info("Stopping replication for replica set " + replicaSet.getName());
        for (SailingAnalyticsProcess sailingAnalyticsProcess : replicasToStopReplicating) {
            logger.info("...asking replica " + sailingAnalyticsProcess + " to stop replication");
            try {
                sailingAnalyticsProcess.stopReplicatingFromMaster(effectiveReplicaReplicationBearerToken, Landscape.WAIT_FOR_PROCESS_TIMEOUT);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Telling replica " + sailingAnalyticsProcess + " to stop replicating from master didn't work; assuming it's dead; continuing...", e);
            }
        }
        logger.info("Done stopping replication. Removing master " + replicaSet.getMaster() + " from target groups " + replicaSet.getPublicTargetGroup() + " and " + replicaSet.getMasterTargetGroup());
        replicaSet.getPublicTargetGroup().removeTarget(((SailingAnalyticsProcess)replicaSet.getMaster()).getHost());
        replicaSet.getMasterTargetGroup().removeTarget(((SailingAnalyticsProcess)replicaSet.getMaster()).getHost());
        replicaSet.getOtherTargetGroups().forEach(tg -> tg.removeTarget(((SailingAnalyticsProcess)replicaSet.getMaster()).getHost()));
        this.sendMailAboutMasterUnavailable(replicaSet);
        return additionalReplicaStarted;
    }

    private SailingAnalyticsProcess<String> launchReplicaAndWaitUntilHealthy(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase, String replicationBearerToken) throws Exception {
        SailingAnalyticsProcess<String> spunUpReplica;
        if (replicaSet.getAutoScalingGroup() != null) {
            spunUpReplica = this.spinUpReplicaByIncreasingAutoScalingGroupMinSize(replicaSet.getAutoScalingGroup(), (SailingAnalyticsProcess)replicaSet.getMaster());
        } else {
            Integer optionalIgtimiRiotPort = ((SailingAnalyticsProcess)replicaSet.getMaster()).getIgtimiRiotPort(Landscape.WAIT_FOR_PROCESS_TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase);
            spunUpReplica = this.spinUpReplicaAndRegisterInPublicTargetGroup(replicaSet, optionalKeyName, privateKeyEncryptionPassphrase, replicationBearerToken, optionalIgtimiRiotPort);
        }
        replicaSet.getOtherTargetGroups().forEach(tg -> tg.addTarget(spunUpReplica.getHost()));
        return spunUpReplica;
    }

    private SailingAnalyticsProcess<String> spinUpReplicaAndRegisterInPublicTargetGroup(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase, String replicationBearerToken, Integer optionalIgtimiRiotPort) throws Exception {
        AwsRegion region = ((SailingAnalyticsProcess)replicaSet.getMaster()).getHost().getRegion();
        return this.spinUpReplicaAndRegisterInPublicTargetGroup(region, replicaSet, optionalKeyName, privateKeyEncryptionPassphrase, replicationBearerToken, optionalIgtimiRiotPort, replicaConfigurationBuilder -> {
            InstanceType masterInstanceType = ((SailingAnalyticsProcess)replicaSet.getMaster()).getHost().getInstance().instanceType();
            Object replicaHostBuilder = StartSailingAnalyticsReplicaHost.replicaHostBuilder(replicaConfigurationBuilder);
            ((StartSailingAnalyticsReplicaHost.Builder)((StartSailingAnalyticsReplicaHost.Builder)((StartSailingAnalyticsReplicaHost.Builder)((StartSailingAnalyticsReplicaHost.Builder)replicaHostBuilder.setInstanceType(masterInstanceType)).setOptionalTimeout(Landscape.WAIT_FOR_HOST_TIMEOUT)).setLandscape((Landscape)this.getLandscape())).setRegion(region)).setPrivateKeyEncryptionPassphrase(privateKeyEncryptionPassphrase);
            optionalKeyName.ifPresent(keyName -> {
                StartAwsHost.Builder builder2 = replicaHostBuilder.setKeyName(keyName);
            });
            try {
                StartSailingAnalyticsReplicaHost replicaHostStartProcedure = (StartSailingAnalyticsReplicaHost)replicaHostBuilder.build();
                replicaHostStartProcedure.run();
                return replicaHostStartProcedure.getSailingAnalyticsProcess();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <AppConfigBuilderT extends SailingAnalyticsReplicaConfiguration.Builder<AppConfigBuilderT, String>> SailingAnalyticsProcess<String> spinUpReplicaAndRegisterInPublicTargetGroup(AwsRegion region, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase, String replicationBearerToken, Integer optionalIgtimiRiotPort, Function<AppConfigBuilderT, SailingAnalyticsProcess<String>> processLauncher) throws Exception {
        Release release = replicaSet.getVersion(Landscape.WAIT_FOR_PROCESS_TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase);
        AppConfigBuilderT replicaConfigurationBuilder = this.createReplicaConfigurationBuilder(region, replicaSet.getServerName(), ((SailingAnalyticsProcess)replicaSet.getMaster()).getPort(), optionalIgtimiRiotPort, release, replicationBearerToken, replicaSet.getHostname());
        SailingAnalyticsProcess<String> sailingAnalyticsProcess = processLauncher.apply(replicaConfigurationBuilder);
        this.waitUntilHealthyAndThenRegisterReplicaInPublicTargetGroup(sailingAnalyticsProcess, replicaSet);
        return sailingAnalyticsProcess;
    }

    private void waitUntilHealthyAndThenRegisterReplicaInPublicTargetGroup(SailingAnalyticsProcess<String> sailingAnalyticsProcess, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet) throws TimeoutException, Exception {
        sailingAnalyticsProcess.waitUntilReady(Landscape.WAIT_FOR_HOST_TIMEOUT);
        if (replicaSet.getPublicTargetGroup() != null) {
            replicaSet.getPublicTargetGroup().addTarget(sailingAnalyticsProcess.getHost());
        }
        replicaSet.getOtherTargetGroups().forEach(tg -> tg.addTarget(sailingAnalyticsProcess.getHost()));
    }

    private SailingAnalyticsProcess<String> spinUpReplicaByIncreasingAutoScalingGroupMinSize(AwsAutoScalingGroup autoScalingGroup, SailingAnalyticsProcess<String> master) throws TimeoutException, Exception {
        if (autoScalingGroup.getAutoScalingGroup().minSize() < 1) {
            this.getLandscape().updateAutoScalingGroupMinSize(autoScalingGroup, 1);
        }
        return (SailingAnalyticsProcess)Wait.wait(() -> this.hasHealthyAutoScalingReplica(master, autoScalingGroup), healthyReplica -> healthyReplica != null, (boolean)true, (Optional)Landscape.WAIT_FOR_HOST_TIMEOUT, (Duration)Duration.ONE_SECOND.times(5L), (Level)Level.INFO, (String)("Waiting for auto-scaling group " + autoScalingGroup.getName() + " to produce healthy replica"));
    }

    private SailingAnalyticsProcess<String> hasHealthyAutoScalingReplica(SailingAnalyticsProcess<String> master, AwsAutoScalingGroup autoScalingGroup) throws Exception {
        SailingAnalyticsHostSupplier hostSupplier = new SailingAnalyticsHostSupplier();
        for (SailingAnalyticsProcess replica : master.getReplicas(Landscape.WAIT_FOR_HOST_TIMEOUT, hostSupplier, this.processFactoryFromHostAndServerDirectory)) {
            if (!replica.getHost().isManagedByAutoScalingGroup(Collections.singleton(autoScalingGroup)) || !replica.isReady(Landscape.WAIT_FOR_HOST_TIMEOUT)) continue;
            return replica;
        }
        return null;
    }

    @Override
    public <BuilderT extends StartMultiServer.Builder<BuilderT, String>> SailingAnalyticsHost<String> createEmptyMultiServer(AwsRegion region, Optional<InstanceType> instanceType, Optional<AwsAvailabilityZone> availabilityZone, Optional<String> name, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        StartMultiServer.Builder startMultiServerProcedureBuilder = StartMultiServer.builder();
        ((StartMultiServer.Builder)startMultiServerProcedureBuilder.setLandscape((Landscape)this.getLandscape())).setRegion(region);
        instanceType.ifPresent(it -> {
            StartAwsHost.Builder builder2 = startMultiServerProcedureBuilder.setInstanceType((InstanceType)it);
        });
        availabilityZone.ifPresent(az -> {
            StartAwsHost.Builder builder2 = startMultiServerProcedureBuilder.setAvailabilityZone((AwsAvailabilityZone)az);
        });
        optionalKeyName.ifPresent(keyName -> {
            StartAwsHost.Builder builder2 = startMultiServerProcedureBuilder.setKeyName((String)keyName);
        });
        if (privateKeyEncryptionPassphrase != null) {
            startMultiServerProcedureBuilder.setPrivateKeyEncryptionPassphrase(privateKeyEncryptionPassphrase);
        }
        name.ifPresent(nameTag -> {
            StartAwsHost.Builder builder2 = startMultiServerProcedureBuilder.setInstanceName((String)nameTag);
        });
        StartMultiServer startMultiServerProcedure = (StartMultiServer)startMultiServerProcedureBuilder.build();
        startMultiServerProcedure.run();
        return (SailingAnalyticsHost)Wait.wait(() -> (SailingAnalyticsHost)startMultiServerProcedure.getHost(), multiServer -> {
            try {
                return multiServer.isReady(optionalKeyName, privateKeyEncryptionPassphrase);
            }
            catch (Exception e) {
                return false;
            }
        }, (boolean)true, (Optional)Landscape.WAIT_FOR_HOST_TIMEOUT, (Duration)Duration.ONE_SECOND.times(10L), (Level)Level.INFO, (String)("Waiting until host " + ((SailingAnalyticsHost)startMultiServerProcedure.getHost()).getId() + " is ready"));
    }

    @Override
    public Iterable<AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>> updateImageForReplicaSets(AwsRegion region, Iterable<AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>> replicaSets, Optional<AmazonMachineImage<String>> optionalAmi, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws InterruptedException, ExecutionException, TimeoutException {
        HashSet<AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>> result = new HashSet<AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>>();
        for (AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet : replicaSets) {
            if (replicaSet.getAutoScalingGroup() != null) {
                AmazonMachineImage ami = optionalAmi.orElseGet(() -> this.getLandscape().getLatestImageWithType((Region)region, "sailing-analytics-server"));
                logger.info("Upgrading AMI in auto-scaling groups " + Util.join((String)", ", (Iterable)replicaSet.getAllAutoScalingGroups()) + " of replica set " + replicaSet.getName() + " to " + ami.getId());
                this.getLandscape().updateImageInAutoScalingGroups((Region)region, replicaSet.getAllAutoScalingGroups(), replicaSet.getName(), ami);
                result.add((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)this.getLandscape().getApplicationReplicaSet((Region)region, replicaSet.getServerName(), (AwsApplicationProcess)((SailingAnalyticsProcess)replicaSet.getMaster()), replicaSet.getReplicas(), optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase));
                continue;
            }
            logger.info("No auto-scaling group found for replica set " + replicaSet.getName() + " to update AMI in");
        }
        return result;
    }

    @Override
    public <AppConfigBuilderT extends SailingAnalyticsReplicaConfiguration.Builder<AppConfigBuilderT, String>, MultiServerDeployerBuilderT extends DeployProcessOnMultiServer.Builder<MultiServerDeployerBuilderT, String, SailingAnalyticsHost<String>, SailingAnalyticsReplicaConfiguration<String>, AppConfigBuilderT>> AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> useDedicatedAutoScalingReplicasInsteadOfShared(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        AwsApplicationReplicaSet result;
        if (replicaSet.getAutoScalingGroup() != null) {
            Integer minSize = replicaSet.getAutoScalingGroup().getAutoScalingGroup().minSize();
            if (minSize != null && minSize > 0) {
                logger.info("Replica set " + replicaSet + " already has its auto-scaling group minimum size set to a non-zero value: " + minSize);
                result = replicaSet;
            } else {
                SailingAnalyticsProcess<String> replica = this.spinUpReplicaByIncreasingAutoScalingGroupMinSize(replicaSet.getAutoScalingGroup(), (SailingAnalyticsProcess)replicaSet.getMaster());
                replicaSet.getOtherTargetGroups().forEach(tg -> tg.addTarget(replica.getHost()));
                assert (replica.isReady(Landscape.WAIT_FOR_PROCESS_TIMEOUT));
                for (SailingAnalyticsProcess nonAutoScalingReplica : replicaSet.getReplicas()) {
                    if (nonAutoScalingReplica.getHost().isManagedByAutoScalingGroup()) continue;
                    logger.info("Found replica " + nonAutoScalingReplica + " to be not managed by auto-scaling group " + replicaSet.getAutoScalingGroup().getName() + ". Removing it from Target Group and stopping it...");
                    replicaSet.getPublicTargetGroup().removeTarget(nonAutoScalingReplica.getHost());
                    nonAutoScalingReplica.stopAndTerminateIfLast(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
                }
                result = this.getLandscape().getApplicationReplicaSet((Region)((SailingAnalyticsProcess)replicaSet.getMaster()).getHost().getRegion(), replicaSet.getServerName(), (AwsApplicationProcess)((SailingAnalyticsProcess)replicaSet.getMaster()), Collections.singleton(replica), Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
            }
        } else {
            logger.warning("No auto-scaling group found for replica set " + replicaSet + "; not terminating any replicas.");
            result = null;
        }
        return result;
    }

    @Override
    public <AppConfigBuilderT extends SailingAnalyticsReplicaConfiguration.Builder<AppConfigBuilderT, String>, MultiServerDeployerBuilderT extends DeployProcessOnMultiServer.Builder<MultiServerDeployerBuilderT, String, SailingAnalyticsHost<String>, SailingAnalyticsReplicaConfiguration<String>, AppConfigBuilderT>> AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> useSingleSharedInsteadOfDedicatedAutoScalingReplica(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String replicaReplicationBearerToken, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull, Optional<InstanceType> optionalInstanceType) throws Exception {
        AwsAutoScalingGroup autoScalingGroup = replicaSet.getAutoScalingGroup();
        HashSet<SailingAnalyticsProcess<String>> nonAutoScalingReplica = new HashSet<SailingAnalyticsProcess<String>>();
        for (SailingAnalyticsProcess replica : replicaSet.getReplicas()) {
            if (autoScalingGroup != null && replica.getHost().isManagedByAutoScalingGroup(Collections.singleton(autoScalingGroup))) continue;
            logger.info("Found replica " + replica + " in replica set " + replicaSet.getName() + " which is not managed by auto-scaling group");
            nonAutoScalingReplica.add(replica);
        }
        if (nonAutoScalingReplica.isEmpty()) {
            logger.info("No replica found for replica set " + replicaSet.getName() + " that is not managed by auto-scaling group " + (autoScalingGroup == null ? "null" : autoScalingGroup.getName()) + ". Launching one on an eligible shared instance.");
            Integer optionalIgtimiRiotPort = ((SailingAnalyticsProcess)replicaSet.getMaster()).getIgtimiRiotPort(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
            nonAutoScalingReplica.add(this.launchUnmanagedReplica(replicaSet, ((SailingAnalyticsProcess)replicaSet.getMaster()).getHost().getRegion(), optionalKeyName, privateKeyEncryptionPassphrase, this.getEffectiveBearerToken(replicaReplicationBearerToken), optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, optionalIgtimiRiotPort, Optional.of(optionalInstanceType.orElseGet(() -> ((SailingAnalyticsProcess)replicaSet.getMaster()).getHost().getInstance().instanceType())), Optional.empty()));
        }
        if (autoScalingGroup != null) {
            logger.info("Scaling down auto-scaling group for replica set " + replicaSet.getName() + " from minimum size " + replicaSet.getAutoScalingGroup().getAutoScalingGroup().minSize() + " to 0");
            this.getLandscape().updateAutoScalingGroupMinSize(replicaSet.getAutoScalingGroup(), 0);
        } else {
            logger.info("No auto-scaling group found for replica set " + replicaSet.getName() + "; nothing to scale down.");
        }
        return this.getLandscape().getApplicationReplicaSet((Region)((SailingAnalyticsProcess)replicaSet.getMaster()).getHost().getRegion(), replicaSet.getServerName(), (AwsApplicationProcess)((SailingAnalyticsProcess)replicaSet.getMaster()), nonAutoScalingReplica, Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
    }

    @Override
    public <AppConfigBuilderT extends SailingAnalyticsMasterConfiguration.Builder<AppConfigBuilderT, String>, MultiServerDeployerBuilderT extends DeployProcessOnMultiServer.Builder<MultiServerDeployerBuilderT, String, SailingAnalyticsHost<String>, SailingAnalyticsMasterConfiguration<String>, AppConfigBuilderT>> AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> moveMasterToOtherInstance(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, boolean useSharedInstance, Optional<InstanceType> optionalInstanceType, Optional<SailingAnalyticsHost<String>> optionalPreferredInstanceToDeployTo, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String optionalMasterReplicationBearerTokenOrNull, String optionalReplicaReplicationBearerTokenOrNull, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull) throws MalformedURLException, IOException, TimeoutException, InterruptedException, ExecutionException, Exception {
        SailingAnalyticsProcess<String> newMaster;
        Integer igtimiRiotPort = ((SailingAnalyticsProcess)replicaSet.getMaster()).getIgtimiRiotPort(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        if (replicaSet.isLocalReplicaSet()) {
            throw new IllegalArgumentException("A replica set cannot move its own master process. Current replica set: " + ServerInfo.getName());
        }
        SailingAnalyticsProcess<String> newTemporaryReplica = this.ensureAtLeastOneReplicaExistsStopReplicatingAndRemoveMasterFromTargetGroups(replicaSet, optionalKeyName, privateKeyEncryptionPassphrase, this.getEffectiveBearerToken(optionalReplicaReplicationBearerTokenOrNull));
        Release release = replicaSet.getVersion(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        AwsRegion region = ((SailingAnalyticsProcess)replicaSet.getMaster()).getHost().getRegion();
        SailingAnalyticsHost hostToDeployTo = null;
        if (useSharedInstance) {
            hostToDeployTo = new EligibleInstanceForReplicaSetFindingStrategyImpl(this, region, optionalKeyName, privateKeyEncryptionPassphrase, true, true, optionalInstanceType, optionalPreferredInstanceToDeployTo).getInstanceToDeployTo(replicaSet);
        }
        logger.info("Stopping master " + replicaSet.getMaster());
        ((SailingAnalyticsProcess)replicaSet.getMaster()).stopAndTerminateIfLast(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        AppConfigBuilderT masterConfigurationBuilder = this.createMasterConfigurationBuilder(replicaSet.getName(), optionalMasterReplicationBearerTokenOrNull, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, igtimiRiotPort, region, release);
        masterConfigurationBuilder.setPort(replicaSet.getPort());
        if (useSharedInstance) {
            assert (hostToDeployTo != null);
            logger.info("Launching new master on shared instance " + hostToDeployTo);
            newMaster = this.deployProcessToSharedInstance(hostToDeployTo, masterConfigurationBuilder, optionalKeyName, privateKeyEncryptionPassphrase);
        } else {
            assert (hostToDeployTo == null);
            Object masterHostBuilder = StartSailingAnalyticsMasterHost.masterHostBuilder(masterConfigurationBuilder);
            ((StartSailingAnalyticsMasterHost.Builder)((StartSailingAnalyticsMasterHost.Builder)((StartSailingAnalyticsMasterHost.Builder)((StartSailingAnalyticsMasterHost.Builder)masterHostBuilder.setInstanceType(optionalInstanceType.orElse(InstanceType.valueOf((String)"C5_2_XLARGE")))).setOptionalTimeout(Landscape.WAIT_FOR_HOST_TIMEOUT)).setLandscape((Landscape)this.getLandscape())).setRegion(region)).setPrivateKeyEncryptionPassphrase(privateKeyEncryptionPassphrase);
            if (optionalKeyName != null) {
                masterHostBuilder.setKeyName(optionalKeyName);
            }
            StartSailingAnalyticsMasterHost masterHostStartProcedure = (StartSailingAnalyticsMasterHost)masterHostBuilder.build();
            masterHostStartProcedure.run();
            hostToDeployTo = (SailingAnalyticsHost)masterHostStartProcedure.getHost();
            logger.info("Launched dedicated instance for master: " + hostToDeployTo);
            newMaster = masterHostStartProcedure.getSailingAnalyticsProcess();
        }
        newMaster.waitUntilReady(Landscape.WAIT_FOR_HOST_TIMEOUT);
        logger.info("Adding new master " + newMaster + " to target groups");
        replicaSet.getPublicTargetGroup().addTarget(hostToDeployTo);
        replicaSet.getMasterTargetGroup().addTarget((AwsInstance)hostToDeployTo);
        SailingAnalyticsHost finalHostToDeployTo = hostToDeployTo;
        replicaSet.getOtherTargetGroups().forEach(tg -> tg.addTarget((AwsInstance)finalHostToDeployTo));
        this.sendMailAboutMasterAvailable(replicaSet);
        if (newTemporaryReplica != null) {
            newTemporaryReplica.stopAndTerminateIfLast(Landscape.WAIT_FOR_HOST_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        }
        replicaSet.restartAllReplicas(Landscape.WAIT_FOR_HOST_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        return this.getLandscape().getApplicationReplicaSet((Region)region, replicaSet.getServerName(), newMaster, replicaSet.getReplicas(), Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
    }

    private void sendMailAboutMasterUnavailable(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet) throws MailException {
        this.sendMailToReplicaSetOwner(replicaSet, "MasterUnavailableMailSubject", "MasterUnavailableMailBody", Optional.of(SecuredSecurityTypes.ServerActions.CONFIGURE_LOCAL_SERVER));
    }

    private void sendMailAboutMasterAvailable(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet) throws MailException {
        this.sendMailToReplicaSetOwner(replicaSet, "MasterAvailableMailSubject", "MasterAvailableMailBody", Optional.of(SecuredSecurityTypes.ServerActions.CONFIGURE_LOCAL_SERVER));
    }

    private void sendMailToReplicaSetOwner(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, String subjectMessageKey, String bodyMessageKey, Optional<HasPermissions.Action> alsoSendToAllUsersWithThisPermissionOnReplicaSet) throws MailException {
        Iterable usersToSendMailTo = this.getSecurityService().getUsersToInformAboutReplicaSet(replicaSet.getServerName(), alsoSendToAllUsersWithThisPermissionOnReplicaSet);
        ResourceBundleStringMessagesImpl stringMessages = new ResourceBundleStringMessagesImpl(STRING_MESSAGES_BASE_NAME, this.getClass().getClassLoader(), StandardCharsets.UTF_8.name());
        for (User user : usersToSendMailTo) {
            String subject = stringMessages.get(user.getLocaleOrDefault(), subjectMessageKey, new String[]{replicaSet.getServerName()});
            String body = stringMessages.get(user.getLocaleOrDefault(), bodyMessageKey, new String[]{replicaSet.getServerName()});
            if (user.isEmailValidated()) {
                this.getSecurityService().sendMail(user.getName(), subject, body);
                continue;
            }
            logger.warning("Not sending e-mail with subject " + subject + " to user " + user.getName() + " with e-mail address " + user.getEmail() + " because e-mail address has not been validated");
        }
    }

    @Override
    public String getEffectiveBearerToken(String optionalBearerTokenOrNull) {
        return Util.hasLength((String)optionalBearerTokenOrNull) ? optionalBearerTokenOrNull : this.getSecurityService().getOrCreateAccessToken(SessionUtils.getPrincipal().toString());
    }

    @Override
    public AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> changeAutoScalingReplicasInstanceType(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, InstanceType instanceType, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        AwsApplicationReplicaSet result;
        Iterable autoScalingGroups = replicaSet.getAllAutoScalingGroups();
        if (!Util.isEmpty((Iterable)autoScalingGroups)) {
            Iterable<SailingAnalyticsProcess<String>> oldReplicas;
            Iterable<SailingAnalyticsProcess<String>> newSetOfAllReplicas = oldReplicas = ((SailingAnalyticsProcess)replicaSet.getMaster()).getReplicas(Landscape.WAIT_FOR_PROCESS_TIMEOUT, new SailingAnalyticsHostSupplier(), this.processFactoryFromHostAndServerDirectory);
            HashSet<SailingAnalyticsProcess> terminatedReplicas = new HashSet<SailingAnalyticsProcess>();
            this.getLandscape().updateInstanceTypeInAutoScalingGroup((Region)((SailingAnalyticsProcess)replicaSet.getMaster()).getHost().getRegion(), autoScalingGroups, replicaSet.getName(), instanceType);
            for (AwsAutoScalingGroup autoScalingGroup : autoScalingGroups) {
                logger.info("Rolling upgrade of instances for auto-scaling group " + autoScalingGroup.getName() + " to new instance type" + instanceType);
                int oldMinSize = autoScalingGroup.getAutoScalingGroup().minSize();
                int newMinSize = autoScalingGroup.getAutoScalingGroup().desiredCapacity() + 1;
                this.getLandscape().updateAutoScalingGroupMinSize(autoScalingGroup, newMinSize);
                for (SailingAnalyticsProcess sailingAnalyticsProcess : oldReplicas) {
                    SailingAnalyticsHost replicaHost = sailingAnalyticsProcess.getHost();
                    if (!replicaHost.isManagedByAutoScalingGroup(Collections.singleton(autoScalingGroup))) continue;
                    logger.info("Replica " + sailingAnalyticsProcess + " is managed by auto-scaling group " + autoScalingGroup.getName());
                    newSetOfAllReplicas = this.waitUntilAtLeastSoManyAutoScalingReplicasAreReady((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)replicaSet, autoScalingGroup, newMinSize);
                    this.getLandscape().terminate(replicaHost);
                    terminatedReplicas.add(sailingAnalyticsProcess);
                }
                this.getLandscape().updateAutoScalingGroupMinSize(autoScalingGroup, oldMinSize);
            }
            Iterable newReplicasWithoutTerminated = Util.filter((Iterable)newSetOfAllReplicas, r -> !Util.contains((Iterable)terminatedReplicas, (Object)r));
            newReplicasWithoutTerminated.forEach(replica -> {
                try {
                    replicaSet.getOtherTargetGroups().forEach(tg -> tg.addTarget(replica.getHost()));
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            result = this.getLandscape().getApplicationReplicaSet((Region)((SailingAnalyticsProcess)replicaSet.getMaster()).getHost().getRegion(), replicaSet.getServerName(), (AwsApplicationProcess)((SailingAnalyticsProcess)replicaSet.getMaster()), newReplicasWithoutTerminated, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        } else {
            logger.info("Replica set " + replicaSet.getName() + " does not have an auto-scaling group configured, so no changes can be made to its launch template.");
            result = replicaSet;
        }
        return result;
    }

    private Iterable<SailingAnalyticsProcess<String>> waitUntilAtLeastSoManyAutoScalingReplicasAreReady(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet, AwsAutoScalingGroup autoScalingGroup, int newMinSize) throws Exception {
        SailingAnalyticsProcess master = (SailingAnalyticsProcess)replicaSet.getMaster();
        assert (autoScalingGroup != null);
        HashSet<SailingAnalyticsProcess<String>> replicas = new HashSet<SailingAnalyticsProcess<String>>();
        if (Wait.wait(() -> {
            int readyAutoScalingReplicas = 0;
            try {
                replicas.clear();
                Util.addAll((Iterable)master.getReplicas(Landscape.WAIT_FOR_PROCESS_TIMEOUT, new SailingAnalyticsHostSupplier(), this.processFactoryFromHostAndServerDirectory), (Collection)replicas);
                for (SailingAnalyticsProcess replica : replicas) {
                    if (!replica.getHost().isManagedByAutoScalingGroup(Collections.singleton(autoScalingGroup))) continue;
                    if (replica.waitUntilReady(Landscape.WAIT_FOR_PROCESS_TIMEOUT)) {
                        logger.info("Replica " + replica + " is ready; found " + ++readyAutoScalingReplicas + "/" + newMinSize + " so far");
                        if (readyAutoScalingReplicas < newMinSize) continue;
                        break;
                    }
                    logger.info("Replica " + replica + " NOT ready; still found only " + readyAutoScalingReplicas + "/" + newMinSize + " so far");
                }
            }
            catch (TimeoutException timeoutException) {
                logger.info("Timeout looking for replicas: " + timeoutException);
            }
            if (readyAutoScalingReplicas >= newMinSize) {
                return true;
            }
            return false;
        }, (Optional)Landscape.WAIT_FOR_HOST_TIMEOUT, (Duration)Duration.ONE_SECOND.times(30L), (Level)Level.INFO, (String)("Waiting until at least " + newMinSize + " auto-scaling replicas for replica set " + replicaSet.getName() + " are ready"))) {
            return replicas;
        }
        throw new TimeoutException("Could determine set of ready auto-scaling replicas of replica set " + replicaSet.getName() + " within timeout period " + Landscape.WAIT_FOR_HOST_TIMEOUT);
    }

    @Override
    public <ShardingKey> boolean isEligibleForDeployment(SailingAnalyticsHost<ShardingKey> host, String serverName, int port, Integer optionalIgtimiRiotPort, Optional<Duration> optionalTimeout, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        boolean result;
        if (host.isManagedByAutoScalingGroup()) {
            result = false;
        } else {
            result = true;
            Iterable applicationProcesses = host.getApplicationProcesses(optionalTimeout, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
            for (SailingAnalyticsProcess applicationProcess : applicationProcesses) {
                if (applicationProcess.getPort() != port && !applicationProcess.getServerName(optionalTimeout, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase).equals(serverName) && (optionalIgtimiRiotPort == null || !Util.equalsWithNull((Object)optionalIgtimiRiotPort, (Object)applicationProcess.getIgtimiRiotPort(optionalTimeout, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase)))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public SailingServer getSailingServer(String hostname, String username, String password, Optional<Integer> port) throws MalformedURLException {
        SailingServerFactory fac = (SailingServerFactory)this.sailingServerFactoryTracker.getService();
        return fac.getSailingServer(RemoteServerUtil.getBaseServerUrl((String)hostname, (int)(port.isPresent() ? port.get() : 443)), username, password);
    }

    @Override
    public SailingServer getSailingServer(String hostname, String bearerToken, Optional<Integer> port) throws MalformedURLException {
        SailingServerFactory fac = (SailingServerFactory)this.sailingServerFactoryTracker.getService();
        return fac.getSailingServer(RemoteServerUtil.getBaseServerUrl((String)hostname, (int)port.orElse(443)), bearerToken);
    }

    private <BuilderT extends CreateShard.Builder<BuilderT, CreateShard<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>, String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>> CreateShard.Builder<BuilderT, CreateShard<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>, String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> createShardBuilder() {
        return CreateShard.builder();
    }

    private <BuilderT extends ShardProcedure.Builder<BuilderT, AddShardingKeyToShard<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>, String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>> ShardProcedure.Builder<BuilderT, AddShardingKeyToShard<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>, String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> appendShardingKeyToShardBuilder() {
        return AddShardingKeyToShard.builder();
    }

    private <BuilderT extends ShardProcedure.Builder<BuilderT, RemoveShardingKeyFromShard<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>, String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>> ShardProcedure.Builder<BuilderT, RemoveShardingKeyFromShard<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>, String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> removeShardingKeyFromShardBuilder() {
        return RemoveShardingKeyFromShard.builder();
    }

    @Override
    public void removeShardingKeysFromShard(Iterable<String> selectedleaderboards, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> applicationReplicaSet, AwsRegion region, String shardName, String bearerToken) throws Exception {
        SailingServer server = this.getSailingServer(applicationReplicaSet.getHostname(), bearerToken, Optional.of(443));
        HashSet<String> shardingKeys = new HashSet<String>();
        for (String leaderboardName : selectedleaderboards) {
            shardingKeys.add(server.getLeaderboardShardingKey(leaderboardName));
        }
        ((RemoveShardingKeyFromShard)this.removeShardingKeyFromShardBuilder().setLandscape(this.getLandscape()).setRegion((Region)region).setPathPrefixForShardingKey("/gwt/service/sailing").setShardingKeys(shardingKeys).setReplicaSet(applicationReplicaSet).setShardName(shardName).build()).run();
    }

    @Override
    public void appendShardingKeysToShard(Iterable<String> selectedLeaderboards, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> applicationReplicaSet, AwsRegion region, String shardName, String bearerToken) throws Exception {
        SailingServer server = this.getSailingServer(applicationReplicaSet.getHostname(), bearerToken, Optional.of(443));
        HashSet<String> shardingkeys = new HashSet<String>();
        for (String s : selectedLeaderboards) {
            shardingkeys.add(server.getLeaderboardShardingKey(s));
        }
        ((AddShardingKeyToShard)this.appendShardingKeyToShardBuilder().setLandscape(this.getLandscape()).setRegion((Region)region).setPathPrefixForShardingKey("/gwt/service/sailing").setShardingKeys(shardingkeys).setReplicaSet(applicationReplicaSet).setShardName(shardName).build()).run();
    }

    @Override
    public void removeShard(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> applicationReplicaSet, String shardTargetGroupArn) throws Exception {
        for (Map.Entry entry : applicationReplicaSet.getShards().entrySet()) {
            if (!shardTargetGroupArn.equals(((AwsShard)entry.getKey()).getTargetGroup().getTargetGroupArn())) continue;
            applicationReplicaSet.removeShard((AwsShard)entry.getKey(), this.getLandscape());
        }
    }

    @Override
    public void addShard(Iterable<String> selectedLeaderboardNames, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> applicationReplicaSet, AwsRegion region, String bearerToken, String shardName) throws Exception {
        SailingServer server = this.getSailingServer(applicationReplicaSet.getHostname(), bearerToken, Optional.of(443));
        HashSet<String> shardingkeys = new HashSet<String>();
        for (String s : selectedLeaderboardNames) {
            shardingkeys.add(server.getLeaderboardShardingKey(s));
        }
        ((CreateShard)((CreateShard.Builder)((CreateShard.Builder)((CreateShard.Builder)((CreateShard.Builder)((CreateShard.Builder)((CreateShard.Builder)this.createShardBuilder().setLandscape(this.getLandscape())).setTargetGroupNamePrefix("S-").setShardingKeys(shardingkeys)).setReplicaSet(applicationReplicaSet)).setRegion((Region)region)).setPathPrefixForShardingKey("/gwt/service/sailing")).setShardName(shardName)).build()).run();
    }

    @Override
    public Util.Triple<SailingAnalyticsHost<String>, Map<String, SailingAnalyticsProcess<String>>, Map<String, SailingAnalyticsProcess<String>>> moveAllApplicationProcessesAwayFrom(SailingAnalyticsHost<String> host, Optional<InstanceType> optionalInstanceTypeForNewInstance, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        if (!host.getInstance().tags().stream().anyMatch(tag -> tag.key().equals("sailing-analytics-server") && tag.value().equals("___multi___"))) {
            throw new IllegalArgumentException("Host " + host + " is not tagged as multiserver. The host is expected to have value " + "___multi___" + " for tag " + "sailing-analytics-server");
        }
        logger.info("Moving all application processes from shared host " + host + " to a newly started shared host.");
        AwsRegion region = host.getRegion();
        SailingAnalyticsHostSupplier hostSupplier = new SailingAnalyticsHostSupplier();
        SailingAnalyticsHost<String> targetHost = this.createEmptyMultiServer(region, Optional.of(optionalInstanceTypeForNewInstance.orElse(host.getInstanceType())), Optional.of(host.getAvailabilityZone()), Optional.of("SL Multi-Server"), Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        HashMap<String, SailingAnalyticsProcess> masterProcessesMoved = new HashMap<String, SailingAnalyticsProcess>();
        HashMap<String, SailingAnalyticsProcess> replicaProcessesMoved = new HashMap<String, SailingAnalyticsProcess>();
        for (AwsApplicationReplicaSet replicaSet : this.getLandscape().getApplicationReplicaSetsByTag((Region)region, "sailing-analytics-server", hostSupplier, Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase)) {
            if (((SailingAnalyticsProcess)replicaSet.getMaster()).getHost().getId().equals(host.getId())) {
                logger.info("Found master process " + replicaSet.getMaster() + " on host " + host + " to move to " + targetHost);
                masterProcessesMoved.put(replicaSet.getName(), (SailingAnalyticsProcess)replicaSet.getMaster());
                String replicaReplicationBearerToken = Util.stream((Iterable)replicaSet.getReplicas()).findAny().map(replica -> {
                    try {
                        return replica.getEnvShValueFor((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.REPLICATE_MASTER_BEARER_TOKEN, Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error trying to obtain environment variable value for " + DefaultProcessConfigurationVariables.REPLICATE_MASTER_BEARER_TOKEN + " from host " + replica, e);
                        throw new RuntimeException(e);
                    }
                }).orElse(((SailingAnalyticsProcess)replicaSet.getMaster()).getEnvShValueFor((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.REPLICATE_MASTER_BEARER_TOKEN, Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase));
                Integer totalMemorySizeFactor = this.getTotalMemorySizeFactor(optionalKeyName, privateKeyEncryptionPassphrase, (SailingAnalyticsProcess)replicaSet.getMaster());
                this.moveMasterToOtherInstance((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)replicaSet, true, Optional.empty(), Optional.of(targetHost), optionalKeyName, privateKeyEncryptionPassphrase, ((SailingAnalyticsProcess)replicaSet.getMaster()).getEnvShValueFor((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.REPLICATE_MASTER_BEARER_TOKEN, Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase), replicaReplicationBearerToken, totalMemorySizeFactor == null ? this.getMemoryInMegabytes(optionalKeyName, privateKeyEncryptionPassphrase, (SailingAnalyticsProcess)replicaSet.getMaster()) : null, totalMemorySizeFactor);
                logger.info("Done moving master of " + replicaSet.getName() + " from " + host + " to " + targetHost);
                continue;
            }
            SailingAnalyticsProcess replica2 = Util.stream((Iterable)replicaSet.getReplicas()).filter(r -> r.getHost().getId().equals(host.getId())).findFirst().orElse(null);
            if (replica2 == null) continue;
            logger.info("Found replica process " + replica2 + " on host " + host + " to move to " + targetHost);
            String replicaReplicationBearerToken = replica2.getEnvShValueFor((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.REPLICATE_MASTER_BEARER_TOKEN, Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
            replicaProcessesMoved.put(replicaSet.getName(), replica2);
            Integer totalMemorySizeFactor = this.getTotalMemorySizeFactor(optionalKeyName, privateKeyEncryptionPassphrase, replica2);
            Integer optionalIgtimiRiotPort = ((SailingAnalyticsProcess)replicaSet.getMaster()).getIgtimiRiotPort(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
            SailingAnalyticsProcess<String> newReplica = this.deployReplicaToExistingHost((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)replicaSet, targetHost, optionalKeyName, privateKeyEncryptionPassphrase, replicaReplicationBearerToken, totalMemorySizeFactor == null ? this.getMemoryInMegabytes(optionalKeyName, privateKeyEncryptionPassphrase, replica2) : null, totalMemorySizeFactor, optionalIgtimiRiotPort);
            if (newReplica == null || !newReplica.isReady(Landscape.WAIT_FOR_PROCESS_TIMEOUT)) continue;
            logger.info("New replica " + newReplica + " deployed successfully to " + targetHost + "; removing old replica " + replica2 + " from public target group of application replica set " + replicaSet.getName());
            replicaSet.getPublicTargetGroup().removeTarget(replica2.getHost());
            replicaSet.getOtherTargetGroups().forEach(tg -> tg.removeTarget(replica2.getHost()));
            logger.info("Stopping old replica " + replica2);
            replica2.stopAndTerminateIfLast(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        }
        return new Util.Triple(targetHost, masterProcessesMoved, replicaProcessesMoved);
    }

    private Integer getTotalMemorySizeFactor(String optionalKeyName, byte[] privateKeyEncryptionPassphrase, SailingAnalyticsProcess<String> process) throws Exception {
        String totalMemorySizeFactorAsString = process.getEnvShValueFor((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.TOTAL_MEMORY_SIZE_FACTOR, Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        Integer totalMemorySizeFactor = Util.hasLength((String)totalMemorySizeFactorAsString) ? Integer.valueOf(totalMemorySizeFactorAsString) : null;
        return totalMemorySizeFactor;
    }

    private Integer getMemoryInMegabytes(String optionalKeyName, byte[] privateKeyEncryptionPassphrase, SailingAnalyticsProcess<String> process) throws Exception {
        String memoryInMegabytesAsString = process.getEnvShValueFor((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.MEMORY, Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        Integer memoryInMegabytes = JvmUtils.getMegabytesFromJvmSize((String)memoryInMegabytesAsString).orElse(null);
        return memoryInMegabytes;
    }
}

