/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.coursedata.impl;

import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sse.common.Color;
import com.sap.sse.common.impl.AbstractColor;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.Serializable;
import org.json.simple.JSONObject;

public class MarkDeserializer
implements JsonDeserializer<Mark> {
    private SharedDomainFactory<?> factory;

    public MarkDeserializer(SharedDomainFactory<?> factory) {
        this.factory = factory;
    }

    public Mark deserialize(JSONObject object) throws JsonDeserializationException {
        Serializable id = UUIDHelper.tryUuidConversion((Serializable)((Serializable)object.get((Object)"id")));
        String colorAsString = (String)object.get((Object)"color");
        Color color = colorAsString == null ? null : AbstractColor.getCssColor((String)colorAsString);
        String pattern = (String)object.get((Object)"pattern");
        String shape = (String)object.get((Object)"shape");
        MarkType type = MarkType.valueOf((String)((String)object.get((Object)"type")));
        String name = (String)object.get((Object)"name");
        String shortName = (String)object.get((Object)"shortName");
        Mark mark = this.factory.getOrCreateMark(id, name, shortName, type, color, shape, pattern);
        return mark;
    }
}

