/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.server;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sailing.landscape.LandscapeService;
import com.sap.sailing.landscape.SailingAnalyticsHost;
import com.sap.sailing.landscape.SailingAnalyticsMetrics;
import com.sap.sailing.landscape.SailingAnalyticsProcess;
import com.sap.sailing.landscape.SailingReleaseRepository;
import com.sap.sailing.landscape.impl.SailingAnalyticsHostImpl;
import com.sap.sailing.landscape.impl.SailingAnalyticsProcessImpl;
import com.sap.sailing.landscape.procedures.DeployProcessOnMultiServer;
import com.sap.sailing.landscape.procedures.SailingAnalyticsHostSupplier;
import com.sap.sailing.landscape.procedures.SailingAnalyticsMasterConfiguration;
import com.sap.sailing.landscape.procedures.SailingAnalyticsProcessFactory;
import com.sap.sailing.landscape.procedures.UpgradeAmi;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteService;
import com.sap.sailing.landscape.ui.impl.Activator;
import com.sap.sailing.landscape.ui.shared.AmazonMachineImageDTO;
import com.sap.sailing.landscape.ui.shared.AvailabilityZoneDTO;
import com.sap.sailing.landscape.ui.shared.AwsInstanceDTO;
import com.sap.sailing.landscape.ui.shared.AwsShardDTO;
import com.sap.sailing.landscape.ui.shared.CompareServersResultDTO;
import com.sap.sailing.landscape.ui.shared.LeaderboardNameDTO;
import com.sap.sailing.landscape.ui.shared.MongoEndpointDTO;
import com.sap.sailing.landscape.ui.shared.MongoProcessDTO;
import com.sap.sailing.landscape.ui.shared.MongoScalingInstructionsDTO;
import com.sap.sailing.landscape.ui.shared.ProcessDTO;
import com.sap.sailing.landscape.ui.shared.ReleaseDTO;
import com.sap.sailing.landscape.ui.shared.ReverseProxyDTO;
import com.sap.sailing.landscape.ui.shared.SSHKeyPairDTO;
import com.sap.sailing.landscape.ui.shared.SailingAnalyticsProcessDTO;
import com.sap.sailing.landscape.ui.shared.SailingApplicationReplicaSetDTO;
import com.sap.sailing.landscape.ui.shared.SerializationDummyDTO;
import com.sap.sailing.server.gateway.interfaces.CompareServersResult;
import com.sap.sailing.server.gateway.interfaces.SailingServer;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.server.ResultCachingProxiedRemoteServiceServlet;
import com.sap.sse.landscape.Host;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.MachineImage;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.application.ProcessFactory;
import com.sap.sse.landscape.aws.AmazonMachineImage;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsApplicationProcess;
import com.sap.sse.landscape.aws.AwsApplicationReplicaSet;
import com.sap.sse.landscape.aws.AwsAvailabilityZone;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.AwsShard;
import com.sap.sse.landscape.aws.HostSupplier;
import com.sap.sse.landscape.aws.LandscapeConstants;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.common.shared.PlainRedirectDTO;
import com.sap.sse.landscape.aws.common.shared.RedirectDTO;
import com.sap.sse.landscape.aws.impl.ApacheReverseProxy;
import com.sap.sse.landscape.aws.impl.AwsAvailabilityZoneImpl;
import com.sap.sse.landscape.aws.impl.AwsInstanceImpl;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import com.sap.sse.landscape.aws.orchestration.CreateDNSBasedLoadBalancerMapping;
import com.sap.sse.landscape.aws.orchestration.CreateDynamicLoadBalancerMapping;
import com.sap.sse.landscape.aws.orchestration.CreateLoadBalancerMapping;
import com.sap.sse.landscape.aws.orchestration.StartMongoDBServer;
import com.sap.sse.landscape.common.shared.SecuredLandscapeTypes;
import com.sap.sse.landscape.mongodb.MongoEndpoint;
import com.sap.sse.landscape.mongodb.MongoProcess;
import com.sap.sse.landscape.mongodb.MongoProcessInReplicaSet;
import com.sap.sse.landscape.mongodb.MongoReplicaSet;
import com.sap.sse.landscape.ssh.SSHKeyPair;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.SessionUtils;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.server.SecurityDTOUtil;
import com.sap.sse.util.ServiceTrackerFactory;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import software.amazon.awssdk.services.ec2.model.AvailabilityZone;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.KeyPairInfo;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth;

public class LandscapeManagementWriteServiceImpl
extends ResultCachingProxiedRemoteServiceServlet
implements LandscapeManagementWriteService {
    private static final long serialVersionUID = -3332717645383784425L;
    private static final Logger logger = Logger.getLogger(LandscapeManagementWriteServiceImpl.class.getName());
    private static final Optional<Duration> IMAGE_UPGRADE_TIMEOUT = Optional.of(Duration.ONE_MINUTE.times(10L));
    private final FullyInitializedReplicableTracker<SecurityService> securityServiceTracker;
    private final ServiceTracker<LandscapeService, LandscapeService> landscapeServiceTracker;
    private static final Set<InstanceType> INSTANCE_TYPES_BANNED_FROM_INSTANCE_BASE_NLB_TARGET_GROUPS_AS_SET = new HashSet<InstanceType>(Arrays.asList(LandscapeConstants.INSTANCE_TYPES_BANNED_FROM_INSTANCE_BASED_NLB_TARGET_GROUPS));

    public <ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>> LandscapeManagementWriteServiceImpl() {
        BundleContext context = Activator.getContext();
        this.securityServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
        this.landscapeServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, LandscapeService.class);
    }

    protected SecurityService getSecurityService() {
        try {
            return (SecurityService)this.securityServiceTracker.getInitializedService(0L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected LandscapeService getLandscapeService() {
        try {
            return (LandscapeService)this.landscapeServiceTracker.waitForService(0L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createMfaSessionCredentials(String awsAccessKey, String awsSecret, String mfaTokenCode) {
        this.checkLandscapeManageAwsPermission();
        this.getLandscapeService().createMfaSessionCredentials(awsAccessKey, awsSecret, mfaTokenCode);
    }

    @Override
    public void createSessionCredentials(String awsAccessKey, String awsSecret, String awsSessionToken) {
        this.checkLandscapeManageAwsPermission();
        this.getLandscapeService().createSessionCredentials(awsAccessKey, awsSecret, awsSessionToken);
    }

    @Override
    public void clearSessionCredentials() {
        this.checkLandscapeManageAwsPermission();
        this.getLandscapeService().clearSessionCredentials();
    }

    @Override
    public boolean hasValidSessionCredentials() {
        return this.getLandscapeService().hasValidSessionCredentials();
    }

    private void checkLandscapeManageAwsPermission() {
        SecurityUtils.getSubject().checkPermission(SecuredLandscapeTypes.LANDSCAPE.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)SecuredLandscapeTypes.LandscapeActions.MANAGE, new TypeRelativeObjectIdentifier(new String[]{"AWS"})));
    }

    @Override
    public ArrayList<String> getRegions() {
        this.checkLandscapeManageAwsPermission();
        ArrayList<String> result = new ArrayList<String>();
        Util.addAll((Iterable)Util.map((Iterable)AwsLandscape.obtain((String)"/gwt/service/sailing").getRegions(), r -> r.getId()), result);
        return result;
    }

    @Override
    public ArrayList<String> getInstanceTypeNames(boolean canBeDeployedInNlbInstanceBasedTargetGroup) {
        ArrayList<String> result = new ArrayList<String>();
        Util.addAll((Iterable)Util.map((Iterable)Util.filter(Arrays.asList(InstanceType.values()), instanceType -> !canBeDeployedInNlbInstanceBasedTargetGroup || !INSTANCE_TYPES_BANNED_FROM_INSTANCE_BASE_NLB_TARGET_GROUPS_AS_SET.contains(instanceType)), instanceType -> instanceType.name()), result);
        return result;
    }

    @Override
    public ArrayList<MongoEndpointDTO> getMongoEndpoints(String region) throws MalformedURLException, IOException, URISyntaxException {
        this.checkLandscapeManageAwsPermission();
        ArrayList<MongoEndpointDTO> result = new ArrayList<MongoEndpointDTO>();
        for (MongoEndpoint mongoEndpoint : this.getLandscape().getMongoEndpoints((Region)new AwsRegion(region, this.getLandscape()))) {
            MongoEndpointDTO dto;
            if (mongoEndpoint.isReplicaSet()) {
                MongoReplicaSet replicaSet = mongoEndpoint.asMongoReplicaSet();
                ArrayList<MongoProcessDTO> hostnamesAndPorts = new ArrayList<MongoProcessDTO>();
                for (MongoProcessInReplicaSet process : replicaSet.getInstances()) {
                    hostnamesAndPorts.add(this.convertToMongoProcessDTO((MongoProcess)process, replicaSet.getName()));
                }
                dto = new MongoEndpointDTO(replicaSet.getName(), hostnamesAndPorts);
            } else {
                MongoProcess mongoProcess = mongoEndpoint.asMongoProcess();
                dto = new MongoEndpointDTO(null, Collections.singleton(this.convertToMongoProcessDTO(mongoProcess, null)));
            }
            result.add(dto);
        }
        return result;
    }

    @Override
    public ArrayList<AvailabilityZoneDTO> describeAvailabilityZones(String region) {
        ArrayList<AvailabilityZoneDTO> availabilityZones = new ArrayList<AvailabilityZoneDTO>();
        this.getLandscape().getAvailabilityZones((Region)new AwsRegion(region, this.getLandscape()), Optional.of(this.getLandscape().getDefaultSecurityGroupForApplicationLoadBalancer((Region)new AwsRegion(region, this.getLandscape())).getVpcId())).forEach(az -> {
            boolean bl = availabilityZones.add(new AvailabilityZoneDTO(az.getName(), region, az.getId()));
        });
        return availabilityZones;
    }

    @Override
    public ArrayList<ReverseProxyDTO> getReverseProxies(String region) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsLandscape<String> landscape = this.getLandscape();
        TargetGroup targetGroupInQuestion = null;
        for (TargetGroup targetGroup : landscape.getTargetGroups((Region)new AwsRegion(region, landscape))) {
            for (TagDescription description : targetGroup.getTagDescriptions()) {
                if (description.tags().isEmpty()) continue;
                for (Tag tag : description.tags()) {
                    if (!tag.key().equals("allReverseProxies") || targetGroup.getLoadBalancerArn() == null || targetGroup.getLoadBalancerArn().contains("loadbalancer/net")) continue;
                    targetGroupInQuestion = targetGroup;
                }
            }
        }
        Map healths = null;
        if (targetGroupInQuestion != null) {
            healths = landscape.getTargetHealthDescriptions(targetGroupInQuestion);
        }
        ArrayList<ReverseProxyDTO> results = new ArrayList<ReverseProxyDTO>();
        for (AwsInstance instance : landscape.getReverseProxyCluster((Region)new AwsRegion(region, landscape)).getHosts()) {
            boolean isDisposable = landscape.getTag(instance, "DisposableProxy").isPresent();
            ReverseProxyDTO dto = this.convertToReverseProxyDTO(region, healths, (AwsInstance<String>)instance, isDisposable);
            results.add(dto);
        }
        return results;
    }

    private ReverseProxyDTO convertToReverseProxyDTO(String region, Map<AwsInstance<String>, TargetHealth> healths, AwsInstance<String> instance, boolean isDisposable) {
        return new ReverseProxyDTO(instance.getInstanceId(), instance.getPrivateAddress().getHostAddress(), instance.getPublicAddress().getHostAddress(), region, instance.getLaunchTimePoint(), instance.isSharedHost(), instance.getNameTag(), instance.getImageId(), this.extractHealth(healths, instance), isDisposable, new AvailabilityZoneDTO(instance.getAvailabilityZone().getName(), instance.getRegion().getId(), instance.getAvailabilityZone().getId()));
    }

    @Override
    public void rotateHttpdLogs(ReverseProxyDTO instanceDTO, String region, String optionalKeyName, byte[] passphraseForPrivateKeyDecryption) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsInstance awsInstance = this.getLandscape().getHostByInstanceId((Region)new AwsRegion(region, this.getLandscape()), instanceDTO.getInstanceId(), AwsInstanceImpl::new);
        new ApacheReverseProxy(this.getLandscape(), awsInstance).rotateLogs(Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption);
    }

    private String extractHealth(Map<AwsInstance<String>, TargetHealth> healths, AwsInstance<String> instance) {
        TargetHealth health;
        String NO_HEALTH_VALUE_FOUND_MSG = "No health value found";
        String health_message = healths == null ? "No health value found" : ((health = healths.get(instance)) != null ? health.state().toString() : "No health value found");
        return health_message;
    }

    @Override
    public void removeReverseProxy(ReverseProxyDTO proxy, String region, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion awsRegion = new AwsRegion(region, this.getLandscape());
        AwsInstance awsInstance = this.getLandscape().getHostByInstanceId((Region)awsRegion, proxy.getInstanceId(), AwsInstanceImpl::new);
        this.getLandscape().getReverseProxyCluster((Region)awsRegion).removeHost(awsInstance, Optional.of(optionalKeyName), privateKeyEncryptionPassphrase);
    }

    @Override
    public void addReverseProxy(String instanceName, String instanceType, String region, String launchKey, AvailabilityZoneDTO availabilityZoneDTO) {
        try {
            this.getLandscape().getReverseProxyCluster((Region)new AwsRegion(region, this.getLandscape())).createHost(instanceName, InstanceType.valueOf((String)instanceType), (AwsAvailabilityZone)new AwsAvailabilityZoneImpl(availabilityZoneDTO.getAzId(), availabilityZoneDTO.getAzName(), new AwsRegion(region, this.getLandscape())), launchKey);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    private MongoEndpoint getMongoEndpoint(MongoEndpointDTO mongoEndpointDTO) {
        MongoReplicaSet result;
        if (mongoEndpointDTO == null) {
            result = null;
        } else {
            SailingAnalyticsHostSupplier hostSupplier = new SailingAnalyticsHostSupplier();
            HashSet<Util.Pair> nodes = new HashSet<Util.Pair>();
            for (MongoProcessDTO node : mongoEndpointDTO.getHostnamesAndPorts()) {
                nodes.add(new Util.Pair((Object)this.getLandscape().getHostByInstanceId((Region)new AwsRegion(node.getHost().getRegion(), this.getLandscape()), node.getHost().getInstanceId(), (HostSupplier)hostSupplier), (Object)node.getPort()));
            }
            if (mongoEndpointDTO.getReplicaSetName() == null) {
                Util.Pair hostAndPort = (Util.Pair)nodes.iterator().next();
                result = this.getLandscape().getDatabaseConfigurationForSingleNode((AwsInstance)hostAndPort.getA(), ((Integer)hostAndPort.getB()).intValue());
            } else {
                result = this.getLandscape().getDatabaseConfigurationForReplicaSet(mongoEndpointDTO.getReplicaSetName(), nodes);
            }
        }
        return result;
    }

    private MongoProcessDTO convertToMongoProcessDTO(MongoProcess mongoProcess, String replicaSetName) throws MalformedURLException, IOException, URISyntaxException {
        return new MongoProcessDTO(this.convertToAwsInstanceDTO(mongoProcess.getHost()), mongoProcess.getPort(), mongoProcess.getHostname(Landscape.WAIT_FOR_PROCESS_TIMEOUT), replicaSetName, mongoProcess.getURI(Optional.empty(), Landscape.WAIT_FOR_PROCESS_TIMEOUT).toString());
    }

    private AwsInstanceDTO convertToAwsInstanceDTO(Host host) {
        return new AwsInstanceDTO(host.getId().toString(), host.getPrivateAddress().getHostAddress(), host.getPublicAddress() == null ? null : host.getPublicAddress().getHostAddress(), host.getRegion().getId(), host.getLaunchTimePoint(), host.isSharedHost(), new AvailabilityZoneDTO(host.getAvailabilityZone().getName(), host.getRegion().getId(), host.getAvailabilityZone().getId()));
    }

    @Override
    public ArrayList<SailingApplicationReplicaSetDTO<String>> getApplicationReplicaSets(String regionId, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        ArrayList<SailingApplicationReplicaSetDTO<String>> result = new ArrayList<SailingApplicationReplicaSetDTO<String>>();
        AwsRegion region = new AwsRegion(regionId, this.getLandscape());
        SailingAnalyticsHostSupplier hostSupplier = new SailingAnalyticsHostSupplier();
        HashMap<Future<SailingApplicationReplicaSetDTO>, AwsApplicationReplicaSet> resultFutures = new HashMap<Future<SailingApplicationReplicaSetDTO>, AwsApplicationReplicaSet>();
        ScheduledExecutorService backgroundThreadPool = ThreadPoolUtil.INSTANCE.createBackgroundTaskThreadPoolExecutor("Constructing SailingApplicationReplicaSetDTOs " + UUID.randomUUID());
        for (AwsApplicationReplicaSet applicationServerReplicaSet : this.getLandscape().getApplicationReplicaSetsByTag((Region)region, "sailing-analytics-server", (HostSupplier)hostSupplier, Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase)) {
            resultFutures.put(backgroundThreadPool.submit(() -> this.convertToSailingApplicationReplicaSetDTO((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)applicationServerReplicaSet, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase)), applicationServerReplicaSet);
        }
        Util.addAll((Iterable)Util.filter((Iterable)Util.map(resultFutures.keySet(), future -> {
            try {
                return (SailingApplicationReplicaSetDTO)future.get(((Duration)Landscape.WAIT_FOR_PROCESS_TIMEOUT.get()).asMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.log(Level.WARNING, "Problem waiting for a replica set " + resultFutures.get(future) + "; ignoring that replica set", e);
                return null;
            }
        }), r -> r != null), result);
        backgroundThreadPool.shutdown();
        return result;
    }

    private SailingApplicationReplicaSetDTO<String> convertToSailingApplicationReplicaSetDTO(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> applicationServerReplicaSet, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return new SailingApplicationReplicaSetDTO<String>(applicationServerReplicaSet.getName(), this.convertToSailingAnalyticsProcessDTO((SailingAnalyticsProcess<String>)((SailingAnalyticsProcess)applicationServerReplicaSet.getMaster()), optionalKeyName, privateKeyEncryptionPassphrase), Util.map((Iterable)applicationServerReplicaSet.getReplicas(), r -> {
            try {
                return this.convertToSailingAnalyticsProcessDTO((SailingAnalyticsProcess<String>)r, optionalKeyName, privateKeyEncryptionPassphrase);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }), applicationServerReplicaSet.getVersion(Landscape.WAIT_FOR_PROCESS_TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase).getName(), applicationServerReplicaSet.getHostname(), this.getLandscapeService().getDefaultRedirectPath(applicationServerReplicaSet.getDefaultRedirectRule()), applicationServerReplicaSet.getAutoScalingGroup() == null ? null : (applicationServerReplicaSet.getAutoScalingGroup().getLaunchTemplateDefaultVersion() == null ? null : applicationServerReplicaSet.getAutoScalingGroup().getLaunchTemplateDefaultVersion().launchTemplateData().imageId()));
    }

    private SailingAnalyticsProcessDTO convertToSailingAnalyticsProcessDTO(SailingAnalyticsProcess<String> sailingAnalyticsProcess, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return new SailingAnalyticsProcessDTO(this.convertToAwsInstanceDTO((Host)sailingAnalyticsProcess.getHost()), sailingAnalyticsProcess.getPort(), sailingAnalyticsProcess.getHostname(), sailingAnalyticsProcess.getRelease(SailingReleaseRepository.INSTANCE, Landscape.WAIT_FOR_PROCESS_TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase).getName(), sailingAnalyticsProcess.getTelnetPortToOSGiConsole(Landscape.WAIT_FOR_PROCESS_TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase), sailingAnalyticsProcess.getServerName(Landscape.WAIT_FOR_PROCESS_TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase), sailingAnalyticsProcess.getServerDirectory(Landscape.WAIT_FOR_PROCESS_TIMEOUT), sailingAnalyticsProcess.getExpeditionUdpPort(Landscape.WAIT_FOR_PROCESS_TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase), sailingAnalyticsProcess.getIgtimiRiotPort(Landscape.WAIT_FOR_PROCESS_TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase), sailingAnalyticsProcess.getStartTimePoint(Landscape.WAIT_FOR_PROCESS_TIMEOUT));
    }

    private AwsLandscape<String> getLandscape() {
        this.checkLandscapeManageAwsPermission();
        return this.getLandscapeService().getLandscape();
    }

    @Override
    public Boolean verifyPassphrase(String regionId, SSHKeyPairDTO key, String privateKeyEncryptionPassphrase) {
        SSHKeyPair keypair;
        JSch jsch = new JSch();
        boolean res = key == null ? false : ((keypair = this.getLandscape().getSSHKeyPair((Region)new AwsRegion(regionId, this.getLandscape()), key.getName())) == null ? false : keypair.checkPassphrase(jsch, privateKeyEncryptionPassphrase.getBytes()));
        return res;
    }

    @Override
    public MongoEndpointDTO getMongoEndpoint(String region, String replicaSetName) throws MalformedURLException, IOException, URISyntaxException {
        return this.getMongoEndpoints(region).stream().filter(mep -> Util.equalsWithNull((Object)mep.getReplicaSetName(), (Object)replicaSetName)).findAny().orElse(null);
    }

    @Override
    public SSHKeyPairDTO generateSshKeyPair(String regionId, String keyName, String privateKeyEncryptionPassphrase) {
        Subject subject = SecurityUtils.getSubject();
        SSHKeyPair dummyKeyPairForSecurityCheck = new SSHKeyPair(regionId, subject.getPrincipal().toString(), TimePoint.now(), keyName, null, null);
        SSHKeyPair keyPair = (SSHKeyPair)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(dummyKeyPairForSecurityCheck.getPermissionType(), dummyKeyPairForSecurityCheck.getIdentifier().getTypeRelativeObjectIdentifier(), keyName, () -> this.getLandscape().createKeyPair((Region)new AwsRegion(regionId, this.getLandscape()), keyName, privateKeyEncryptionPassphrase.getBytes()));
        return this.convertToSSHKeyPairDTO(keyPair);
    }

    @Override
    public SSHKeyPairDTO addSshKeyPair(String regionId, String keyName, String publicKey, String encryptedPrivateKey) throws JSchException {
        Subject subject = SecurityUtils.getSubject();
        SSHKeyPair dummyKeyPairForSecurityCheck = new SSHKeyPair(regionId, subject.getPrincipal().toString(), TimePoint.now(), keyName, null, null);
        SSHKeyPair keyPair = (SSHKeyPair)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(dummyKeyPairForSecurityCheck.getPermissionType(), dummyKeyPairForSecurityCheck.getIdentifier().getTypeRelativeObjectIdentifier(), keyName, () -> this.getLandscape().importKeyPair((Region)new AwsRegion(regionId, this.getLandscape()), publicKey.getBytes(), encryptedPrivateKey.getBytes(), keyName));
        return this.convertToSSHKeyPairDTO(keyPair);
    }

    private SSHKeyPairDTO convertToSSHKeyPairDTO(SSHKeyPair keyPair) {
        SSHKeyPairDTO result = new SSHKeyPairDTO(keyPair.getRegionId(), keyPair.getName(), keyPair.getCreatorName(), keyPair.getCreationTime());
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)result);
        return result;
    }

    @Override
    public ArrayList<SSHKeyPairDTO> getSshKeys(String regionId) {
        ArrayList<SSHKeyPairDTO> result = new ArrayList<SSHKeyPairDTO>();
        AwsLandscape<String> landscape = this.getLandscape();
        AwsRegion region = new AwsRegion(regionId, landscape);
        for (KeyPairInfo keyPairInfo : landscape.getAllKeyPairInfos((Region)region)) {
            SSHKeyPair key = landscape.getSSHKeyPair((Region)region, keyPairInfo.keyName());
            if (key == null || !SecurityUtils.getSubject().isPermitted(key.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))) continue;
            SSHKeyPairDTO sshKeyPairDTO = new SSHKeyPairDTO(key.getRegionId(), key.getName(), key.getCreatorName(), key.getCreationTime());
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)sshKeyPairDTO);
            result.add(sshKeyPairDTO);
        }
        return result;
    }

    @Override
    public void removeSshKey(SSHKeyPairDTO keyPair) {
        this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)keyPair, () -> this.getLandscape().deleteKeyPair((Region)new AwsRegion(keyPair.getRegionId(), this.getLandscape()), keyPair.getName()));
    }

    @Override
    public byte[] getEncryptedSshPrivateKey(String regionId, String keyName) throws JSchException {
        AwsLandscape landscape = AwsLandscape.obtain((String)"/gwt/service/sailing");
        SSHKeyPair keyPair = landscape.getSSHKeyPair((Region)new AwsRegion(regionId, landscape), keyName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)keyPair);
        return keyPair.getEncryptedPrivateKey();
    }

    @Override
    public byte[] getSshPublicKey(String regionId, String keyName) throws JSchException {
        AwsLandscape landscape = AwsLandscape.obtain((String)"/gwt/service/sailing");
        SSHKeyPair keyPair = landscape.getSSHKeyPair((Region)new AwsRegion(regionId, landscape), keyName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)keyPair);
        return keyPair.getPublicKey();
    }

    @Override
    public ArrayList<AmazonMachineImageDTO> getAmazonMachineImages(String region) {
        this.checkLandscapeManageAwsPermission();
        ArrayList<AmazonMachineImageDTO> result = new ArrayList<AmazonMachineImageDTO>();
        AwsRegion awsRegion = new AwsRegion(region, this.getLandscape());
        AwsLandscape<String> landscape = this.getLandscape();
        for (String imageType : landscape.getMachineImageTypes((Region)awsRegion)) {
            for (AmazonMachineImage machineImage : landscape.getAllImagesWithType((Region)awsRegion, imageType)) {
                AmazonMachineImageDTO dto = new AmazonMachineImageDTO(machineImage.getId(), machineImage.getRegion().getId(), machineImage.getName(), imageType, machineImage.getState().name(), machineImage.getCreatedAt());
                result.add(dto);
            }
        }
        return result;
    }

    @Override
    public void removeAmazonMachineImage(String region, String machineImageId) {
        this.checkLandscapeManageAwsPermission();
        AwsLandscape<String> landscape = this.getLandscape();
        AmazonMachineImage ami = landscape.getImage((Region)new AwsRegion(region, landscape), machineImageId);
        ami.delete();
    }

    @Override
    public AmazonMachineImageDTO upgradeAmazonMachineImage(String region, String machineImageId) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsLandscape<String> landscape = this.getLandscape();
        AwsRegion awsRegion = new AwsRegion(region, landscape);
        AmazonMachineImage ami = landscape.getImage((Region)awsRegion, machineImageId);
        UpgradeAmi.Builder upgradeAmiBuilder = UpgradeAmi.builder();
        ((UpgradeAmi.Builder)((UpgradeAmi.Builder)((UpgradeAmi.Builder)upgradeAmiBuilder.setLandscape(landscape)).setRegion(awsRegion)).setMachineImage((MachineImage)ami)).setOptionalTimeout(IMAGE_UPGRADE_TIMEOUT);
        UpgradeAmi upgradeAmi = (UpgradeAmi)upgradeAmiBuilder.build();
        upgradeAmi.run();
        AmazonMachineImage resultingAmi = upgradeAmi.getUpgradedAmi();
        return new AmazonMachineImageDTO(resultingAmi.getId(), resultingAmi.getRegion().getId(), resultingAmi.getName(), resultingAmi.getType(), resultingAmi.getState().name(), resultingAmi.getCreatedAt());
    }

    @Override
    public void scaleMongo(String regionId, MongoScalingInstructionsDTO mongoScalingInstructions, String keyName) throws Exception {
        int WAIT_TIME_FOR_REPLICA_SET_TO_APPLY_CONFIG_CHANCE_IN_MILLIS = 5000;
        this.checkLandscapeManageAwsPermission();
        AwsLandscape<String> landscape = this.getLandscape();
        Iterator<MongoProcessDTO> i = mongoScalingInstructions.getHostnamesAndPortsToShutDown().iterator();
        while (i.hasNext()) {
            ProcessDTO processToShutdown = i.next();
            logger.info("Shutting down MongoDB instance " + processToShutdown.getHost().getInstanceId() + " on behalf of user " + SessionUtils.getPrincipal());
            AwsRegion region = new AwsRegion(processToShutdown.getHost().getRegion(), landscape);
            AwsInstanceImpl instance = new AwsInstanceImpl(processToShutdown.getHost().getInstanceId(), (AwsAvailabilityZone)new AwsAvailabilityZoneImpl(processToShutdown.getHost().getAvailabilityZoneId(), processToShutdown.getHost().getAvailabilityZoneName(), region), InetAddress.getByName(processToShutdown.getHost().getPrivateIpAddress()), processToShutdown.getHost().getLaunchTimePoint(), landscape);
            instance.terminate();
            if (!i.hasNext()) continue;
            Thread.sleep(5000L);
        }
        if (mongoScalingInstructions.getReplicaSetName() == null) {
            throw new IllegalArgumentException("Can only scale MongoDB Replica Sets, not standalone instances");
        }
        AwsRegion region = new AwsRegion(regionId, landscape);
        int i2 = 0;
        while (i2 < mongoScalingInstructions.getLaunchParameters().getNumberOfInstances()) {
            logger.info("Launching new MongoDB instance of type " + mongoScalingInstructions.getLaunchParameters().getInstanceType() + " on behalf of user " + SessionUtils.getPrincipal());
            StartMongoDBServer.Builder startMongoProcessBuilder = StartMongoDBServer.builder();
            StartMongoDBServer startMongoDBServer = (StartMongoDBServer)((StartMongoDBServer.Builder)((StartMongoDBServer.Builder)((StartMongoDBServer.Builder)((StartMongoDBServer.Builder)startMongoProcessBuilder.setLandscape(landscape)).setInstanceType(InstanceType.valueOf((String)mongoScalingInstructions.getLaunchParameters().getInstanceType()))).setKeyName(keyName)).setRegion(region)).setReplicaSetName(mongoScalingInstructions.getReplicaSetName()).setReplicaSetPrimary(mongoScalingInstructions.getLaunchParameters().getReplicaSetPrimary()).setReplicaSetPriority(mongoScalingInstructions.getLaunchParameters().getReplicaSetPriority().intValue()).setReplicaSetVotes(mongoScalingInstructions.getLaunchParameters().getReplicaSetVotes().intValue()).build();
            startMongoDBServer.run();
            if (i2 < mongoScalingInstructions.getLaunchParameters().getNumberOfInstances() - 1) {
                Thread.sleep(5000L);
            }
            ++i2;
        }
    }

    @Override
    public SailingApplicationReplicaSetDTO<String> createApplicationReplicaSet(String regionId, String name, boolean sharedMasterInstance, String sharedInstanceType, String dedicatedInstanceType, boolean dynamicLoadBalancerMapping, String releaseNameOrNullForLatestMaster, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String masterReplicationBearerToken, String replicaReplicationBearerToken, String optionalDomainName, Integer minimumAutoScalingGroupSizeOrNull, Integer maximumAutoScalingGroupSizeOrNull, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull, Integer optionalIgtimiRiotPort) throws Exception {
        this.checkLandscapeManageAwsPermission();
        Release release = this.getLandscapeService().getRelease(releaseNameOrNullForLatestMaster);
        AwsApplicationReplicaSet result = this.getLandscapeService().createApplicationReplicaSet(regionId, name, sharedMasterInstance, sharedInstanceType, dedicatedInstanceType, dynamicLoadBalancerMapping, release.getName(), optionalKeyName, privateKeyEncryptionPassphrase, masterReplicationBearerToken, replicaReplicationBearerToken, optionalDomainName, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, optionalIgtimiRiotPort, Optional.ofNullable(minimumAutoScalingGroupSizeOrNull), Optional.ofNullable(maximumAutoScalingGroupSizeOrNull));
        return new SailingApplicationReplicaSetDTO<String>(result.getName(), this.convertToSailingAnalyticsProcessDTO((SailingAnalyticsProcess<String>)((SailingAnalyticsProcess)result.getMaster()), Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase), Util.map((Iterable)result.getReplicas(), r -> {
            try {
                return this.convertToSailingAnalyticsProcessDTO((SailingAnalyticsProcess<String>)r, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }), release.getName(), this.getLandscapeService().getFullyQualifiedHostname(name, Optional.ofNullable(optionalDomainName)), this.getLandscapeService().getDefaultRedirectPath(result.getDefaultRedirectRule()), result.getAutoScalingGroup() == null ? null : result.getAutoScalingGroup().getLaunchTemplateDefaultVersion().launchTemplateData().imageId());
    }

    @Override
    public SailingApplicationReplicaSetDTO<String> deployApplicationToExistingHost(String replicaSetName, AwsInstanceDTO hostToDeployTo, String replicaInstanceType, boolean dynamicLoadBalancerMapping, String releaseNameOrNullForLatestMaster, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String masterReplicationBearerToken, String replicaReplicationBearerToken, String optionalDomainName, Integer optionalMinimumAutoScalingGroupSizeOrNull, Integer optionalMaximumAutoScalingGroupSizeOrNull, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull, Integer optionalIgtimiRiotPort, AwsInstanceDTO optionalPreferredInstanceToDeployUnmanagedReplicaTo) throws Exception {
        return this.deployApplicationToExistingHostInternal(replicaSetName, hostToDeployTo, replicaInstanceType, dynamicLoadBalancerMapping, releaseNameOrNullForLatestMaster, optionalKeyName, privateKeyEncryptionPassphrase, masterReplicationBearerToken, replicaReplicationBearerToken, optionalDomainName, optionalMinimumAutoScalingGroupSizeOrNull, optionalMaximumAutoScalingGroupSizeOrNull, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, optionalIgtimiRiotPort, optionalPreferredInstanceToDeployUnmanagedReplicaTo);
    }

    private <AppConfigBuilderT extends SailingAnalyticsMasterConfiguration.Builder<AppConfigBuilderT, String>, MultiServerDeployerBuilderT extends DeployProcessOnMultiServer.Builder<MultiServerDeployerBuilderT, String, SailingAnalyticsHost<String>, SailingAnalyticsMasterConfiguration<String>, AppConfigBuilderT>> SailingApplicationReplicaSetDTO<String> deployApplicationToExistingHostInternal(String replicaSetName, AwsInstanceDTO hostToDeployToDTO, String replicaInstanceType, boolean dynamicLoadBalancerMapping, String releaseNameOrNullForLatestMaster, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String masterReplicationBearerToken, String replicaReplicationBearerToken, String optionalDomainName, Integer optionalMinimumAutoScalingGroupSizeOrNull, Integer optionalMaximumAutoScalingGroupSizeOrNull, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull, Integer optionalIgtimiRiotPort, AwsInstanceDTO optionalPreferredInstanceToDeployUnmanagedReplicaTo) throws Exception {
        this.checkLandscapeManageAwsPermission();
        Release release = this.getLandscapeService().getRelease(releaseNameOrNullForLatestMaster);
        SailingAnalyticsHost<String> hostToDeployTo = this.getHostFromInstanceDTO(hostToDeployToDTO);
        SailingAnalyticsHost<String> hostToDeployReplicaTo = optionalPreferredInstanceToDeployUnmanagedReplicaTo == null ? null : this.getHostFromInstanceDTO(optionalPreferredInstanceToDeployUnmanagedReplicaTo);
        AwsApplicationReplicaSet result = this.getLandscapeService().deployApplicationToExistingHost(replicaSetName, hostToDeployTo, replicaInstanceType, dynamicLoadBalancerMapping, release.getName(), optionalKeyName, privateKeyEncryptionPassphrase, masterReplicationBearerToken, replicaReplicationBearerToken, optionalDomainName, Optional.ofNullable(optionalMinimumAutoScalingGroupSizeOrNull), Optional.ofNullable(optionalMaximumAutoScalingGroupSizeOrNull), optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, optionalIgtimiRiotPort, Optional.of(hostToDeployTo.getInstance().instanceType()), Optional.ofNullable(hostToDeployReplicaTo));
        return new SailingApplicationReplicaSetDTO<String>(result.getName(), this.convertToSailingAnalyticsProcessDTO((SailingAnalyticsProcess<String>)((SailingAnalyticsProcess)result.getMaster()), Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase), Util.map((Iterable)result.getReplicas(), r -> {
            try {
                return this.convertToSailingAnalyticsProcessDTO((SailingAnalyticsProcess<String>)r, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }), release.getName(), this.getLandscapeService().getFullyQualifiedHostname(replicaSetName, Optional.ofNullable(optionalDomainName)), this.getLandscapeService().getDefaultRedirectPath(result.getDefaultRedirectRule()), result.getAutoScalingGroup() == null ? null : result.getAutoScalingGroup().getLaunchTemplateDefaultVersion().launchTemplateData().imageId());
    }

    @Override
    public void defineDefaultRedirect(String regionId, String hostname, RedirectDTO redirect, String keyName, String passphraseForPrivateKeyDecryption) {
        ApplicationLoadBalancer loadBalancer = this.getLandscape().getLoadBalancerByHostname(hostname);
        loadBalancer.setDefaultRedirect(hostname, redirect.getPath(), redirect.getQuery());
    }

    @Override
    public SerializationDummyDTO serializationDummy(ProcessDTO mongoProcessDTO, AwsInstanceDTO awsInstanceDTO, AwsShardDTO shardDTO, SailingApplicationReplicaSetDTO<String> sailingApplicationReplicationSetDTO, LeaderboardNameDTO leaderboard) {
        return null;
    }

    @Override
    public Util.Triple<DataImportProgress, CompareServersResultDTO, String> archiveReplicaSet(String regionId, SailingApplicationReplicaSetDTO<String> applicationReplicaSetToArchive, String bearerTokenOrNullForApplicationReplicaSetToArchive, String bearerTokenOrNullForArchive, Duration durationToWaitBeforeCompareServers, int maxNumberOfCompareServerAttempts, boolean removeApplicationReplicaSet, MongoEndpointDTO moveDatabaseHere, String optionalKeyName, byte[] passphraseForPrivateKeyDecryption) throws Exception {
        this.checkLandscapeManageAwsPermission();
        if (removeApplicationReplicaSet) {
            this.getSecurityService().checkCurrentUserDeletePermission(SecuredSecurityTypes.SERVER.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{applicationReplicaSetToArchive.getReplicaSetName()})));
        }
        Util.Triple result = this.getLandscapeService().archiveReplicaSet(regionId, this.convertFromApplicationReplicaSetDTO(new AwsRegion(regionId, this.getLandscape()), applicationReplicaSetToArchive, optionalKeyName, passphraseForPrivateKeyDecryption), bearerTokenOrNullForApplicationReplicaSetToArchive, bearerTokenOrNullForArchive, durationToWaitBeforeCompareServers, maxNumberOfCompareServerAttempts, removeApplicationReplicaSet, this.getMongoEndpoint(moveDatabaseHere), optionalKeyName, passphraseForPrivateKeyDecryption);
        String mongoDBArchivingFailureReason = (String)result.getC();
        CompareServersResultDTO compareServersResultDTO = this.createCompareServersResultDTO((Util.Triple<DataImportProgress, CompareServersResult, String>)result);
        return new Util.Triple((Object)((DataImportProgress)result.getA()), (Object)compareServersResultDTO, (Object)mongoDBArchivingFailureReason);
    }

    private CompareServersResultDTO createCompareServersResultDTO(Util.Triple<DataImportProgress, CompareServersResult, String> compareServersResult) {
        return compareServersResult == null ? null : new CompareServersResultDTO(compareServersResult.getB() == null ? null : ((CompareServersResult)compareServersResult.getB()).getServerA(), compareServersResult.getB() == null ? null : ((CompareServersResult)compareServersResult.getB()).getServerB(), compareServersResult.getB() == null ? null : ((CompareServersResult)compareServersResult.getB()).getADiffs().toString(), compareServersResult.getB() == null ? null : ((CompareServersResult)compareServersResult.getB()).getBDiffs().toString());
    }

    @Override
    public String removeApplicationReplicaSet(String regionId, SailingApplicationReplicaSetDTO<String> applicationReplicaSetToRemove, MongoEndpointDTO moveDatabaseHere, String optionalKeyName, byte[] passphraseForPrivateKeyDecryption) throws Exception {
        this.checkLandscapeManageAwsPermission();
        this.getSecurityService().checkCurrentUserDeletePermission(SecuredSecurityTypes.SERVER.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{applicationReplicaSetToRemove.getReplicaSetName()})));
        String mongoDbArchivingErrorMessage = this.getLandscapeService().removeApplicationReplicaSet(regionId, this.convertFromApplicationReplicaSetDTO(new AwsRegion(regionId, this.getLandscape()), applicationReplicaSetToRemove, optionalKeyName, passphraseForPrivateKeyDecryption), this.getMongoEndpoint(moveDatabaseHere), optionalKeyName, passphraseForPrivateKeyDecryption);
        return mongoDbArchivingErrorMessage;
    }

    private AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> convertFromApplicationReplicaSetDTO(AwsRegion region, SailingApplicationReplicaSetDTO<String> applicationReplicaSetDTO, String optionalKeyName, byte[] passphraseForPrivateKeyDecryption) throws Exception {
        SailingAnalyticsProcess<String> master = this.getSailingAnalyticsProcessFromDTO(applicationReplicaSetDTO.getMaster());
        AwsApplicationReplicaSet applicationReplicaSet = this.getLandscape().getApplicationReplicaSet((Region)region, applicationReplicaSetDTO.getReplicaSetName(), master, master.getReplicas(Landscape.WAIT_FOR_PROCESS_TIMEOUT, (HostSupplier)new SailingAnalyticsHostSupplier(), (ProcessFactory)new SailingAnalyticsProcessFactory(this::getLandscape)), Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption);
        return applicationReplicaSet;
    }

    private SailingAnalyticsProcess<String> getSailingAnalyticsProcessFromDTO(SailingAnalyticsProcessDTO processDTO) throws UnknownHostException {
        return new SailingAnalyticsProcessImpl(processDTO.getPort(), this.getHostFromInstanceDTO(processDTO.getHost()), processDTO.getServerDirectory(), Integer.valueOf(processDTO.getExpeditionUdpPort()), processDTO.getIgtimiRiotPort(), this.getLandscape());
    }

    private SailingAnalyticsHost<String> getHostFromInstanceDTO(AwsInstanceDTO hostDTO) throws UnknownHostException {
        return new SailingAnalyticsHostImpl(hostDTO.getInstanceId(), (AwsAvailabilityZone)new AwsAvailabilityZoneImpl((AvailabilityZone)AvailabilityZone.builder().regionName(hostDTO.getRegion()).zoneId(hostDTO.getAvailabilityZoneId()).build(), this.getLandscape()), InetAddress.getByName(hostDTO.getPrivateIpAddress()), hostDTO.getLaunchTimePoint(), this.getLandscape(), (ProcessFactory)new SailingAnalyticsProcessFactory(this::getLandscape));
    }

    @Override
    public SailingApplicationReplicaSetDTO<String> createDefaultLoadBalancerMappings(String regionId, SailingApplicationReplicaSetDTO<String> applicationReplicaSetToCreateLoadBalancerMappingFor, boolean useDynamicLoadBalancer, String optionalDomainName, boolean forceDNSUpdate) throws Exception {
        CreateDynamicLoadBalancerMapping.Builder createLoadBalancerMappingBuilder;
        this.checkLandscapeManageAwsPermission();
        logger.info("Creating default load balancer mappings in region " + regionId + " for application replica set " + applicationReplicaSetToCreateLoadBalancerMappingFor.getName() + " on behalf of " + SecurityUtils.getSubject().getPrincipal());
        SailingAnalyticsProcess<String> master = this.getSailingAnalyticsProcessFromDTO(applicationReplicaSetToCreateLoadBalancerMappingFor.getMaster());
        if (useDynamicLoadBalancer) {
            createLoadBalancerMappingBuilder = CreateDynamicLoadBalancerMapping.builder();
        } else {
            CreateDNSBasedLoadBalancerMapping.Builder withDNSBuilder = CreateDNSBasedLoadBalancerMapping.builder();
            withDNSBuilder.forceDNSUpdate(forceDNSUpdate);
            createLoadBalancerMappingBuilder = withDNSBuilder;
        }
        String domainName = Optional.ofNullable(optionalDomainName).orElse("sapsailing.com");
        String masterHostname = applicationReplicaSetToCreateLoadBalancerMappingFor.getHostname() == null ? (String.valueOf(applicationReplicaSetToCreateLoadBalancerMappingFor.getName()) + "." + domainName).toLowerCase() : applicationReplicaSetToCreateLoadBalancerMappingFor.getHostname().toLowerCase();
        CreateLoadBalancerMapping createLoadBalancerMapping = (CreateLoadBalancerMapping)((CreateLoadBalancerMapping.Builder)((CreateLoadBalancerMapping.Builder)createLoadBalancerMappingBuilder.setProcess(master).setHostname(masterHostname).setTargetGroupNamePrefix("S-")).setSecurityGroupForVpc(this.getLandscape().getDefaultSecurityGroupForApplicationHosts((Region)new AwsRegion(regionId, this.getLandscape()))).setLandscape(this.getLandscape())).build();
        createLoadBalancerMapping.run();
        PlainRedirectDTO defaultRedirect = new PlainRedirectDTO();
        return new SailingApplicationReplicaSetDTO<String>(applicationReplicaSetToCreateLoadBalancerMappingFor.getName(), applicationReplicaSetToCreateLoadBalancerMappingFor.getMaster(), applicationReplicaSetToCreateLoadBalancerMappingFor.getReplicas(), applicationReplicaSetToCreateLoadBalancerMappingFor.getVersion(), applicationReplicaSetToCreateLoadBalancerMappingFor.getHostname(), RedirectDTO.toString((String)defaultRedirect.getPath(), (Optional)defaultRedirect.getQuery()), applicationReplicaSetToCreateLoadBalancerMappingFor.getAutoScalingGroupAmiId());
    }

    @Override
    public Boolean ensureAtLeastOneReplicaExistsStopReplicatingAndRemoveMasterFromTargetGroups(String regionId, SailingApplicationReplicaSetDTO<String> applicationReplicaSet, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String replicaReplicationBearerToken) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(regionId, this.getLandscape());
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet = this.convertFromApplicationReplicaSetDTO(region, applicationReplicaSet, optionalKeyName, privateKeyEncryptionPassphrase);
        String effectiveReplicaReplicationBearerToken = this.getLandscapeService().getEffectiveBearerToken(replicaReplicationBearerToken);
        SailingAnalyticsProcess additionalReplicaStarted = this.getLandscapeService().ensureAtLeastOneReplicaExistsStopReplicatingAndRemoveMasterFromTargetGroups(replicaSet, optionalKeyName, privateKeyEncryptionPassphrase, effectiveReplicaReplicationBearerToken);
        if (additionalReplicaStarted != null) {
            return true;
        }
        return false;
    }

    @Override
    public SailingApplicationReplicaSetDTO<String> upgradeApplicationReplicaSet(String regionId, SailingApplicationReplicaSetDTO<String> applicationReplicaSetToUpgrade, String releaseOrNullForLatestMaster, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String replicaReplicationBearerToken) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(regionId, this.getLandscape());
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet = this.convertFromApplicationReplicaSetDTO(region, applicationReplicaSetToUpgrade, optionalKeyName, privateKeyEncryptionPassphrase);
        AwsApplicationReplicaSet upgradedReplicaSet = this.getLandscapeService().upgradeApplicationReplicaSet(region, replicaSet, releaseOrNullForLatestMaster, optionalKeyName, privateKeyEncryptionPassphrase, replicaReplicationBearerToken);
        SailingAnalyticsProcess oldMaster = (SailingAnalyticsProcess)replicaSet.getMaster();
        Release release = upgradedReplicaSet.getVersion(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        return new SailingApplicationReplicaSetDTO<String>(applicationReplicaSetToUpgrade.getName(), this.convertToSailingAnalyticsProcessDTO((SailingAnalyticsProcess<String>)oldMaster, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase), Util.map((Iterable)upgradedReplicaSet.getReplicas(), r -> {
            try {
                return this.convertToSailingAnalyticsProcessDTO((SailingAnalyticsProcess<String>)r, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }), release.getName(), applicationReplicaSetToUpgrade.getHostname(), applicationReplicaSetToUpgrade.getDefaultRedirectPath(), applicationReplicaSetToUpgrade.getAutoScalingGroupAmiId());
    }

    @Override
    public ArrayList<ReleaseDTO> getReleases() {
        return Util.mapToArrayList((Iterable)SailingReleaseRepository.INSTANCE, r -> new ReleaseDTO(r.getName(), r.getBaseName(), r.getCreationDate()));
    }

    @Override
    public ArrayList<SailingApplicationReplicaSetDTO<String>> updateImageForReplicaSets(String regionId, ArrayList<SailingApplicationReplicaSetDTO<String>> applicationReplicaSetsToUpdate, AmazonMachineImageDTO amiDTOOrNullForLatest, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(regionId, this.getLandscape());
        AmazonMachineImage ami = amiDTOOrNullForLatest == null ? null : this.getLandscape().getImage((Region)region, amiDTOOrNullForLatest.getId());
        Iterable replicaSets = Util.map(applicationReplicaSetsToUpdate, rsDTO -> {
            try {
                return this.convertFromApplicationReplicaSetDTO(region, (SailingApplicationReplicaSetDTO<String>)rsDTO, optionalKeyName, privateKeyEncryptionPassphrase);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Iterable updatedReplicaSets = this.getLandscapeService().updateImageForReplicaSets(region, replicaSets, Optional.ofNullable(ami), Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        ArrayList<SailingApplicationReplicaSetDTO<String>> result = new ArrayList<SailingApplicationReplicaSetDTO<String>>();
        for (AwsApplicationReplicaSet updatedReplicaSet : updatedReplicaSets) {
            result.add(this.convertToSailingApplicationReplicaSetDTO((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)updatedReplicaSet, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase));
        }
        return result;
    }

    @Override
    public SailingApplicationReplicaSetDTO<String> useDedicatedAutoScalingReplicasInsteadOfShared(SailingApplicationReplicaSetDTO<String> applicationReplicaSetDTO, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(applicationReplicaSetDTO.getMaster().getHost().getRegion(), this.getLandscape());
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet = this.convertFromApplicationReplicaSetDTO(region, applicationReplicaSetDTO, optionalKeyName, privateKeyEncryptionPassphrase);
        return this.convertToSailingApplicationReplicaSetDTO((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)this.getLandscapeService().useDedicatedAutoScalingReplicasInsteadOfShared(replicaSet, optionalKeyName, privateKeyEncryptionPassphrase), Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
    }

    @Override
    public SailingApplicationReplicaSetDTO<String> useSingleSharedInsteadOfDedicatedAutoScalingReplica(SailingApplicationReplicaSetDTO<String> applicationReplicaSetDTO, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String replicaReplicationBearerToken, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull, String optionalSharedReplicaInstanceType) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(applicationReplicaSetDTO.getMaster().getHost().getRegion(), this.getLandscape());
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet = this.convertFromApplicationReplicaSetDTO(region, applicationReplicaSetDTO, optionalKeyName, privateKeyEncryptionPassphrase);
        return this.convertToSailingApplicationReplicaSetDTO((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)this.getLandscapeService().useSingleSharedInsteadOfDedicatedAutoScalingReplica(replicaSet, optionalKeyName, privateKeyEncryptionPassphrase, replicaReplicationBearerToken, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, optionalSharedReplicaInstanceType == null ? Optional.empty() : Optional.of(InstanceType.valueOf((String)optionalSharedReplicaInstanceType))), Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
    }

    @Override
    public SailingApplicationReplicaSetDTO<String> moveMasterToOtherInstance(SailingApplicationReplicaSetDTO<String> applicationReplicaSetDTO, boolean useSharedInstance, String optionalInstanceTypeOrNull, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, String optionalMasterReplicationBearerTokenOrNull, String optionalReplicaReplicationBearerTokenOrNull, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(applicationReplicaSetDTO.getMaster().getHost().getRegion(), this.getLandscape());
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet = this.convertFromApplicationReplicaSetDTO(region, applicationReplicaSetDTO, optionalKeyName, privateKeyEncryptionPassphrase);
        return this.convertToSailingApplicationReplicaSetDTO((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)this.getLandscapeService().moveMasterToOtherInstance(replicaSet, useSharedInstance, optionalInstanceTypeOrNull == null ? Optional.empty() : Optional.of(InstanceType.valueOf((String)optionalInstanceTypeOrNull)), Optional.empty(), optionalKeyName, privateKeyEncryptionPassphrase, optionalMasterReplicationBearerTokenOrNull, optionalReplicaReplicationBearerTokenOrNull, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull), Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
    }

    @Override
    public SailingApplicationReplicaSetDTO<String> changeAutoScalingReplicasInstanceType(SailingApplicationReplicaSetDTO<String> applicationReplicaSetDTO, String instanceTypeName, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(applicationReplicaSetDTO.getMaster().getHost().getRegion(), this.getLandscape());
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet = this.convertFromApplicationReplicaSetDTO(region, applicationReplicaSetDTO, optionalKeyName, privateKeyEncryptionPassphrase);
        return this.convertToSailingApplicationReplicaSetDTO((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)this.getLandscapeService().changeAutoScalingReplicasInstanceType(replicaSet, InstanceType.valueOf((String)instanceTypeName), Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase), Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
    }

    @Override
    public ArrayList<LeaderboardNameDTO> getLeaderboardNames(SailingApplicationReplicaSetDTO<String> replicaSet, String bearerToken) throws Exception {
        SailingServer server = this.getLandscapeService().getSailingServer(replicaSet.getHostname(), bearerToken, Optional.of(443));
        return new ArrayList<LeaderboardNameDTO>(Util.asList((Iterable)Util.map((Iterable)server.getLeaderboardNames(), LeaderboardNameDTO::new)));
    }

    @Override
    public void addShard(String shardName, ArrayList<LeaderboardNameDTO> selectedLeaderBoardNames, SailingApplicationReplicaSetDTO<String> replicaSetDTO, String bearerToken, String region, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion awsRegion = new AwsRegion(replicaSetDTO.getMaster().getHost().getRegion(), this.getLandscape());
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> awsReplicaSet = this.convertFromApplicationReplicaSetDTO(awsRegion, replicaSetDTO, optionalKeyName, privateKeyEncryptionPassphrase);
        this.getLandscapeService().addShard(Util.map(selectedLeaderBoardNames, t -> t.getName()), awsReplicaSet, awsRegion, bearerToken, shardName);
    }

    @Override
    public Map<AwsShardDTO, Iterable<String>> getShards(SailingApplicationReplicaSetDTO<String> replicaSetDTO, String region, String bearerToken, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion awsRegion = new AwsRegion(replicaSetDTO.getMaster().getHost().getRegion(), this.getLandscape());
        HashMap<AwsShardDTO, Iterable> shardingKeysForShards = new HashMap<AwsShardDTO, Iterable>();
        SailingServer server = this.getLandscapeService().getSailingServer(replicaSetDTO.getHostname(), bearerToken, Optional.empty());
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> applicationServerReplicaSet = this.convertFromApplicationReplicaSetDTO(awsRegion, replicaSetDTO, optionalKeyName, privateKeyEncryptionPassphrase);
        HashMap<String, String> leaderboardNamesByShardingKeys = new HashMap<String, String>();
        for (String string : server.getLeaderboardNames()) {
            leaderboardNamesByShardingKeys.put(server.getLeaderboardShardingKey(string), string);
        }
        for (Map.Entry entry : applicationServerReplicaSet.getShards().entrySet()) {
            shardingKeysForShards.put(this.createAwsShardDTO((AwsShard<String>)((AwsShard)entry.getKey()), applicationServerReplicaSet.getName(), server, leaderboardNamesByShardingKeys), (Iterable)entry.getValue());
        }
        HashMap<AwsShardDTO, Iterable<String>> hashMap = new HashMap<AwsShardDTO, Iterable<String>>();
        for (Map.Entry entry : shardingKeysForShards.entrySet()) {
            hashMap.put((AwsShardDTO)entry.getKey(), (Iterable)entry.getValue());
        }
        return hashMap;
    }

    @Override
    public void removeShard(AwsShardDTO shard, SailingApplicationReplicaSetDTO<String> replicaSetDTO, String region, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion awsRegion = new AwsRegion(replicaSetDTO.getMaster().getHost().getRegion(), this.getLandscape());
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> applicationServerReplicaSet = this.convertFromApplicationReplicaSetDTO(awsRegion, replicaSetDTO, optionalKeyName, privateKeyEncryptionPassphrase);
        this.getLandscapeService().removeShard(applicationServerReplicaSet, shard.getTargetgroupArn());
    }

    @Override
    public void appendShardingKeysToShard(Iterable<LeaderboardNameDTO> sharindKeysToAppend, String region, String shardName, SailingApplicationReplicaSetDTO<String> replicaSet, String bearerToken, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion awsRegion = new AwsRegion(replicaSet.getMaster().getHost().getRegion(), this.getLandscape());
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> rs = this.convertFromApplicationReplicaSetDTO(awsRegion, replicaSet, optionalKeyName, privateKeyEncryptionPassphrase);
        AwsApplicationReplicaSet applicationReplicaSet = this.getLandscape().getApplicationReplicaSet((Region)awsRegion, rs.getServerName(), (AwsApplicationProcess)((SailingAnalyticsProcess)rs.getMaster()), rs.getReplicas(), Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), privateKeyEncryptionPassphrase);
        this.getLandscapeService().appendShardingKeysToShard(Util.map(sharindKeysToAppend, t -> t.getName()), applicationReplicaSet, awsRegion, shardName, bearerToken);
    }

    @Override
    public void removeShardingKeysFromShard(Iterable<LeaderboardNameDTO> selectedShardingKeys, String region, String shardName, SailingApplicationReplicaSetDTO<String> replicaSet, String bearerToken, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.checkLandscapeManageAwsPermission();
        AwsRegion awsRegion = new AwsRegion(region, this.getLandscape());
        AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> rs = this.convertFromApplicationReplicaSetDTO(awsRegion, replicaSet, optionalKeyName, privateKeyEncryptionPassphrase);
        this.getLandscapeService().removeShardingKeysFromShard((Iterable)Util.asList((Iterable)Util.map(selectedShardingKeys, t -> t.getName())), rs, awsRegion, shardName, bearerToken);
    }

    private AwsShardDTO createAwsShardDTO(AwsShard<String> shard, String replicaSetName, SailingServer server, Map<String, String> leaderboardNamesByShardingKeys) throws Exception {
        return new AwsShardDTO(Util.filter((Iterable)Util.map((Iterable)shard.getKeys(), shardingKey -> (String)leaderboardNamesByShardingKeys.get(shardingKey)), leaderboardName -> leaderboardName != null), shard.getTargetGroup().getTargetGroupArn(), shard.getTargetGroup().getName(), shard.getAutoScalingGroup().getAutoScalingGroup().autoScalingGroupARN(), shard.getTargetGroup().getLoadBalancerArn(), shard.getAutoScalingGroup().getName(), shard.getName() == null ? "" : shard.getName(), replicaSetName);
    }

    @Override
    public void moveAllApplicationProcessesAwayFrom(AwsInstanceDTO host, String optionalInstanceTypeForNewInstance, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.checkLandscapeManageAwsPermission();
        SailingAnalyticsHost<String> sailingAnalyticsHost = this.getHostFromInstanceDTO(host);
        this.getLandscapeService().moveAllApplicationProcessesAwayFrom(sailingAnalyticsHost, Optional.ofNullable(optionalInstanceTypeForNewInstance == null ? null : InstanceType.valueOf((String)optionalInstanceTypeForNewInstance)), optionalKeyName, privateKeyEncryptionPassphrase);
    }

    @Override
    public boolean hasDNSResourceRecordsForReplicaSet(String replicaSetName, String optionalDomainName) {
        LandscapeService landscapeService;
        String hostname;
        AwsLandscape<String> landscape = this.getLandscape();
        Iterable existingDNSRulesForHostname = landscape.getResourceRecordSets(hostname = (landscapeService = this.getLandscapeService()).getHostname(replicaSetName, optionalDomainName));
        return existingDNSRulesForHostname != null && !Util.isEmpty((Iterable)existingDNSRulesForHostname);
    }
}

