/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.impl.CombinedWindTrackImpl;
import com.sap.sailing.domain.tracking.impl.VirtualWindFixesAsNavigableSet;
import com.sap.sailing.domain.tracking.impl.WindTrackImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.NavigableSet;

public class CombinedWindAsNavigableSet
extends VirtualWindFixesAsNavigableSet {
    private static final long serialVersionUID = -153959652212518644L;

    public CombinedWindAsNavigableSet(CombinedWindTrackImpl track, TrackedRace trackedRace, long resolutionInMilliseconds) {
        super(track, trackedRace, resolutionInMilliseconds);
    }

    public CombinedWindAsNavigableSet(WindTrack track, TrackedRace trackedRace, TimePoint from, TimePoint to, long resolutionInMilliseconds) {
        super(track, trackedRace, from, to, resolutionInMilliseconds);
    }

    @Override
    protected CombinedWindTrackImpl getTrack() {
        return (CombinedWindTrackImpl)super.getTrack();
    }

    @Override
    protected Wind getWind(Position p, TimePoint timePoint) {
        return this.getTrackedRace().getWind(p, timePoint);
    }

    @Override
    protected NavigableSet<Wind> createSubset(WindTrack track, TrackedRace trackedRace, TimePoint from, TimePoint to) {
        return new CombinedWindAsNavigableSet(track, trackedRace, from, to, this.getResolutionInMilliseconds());
    }

    @Override
    protected TimePoint getTo() {
        return this.getToInternal() == null ? (this.getTrackedRace().getEndOfRace() == null ? (this.getTrackedRace().getTimePointOfLastEvent() == null ? new MillisecondsTimePoint(1L) : this.getTrackedRace().getTimePointOfLastEvent()) : this.ceilingToResolution(this.getTrackedRace().getEndOfRace())) : this.getToInternal();
    }

    @Override
    protected WindTrackImpl.DummyWind createDummyWindFix(TimePoint timePoint) {
        return new WindTrackImpl.DummyWind(timePoint, this.getTrack().getDefaultPosition(timePoint));
    }
}

